/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LazySet;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.springframework.orm.ObjectRetrievalFailureException;

public class ResponseTimeResourceType
implements OnmsResourceType {
    private ResourceDao m_resourceDao;
    private NodeDao m_nodeDao;

    public ResponseTimeResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getLabel() {
        return "Response Time";
    }

    public String getName() {
        return "responseTime";
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        List<OnmsResource> empty = Collections.emptyList();
        return empty;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        OnmsNode node = (OnmsNode)this.m_nodeDao.get(nodeId);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)nodeId, "Could not find node for node Id " + nodeId, null);
        }
        for (OnmsIpInterface i : node.getIpInterfaces()) {
            String ipAddr = InetAddressUtils.str((InetAddress)i.getIpAddress());
            File iface = this.getInterfaceDirectory(ipAddr, false);
            if (!iface.isDirectory()) continue;
            resources.add(this.createResource(i));
        }
        return resources;
    }

    private File getInterfaceDirectory(String ipAddr, boolean verify) {
        File response = new File(this.m_resourceDao.getRrdDirectory(verify), "response");
        File intfDir = new File(response, ipAddr);
        if (verify && !intfDir.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No interface directory exists for " + ipAddr + ": " + intfDir));
        }
        return intfDir;
    }

    private String getRelativeInterfacePath(String ipAddr) {
        return "response" + File.separator + ipAddr;
    }

    private OnmsResource createResource(OnmsIpInterface ipInterface) {
        String intf;
        String label = intf = InetAddressUtils.str((InetAddress)ipInterface.getIpAddress());
        String resource = intf;
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(intf));
        OnmsResource r = new OnmsResource(resource, label, (OnmsResourceType)this, (Set)set);
        r.setEntity((OnmsEntity)ipInterface);
        return r;
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.getResourcesForNode(nodeId).size() > 0;
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/interface.jsp?node=" + resource.getParent().getName() + "&intf=" + resource.getName();
    }

    public boolean isResourceTypeOnNodeSource(String nodeSource, int nodeId) {
        return this.getResourcesForNodeSource(nodeSource, nodeId).size() > 0;
    }

    public List<OnmsResource> getResourcesForNodeSource(String nodeSource, int nodeId) {
        return this.getResourcesForNode(nodeId);
    }

    public class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private String m_intf;

        public AttributeLoader(String intf) {
            this.m_intf = intf;
        }

        public Set<OnmsAttribute> load() {
            LogUtils.debugf((Object)this, (String)"lazy-loading attributes for response time resource '%s'", (Object[])new Object[]{this.m_intf});
            return ResourceTypeUtils.getAttributesAtRelativePath(ResponseTimeResourceType.this.m_resourceDao.getRrdDirectory(), ResponseTimeResourceType.this.getRelativeInterfacePath(this.m_intf));
        }
    }
}

