/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.opennms.core.utils.PropertiesCache;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.opennms.netmgt.rrd.RrdUtils;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public abstract class ResourceTypeUtils {
    public static String DS_PROPERTIES_FILE = "ds.properties";
    private static PropertiesCache s_cache = new PropertiesCache();

    public static Set<OnmsAttribute> getAttributesAtRelativePath(File rrdDirectory, String relativePath) {
        HashSet<OnmsAttribute> attributes = new HashSet<OnmsAttribute>();
        ResourceTypeUtils.loadRrdAttributes(rrdDirectory, relativePath, attributes);
        ResourceTypeUtils.loadStringAttributes(rrdDirectory, relativePath, attributes);
        return attributes;
    }

    private static void loadStringAttributes(File rrdDirectory, String relativePath, Set<OnmsAttribute> attributes) {
        Properties properties = ResourceTypeUtils.getStringProperties(rrdDirectory, relativePath);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                attributes.add((OnmsAttribute)new StringPropertyAttribute(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
    }

    private static void loadRrdAttributes(File rrdDirectory, String relativePath, Set<OnmsAttribute> attributes) {
        int suffixLength = RrdFileConstants.getRrdSuffix().length();
        File resourceDir = new File(rrdDirectory, relativePath);
        File[] files = resourceDir.listFiles(RrdFileConstants.RRD_FILENAME_FILTER);
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (ResourceTypeUtils.isStoreByGroup() && !ResourceTypeUtils.isResponseTime(relativePath)) {
                String groupName = fileName.substring(0, fileName.length() - suffixLength);
                Properties props = ResourceTypeUtils.getDsProperties(resourceDir);
                for (Object o : props.keySet()) {
                    String dsName = (String)o;
                    if (!props.getProperty(dsName).equals(groupName)) continue;
                    attributes.add((OnmsAttribute)new RrdGraphAttribute(dsName, relativePath, fileName));
                }
                continue;
            }
            String dsName = fileName.substring(0, fileName.length() - suffixLength);
            attributes.add((OnmsAttribute)new RrdGraphAttribute(dsName, relativePath, fileName));
        }
    }

    public static Properties getDsProperties(File directory) {
        File propertiesFile = new File(directory, DS_PROPERTIES_FILE);
        try {
            return s_cache.getProperties(propertiesFile);
        }
        catch (IOException e) {
            ResourceTypeUtils.log().error("ds.properties error: " + e, (Throwable)e);
            return new Properties();
        }
    }

    public static File getRrdFileForDs(File directory, String ds) {
        String rrdBaseName = ds;
        if (ResourceTypeUtils.isStoreByGroup()) {
            try {
                rrdBaseName = s_cache.getProperty(new File(directory, DS_PROPERTIES_FILE), ds);
            }
            catch (IOException e) {
                ResourceTypeUtils.log().error("ds.properties error: " + e, (Throwable)e);
                rrdBaseName = ds;
            }
        }
        return new File(directory, rrdBaseName + RrdUtils.getExtension());
    }

    public static boolean isStoreByGroup() {
        return Boolean.getBoolean("org.opennms.rrd.storeByGroup");
    }

    public static boolean isResponseTime(String relativePath) {
        return Pattern.matches("^response.+$", relativePath);
    }

    public static Properties getStringProperties(File rrdDirectory, String relativePath) {
        Assert.notNull((Object)rrdDirectory, (String)"rrdDirectory argument must not be null");
        Assert.notNull((Object)relativePath, (String)"relativePath argument must not be null");
        File resourceDir = new File(rrdDirectory, relativePath);
        return ResourceTypeUtils.getStringProperties(resourceDir);
    }

    private static Properties getStringProperties(File resourceDir) {
        Assert.notNull((Object)resourceDir, (String)"resourceDir argumnet must not be null");
        return ResourceTypeUtils.getProperties(new File(resourceDir, "strings.properties"));
    }

    public static Properties getProperties(File file) {
        try {
            return s_cache.findProperties(file);
        }
        catch (IOException e) {
            String message = "loadProperties: Error opening properties file " + file.getAbsolutePath() + ": " + e;
            ResourceTypeUtils.log().warn(message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
    }

    public static ThreadCategory log() {
        return ThreadCategory.getInstance();
    }

    public static void saveUpdatedProperties(File propertiesFile, Properties props) throws FileNotFoundException, IOException {
        s_cache.saveProperties(propertiesFile, props);
    }

    public static void updateDsProperties(File resourceDir, Map<String, String> dsNamesToRrdNames) {
        try {
            s_cache.updateProperties(new File(resourceDir, DS_PROPERTIES_FILE), dsNamesToRrdNames);
        }
        catch (IOException e) {
            ResourceTypeUtils.log().error("Unable to save DataSource Properties file: " + e, (Throwable)e);
        }
    }

    public static void updateStringProperty(File resourceDir, String attrVal, String attrName) throws FileNotFoundException, IOException {
        File propertiesFile = new File(resourceDir, "strings.properties");
        s_cache.setProperty(propertiesFile, attrName, attrVal);
    }

    public static String getStringProperty(File directory, String key) {
        File file = new File(directory, "strings.properties");
        try {
            return s_cache.getProperty(file, key);
        }
        catch (IOException e) {
            String message = "loadProperties: Error opening properties file " + file.getAbsolutePath() + ": " + e;
            ResourceTypeUtils.log().warn(message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
    }

    public static File getRelativeNodeSourceDirectory(String nodeSource) {
        String[] ident = nodeSource.split(":");
        return new File("fs", File.separator + ident[0] + File.separator + ident[1]);
    }
}

