/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.Timestamp;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.VlanDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsVlan;

public class VlanDaoHibernate
extends AbstractDaoHibernate<OnmsVlan, Integer>
implements VlanDao {
    public VlanDaoHibernate() {
        super(OnmsVlan.class);
    }

    @Override
    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsVlan vlan : this.findMatching(criteria)) {
            vlan.setStatus(Character.valueOf('D'));
            this.saveOrUpdate(vlan);
        }
    }

    @Override
    public void deactivateForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)"A"));
        for (OnmsVlan item : this.findMatching(criteria)) {
            item.setStatus(Character.valueOf('N'));
            this.saveOrUpdate(item);
        }
    }

    @Override
    public void deleteForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)"A")));
        for (OnmsVlan item : this.findMatching(criteria)) {
            this.delete(item);
        }
    }

    @Override
    public void setStatusForNode(Integer nodeId, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        for (OnmsVlan item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    @Override
    public OnmsVlan findByNodeAndVlan(Integer nodeId, Integer vlanId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsVlan.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"vlanId", (Object)vlanId));
        List objects = this.findMatching(criteria);
        if (objects != null && objects.size() > 0) {
            return (OnmsVlan)objects.get(0);
        }
        return null;
    }
}

