/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.SurveillanceStatus;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.util.StringUtils;

public class NodeDaoHibernate
extends AbstractDaoHibernate<OnmsNode, Integer>
implements NodeDao {
    public NodeDaoHibernate() {
        super(OnmsNode.class);
    }

    @Override
    public OnmsNode get(String lookupCriteria) {
        if (lookupCriteria.contains(":")) {
            String[] criteria = lookupCriteria.split(":");
            return this.findByForeignId(criteria[0], criteria[1]);
        }
        return (OnmsNode)this.get(Integer.parseInt(lookupCriteria));
    }

    @Override
    public String getLabelForId(Integer id) {
        String label = null;
        label = this.findObjects(String.class, "select n.label from OnmsNode as n where n.id = ?", id).get(0);
        return label;
    }

    @Override
    public List<OnmsNode> findNodes(OnmsDistPoller distPoller) {
        return this.find("from OnmsNode where distPoller = ?", distPoller);
    }

    @Override
    public OnmsNode getHierarchy(Integer id) {
        OnmsNode node = (OnmsNode)this.findUnique("select distinct n from OnmsNode as n left join fetch n.assetRecord where n.id = ?", id);
        this.initialize(node.getIpInterfaces());
        for (OnmsIpInterface i : node.getIpInterfaces()) {
            this.initialize(i.getMonitoredServices());
        }
        this.initialize(node.getSnmpInterfaces());
        for (OnmsIpInterface i : node.getSnmpInterfaces()) {
            this.initialize(i.getIpInterfaces());
        }
        return node;
    }

    @Override
    public List<OnmsNode> findByLabel(String label) {
        return this.find("from OnmsNode as n where n.label = ?", label);
    }

    @Override
    public List<OnmsNode> findAllByVarCharAssetColumn(String columnName, String columnValue) {
        return this.find("from OnmsNode as n where n.assetRecord." + columnName + " = ?", columnValue);
    }

    @Override
    public List<OnmsNode> findAllByVarCharAssetColumnCategoryList(String columnName, String columnValue, Collection<OnmsCategory> categories) {
        return this.find("select distinct n from OnmsNode as n join n.categories as c left join fetch n.assetRecord left join fetch n.ipInterfaces as ipInterface left join fetch ipInterface.monitoredServices as monSvc left join fetch monSvc.serviceType left join fetch monSvc.currentOutages where n.assetRecord." + columnName + " = ? " + "and c.name in (" + this.categoryListToNameList(categories) + ")", columnValue);
    }

    @Override
    public List<OnmsNode> findByCategory(OnmsCategory category) {
        return this.find("select distinct n from OnmsNode as n join n.categories c left join fetch n.assetRecord left join fetch n.ipInterfaces as ipInterface left join fetch ipInterface.monitoredServices as monSvc left join fetch monSvc.serviceType left join fetch monSvc.currentOutages where c.name = ?", category.getName());
    }

    private String categoryListToNameList(Collection<OnmsCategory> categories) {
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (OnmsCategory category : categories) {
            categoryNames.add(category.getName());
        }
        return StringUtils.collectionToDelimitedString(categoryNames, (String)", ", (String)"'", (String)"'");
    }

    @Override
    public List<OnmsNode> findAllByCategoryList(Collection<OnmsCategory> categories) {
        return this.find("select distinct n from OnmsNode as n join n.categories c left join fetch n.assetRecord left join fetch n.ipInterfaces as ipInterface left join fetch n.snmpInterfaces as snmpIfaceleft join fetch ipInterface.monitoredServices as monSvc left join fetch monSvc.serviceType left join fetch monSvc.currentOutages where c.name in (" + this.categoryListToNameList(categories) + ")" + "and n.type != 'D'");
    }

    @Override
    public List<OnmsNode> findAllByCategoryLists(final Collection<OnmsCategory> rowCategories, final Collection<OnmsCategory> columnCategories) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<OnmsNode>>(){

            public List<OnmsNode> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("select distinct n from OnmsNode as n join n.categories c1 join n.categories c2 left join fetch n.assetRecord left join fetch n.ipInterfaces as iface left join fetch n.snmpInterfaces as snmpIfaceleft join fetch iface.monitoredServices as monSvc left join fetch monSvc.serviceType left join fetch monSvc.currentOutages where c1 in (:rowCategories) and c2 in (:colCategories) and n.type != 'D'").setParameterList("rowCategories", rowCategories).setParameterList("colCategories", columnCategories).list();
            }
        });
    }

    @Override
    public SurveillanceStatus findSurveillanceStatusByCategoryLists(final Collection<OnmsCategory> rowCategories, final Collection<OnmsCategory> columnCategories) {
        return (SurveillanceStatus)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<SurveillanceStatus>(){

            public SurveillanceStatus doInHibernate(Session session) throws HibernateException, SQLException {
                return (SimpleSurveillanceStatus)session.createSQLQuery("select count(distinct case when outages.outageid is not null and monSvc.status = 'A' then monSvc.id else null end) as svcCount, count(distinct case when outages.outageid is null and monSvc.status = 'A' then node.nodeid else null end) as upNodeCount, count(distinct node.nodeid) as nodeCount from node join category_node cn1 using (nodeid) join category_node cn2 using (nodeid) left outer join ipinterface ip using (nodeid) left outer join ifservices monsvc on (monsvc.ipinterfaceid = ip.id) left outer join outages on (outages.ifserviceid = monsvc.id and outages.ifregainedservice is null) where nodeType <> 'D' and cn1.categoryid in (:rowCategories) and cn2.categoryid in (:columnCategories)").setParameterList("rowCategories", rowCategories).setParameterList("columnCategories", columnCategories).setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 5152094813503430377L;

                    public Object transformTuple(Object[] tuple, String[] aliases) {
                        NodeDaoHibernate.this.logger.debug((Object)("tuple length = " + tuple.length));
                        for (int i = 0; i < tuple.length; ++i) {
                            NodeDaoHibernate.this.logger.debug((Object)(i + ": " + tuple[i] + " (" + tuple[i].getClass() + ")"));
                        }
                        return new SimpleSurveillanceStatus((Number)tuple[0], (Number)tuple[1], (Number)tuple[2]);
                    }

                    public List transformList(List collection) {
                        return collection;
                    }
                }).uniqueResult();
            }
        });
    }

    @Override
    public Map<String, Integer> getForeignIdToNodeIdMap(String foreignSource) {
        List pairs = this.getHibernateTemplate().find("select n.id, n.foreignId from OnmsNode n where n.foreignSource = ?", (Object)foreignSource);
        HashMap<String, Integer> foreignIdMap = new HashMap<String, Integer>();
        for (Object[] pair : pairs) {
            foreignIdMap.put((String)pair[1], (Integer)pair[0]);
        }
        return Collections.unmodifiableMap(foreignIdMap);
    }

    @Override
    public List<OnmsNode> findByForeignSource(String foreignSource) {
        return this.find("from OnmsNode n where n.foreignSource = ?", foreignSource);
    }

    @Override
    public OnmsNode findByForeignId(String foreignSource, String foreignId) {
        return (OnmsNode)this.findUnique("from OnmsNode n where n.foreignSource = ? and n.foreignId = ?", foreignSource, foreignId);
    }

    @Override
    public List<OnmsNode> findByForeignSourceAndIpAddress(String foreignSource, String ipAddress) {
        if (foreignSource == null) {
            return this.find("select distinct n from OnmsNode n join n.ipInterfaces as ipInterface where n.foreignSource is NULL and ipInterface.ipAddress = ?", ipAddress);
        }
        return this.find("select distinct n from OnmsNode n join n.ipInterfaces as ipInterface where n.foreignSource = ? and ipInterface.ipAddress = ?", foreignSource, ipAddress);
    }

    @Override
    public int getNodeCountForForeignSource(String foreignSource) {
        return this.queryInt("select count(*) from OnmsNode as n where n.foreignSource = ?", foreignSource);
    }

    @Override
    public List<OnmsNode> findAll() {
        return this.find("from OnmsNode order by label");
    }

    @Override
    public List<OnmsNode> findAllProvisionedNodes() {
        return this.find("from OnmsNode n where n.foreignSource is not null");
    }

    @Override
    public List<OnmsIpInterface> findObsoleteIpInterfaces(Integer nodeId, Date scanStamp) {
        return this.findObjects(OnmsIpInterface.class, "from OnmsIpInterface ipInterface where ipInterface.node.id = ? and ipInterface.isSnmpPrimary != 'P' and (ipInterface.ipLastCapsdPoll is null or ipInterface.ipLastCapsdPoll < ?)", nodeId, scanStamp);
    }

    @Override
    public void deleteObsoleteInterfaces(Integer nodeId, Date scanStamp) {
        this.getHibernateTemplate().bulkUpdate("delete from OnmsIpInterface ipInterface where ipInterface.node.id = ? and ipInterface.isSnmpPrimary != 'P' and (ipInterface.ipLastCapsdPoll is null or ipInterface.ipLastCapsdPoll < ?)", new Object[]{nodeId, scanStamp});
        this.getHibernateTemplate().bulkUpdate("delete from OnmsSnmpInterface snmpInterface where snmpInterface.node.id = ? and (snmpInterface.lastCapsdPoll is null or snmpInterface.lastCapsdPoll < ?)", new Object[]{nodeId, scanStamp});
    }

    @Override
    public void updateNodeScanStamp(Integer nodeId, Date scanStamp) {
        OnmsNode n = (OnmsNode)this.get(nodeId);
        n.setLastCapsdPoll(scanStamp);
        this.update(n);
    }

    @Override
    public Collection<Integer> getNodeIds() {
        return this.findObjects(Integer.class, "select distinct n.id from OnmsNode as n where n.type != 'D'", new Object[0]);
    }

    @Override
    public Integer getNextNodeId(Integer nodeId) {
        Integer nextNodeId = null;
        nextNodeId = this.findObjects(Integer.class, "select n.id from OnmsNode as n where n.id > ? and n.type != 'D' order by n.id asc limit 1", nodeId).get(0);
        return nextNodeId;
    }

    @Override
    public Integer getPreviousNodeId(Integer nodeId) {
        Integer nextNodeId = null;
        nextNodeId = this.findObjects(Integer.class, "select n.id from OnmsNode as n where n.id < ? and n.type != 'D' order by n.id desc limit 1", nodeId).get(0);
        return nextNodeId;
    }

    public static class SimpleSurveillanceStatus
    implements SurveillanceStatus {
        private int m_serviceOutages;
        private int m_upNodeCount;
        private int m_nodeCount;

        public SimpleSurveillanceStatus(Number serviceOutages, Number upNodeCount, Number nodeCount) {
            System.err.println(String.format("Args: %s (%s), %s (%s), %s (%s)", serviceOutages, serviceOutages == null ? null : serviceOutages.getClass(), upNodeCount, upNodeCount == null ? null : upNodeCount.getClass(), nodeCount, nodeCount == null ? null : nodeCount.getClass()));
            this.m_serviceOutages = serviceOutages == null ? 0 : serviceOutages.intValue();
            this.m_upNodeCount = upNodeCount == null ? 0 : upNodeCount.intValue();
            this.m_nodeCount = nodeCount == null ? 0 : nodeCount.intValue();
        }

        public Integer getDownEntityCount() {
            return this.m_nodeCount - this.m_upNodeCount;
        }

        public Integer getTotalEntityCount() {
            return this.m_nodeCount;
        }

        public String getStatus() {
            switch (this.m_serviceOutages) {
                case 0: {
                    return "Normal";
                }
                case 1: {
                    return "Warning";
                }
            }
            return "Critical";
        }
    }
}

