/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.persistence.Table;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.metadata.ClassMetadata;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.OnmsDao;
import org.opennms.netmgt.dao.hibernate.AccessLock;
import org.opennms.netmgt.dao.hibernate.HibernateCriteriaConverter;
import org.opennms.netmgt.model.OnmsCriteria;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class AbstractDaoHibernate<T, K extends Serializable>
extends HibernateDaoSupport
implements OnmsDao<T, K> {
    Class<T> m_entityClass;
    private String m_lockName;
    private final HibernateCriteriaConverter m_criteriaConverter = new HibernateCriteriaConverter();

    public AbstractDaoHibernate(Class<T> entityClass) {
        this.m_entityClass = entityClass;
        Table table = this.m_entityClass.getAnnotation(Table.class);
        this.m_lockName = (table == null || "".equals(table.name()) ? this.m_entityClass.getSimpleName() : table.name()).toUpperCase() + "_ACCESS";
    }

    protected void initDao() throws Exception {
        this.getHibernateTemplate().saveOrUpdate((Object)new AccessLock(this.m_lockName));
    }

    @Override
    public void lock() {
        this.getHibernateTemplate().get(AccessLock.class, (Serializable)((Object)this.m_lockName), LockMode.UPGRADE);
    }

    @Override
    public void initialize(Object obj) {
        this.getHibernateTemplate().initialize(obj);
    }

    @Override
    public void flush() {
        this.getHibernateTemplate().flush();
    }

    @Override
    public void clear() {
        this.getHibernateTemplate().clear();
    }

    public void evict(T entity) {
        this.getHibernateTemplate().evict(entity);
    }

    public void merge(T entity) {
        this.getHibernateTemplate().merge(entity);
    }

    public List<T> find(String query) {
        return this.getHibernateTemplate().find(query);
    }

    public List<T> find(String query, Object ... values) {
        return this.getHibernateTemplate().find(query, values);
    }

    public <S> List<S> findObjects(Class<S> clazz, String query, Object ... values) {
        List notifs = this.getHibernateTemplate().find(query, values);
        return notifs;
    }

    protected int queryInt(final String query) {
        HibernateCallback<Number> callback = new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.createQuery(query).uniqueResult();
            }
        };
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)callback)).intValue();
    }

    protected int queryInt(final String queryString, final Object ... args) {
        HibernateCallback<Number> callback = new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                return (Number)query.uniqueResult();
            }
        };
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)callback)).intValue();
    }

    protected T findUnique(String query) {
        return this.findUnique(this.m_entityClass, query, new Object[0]);
    }

    protected T findUnique(String queryString, Object ... args) {
        return this.findUnique(this.m_entityClass, queryString, args);
    }

    protected <S> S findUnique(final Class<? extends S> type, final String queryString, final Object ... args) {
        HibernateCallback callback = new HibernateCallback<S>(){

            public S doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                Object result = query.uniqueResult();
                return result == null ? null : (Object)type.cast(result);
            }
        };
        return (S)this.getHibernateTemplate().execute(callback);
    }

    @Override
    public int countAll() {
        return this.queryInt("select count(*) from " + this.m_entityClass.getName());
    }

    @Override
    public void delete(T entity) throws DataAccessException {
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public void delete(K key) throws DataAccessException {
        this.delete((K)this.get(key));
    }

    public void deleteAll(Collection<T> entities) throws DataAccessException {
        this.getHibernateTemplate().deleteAll(entities);
    }

    @Override
    public List<T> findAll() throws DataAccessException {
        return this.getHibernateTemplate().loadAll(this.m_entityClass);
    }

    public <S> List<S> findMatchingObjects(Class<S> type, final OnmsCriteria onmsCrit) {
        onmsCrit.resultsOfType(type);
        HibernateCallback callback = new HibernateCallback<S>(){

            public S doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session);
                if (onmsCrit.getFirstResult() != null) {
                    attachedCrit.setFirstResult(onmsCrit.getFirstResult().intValue());
                }
                if (onmsCrit.getMaxResults() != null) {
                    attachedCrit.setMaxResults(onmsCrit.getMaxResults().intValue());
                }
                return attachedCrit.list();
            }
        };
        return this.getHibernateTemplate().executeFind(callback);
    }

    @Override
    public List<T> findMatching(final Criteria criteria) {
        HibernateCallback callback = new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
                LogUtils.debugf((Object)this, (String)"criteria = %s", (Object[])new Object[]{criteria});
                org.hibernate.Criteria hibernateCriteria = AbstractDaoHibernate.this.m_criteriaConverter.convert(criteria, session);
                return hibernateCriteria.list();
            }
        };
        return this.getHibernateTemplate().executeFind(callback);
    }

    @Override
    public int countMatching(final Criteria criteria) throws DataAccessException {
        HibernateCallback<Integer> callback = new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Criteria hibernateCriteria = AbstractDaoHibernate.this.m_criteriaConverter.convertForCount(criteria, session);
                hibernateCriteria.setProjection(Projections.rowCount());
                return (Integer)hibernateCriteria.uniqueResult();
            }
        };
        Integer retval = (Integer)this.getHibernateTemplate().execute((HibernateCallback)callback);
        return retval == null ? 0 : retval;
    }

    @Override
    public List<T> findMatching(final OnmsCriteria onmsCrit) throws DataAccessException {
        onmsCrit.resultsOfType(this.m_entityClass);
        HibernateCallback callback = new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session);
                if (onmsCrit.getFirstResult() != null) {
                    attachedCrit.setFirstResult(onmsCrit.getFirstResult().intValue());
                }
                if (onmsCrit.getMaxResults() != null) {
                    attachedCrit.setMaxResults(onmsCrit.getMaxResults().intValue());
                }
                return attachedCrit.list();
            }
        };
        return this.getHibernateTemplate().executeFind(callback);
    }

    @Override
    public int countMatching(final OnmsCriteria onmsCrit) throws DataAccessException {
        HibernateCallback<Integer> callback = new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session).setProjection(Projections.rowCount());
                return (Integer)attachedCrit.uniqueResult();
            }
        };
        Integer retval = (Integer)this.getHibernateTemplate().execute((HibernateCallback)callback);
        return retval == null ? 0 : retval;
    }

    public int bulkDelete(String hql, Object[] values) throws DataAccessException {
        return this.getHibernateTemplate().bulkUpdate(hql, values);
    }

    @Override
    public T get(K id) throws DataAccessException {
        return this.m_entityClass.cast(this.getHibernateTemplate().get(this.m_entityClass, id));
    }

    @Override
    public T load(K id) throws DataAccessException {
        return this.m_entityClass.cast(this.getHibernateTemplate().load(this.m_entityClass, id));
    }

    @Override
    public void save(T entity) throws DataAccessException {
        this.getHibernateTemplate().save(entity);
    }

    @Override
    public void saveOrUpdate(T entity) throws DataAccessException {
        try {
            this.getHibernateTemplate().saveOrUpdate(entity);
        }
        catch (DataAccessException e) {
            this.logExtraSaveOrUpdateExceptionInformation(entity, e);
            throw e;
        }
    }

    @Override
    public void update(T entity) throws DataAccessException {
        try {
            this.getHibernateTemplate().update(entity);
        }
        catch (DataAccessException e) {
            this.logExtraSaveOrUpdateExceptionInformation(entity, e);
            throw e;
        }
    }

    private void logExtraSaveOrUpdateExceptionInformation(T entity, DataAccessException e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            if (cause.getMessage().contains("duplicate key value violates unique constraint")) {
                ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.m_entityClass);
                LogUtils.warnf((Object)this, (String)"Duplicate key constraint violation, class: %s, key value: %s", (Object[])new Object[]{this.m_entityClass.getName(), meta.getPropertyValue(entity, meta.getIdentifierPropertyName(), EntityMode.POJO)});
                break;
            }
            if (cause.getMessage().contains("given object has a null identifier")) {
                LogUtils.warnf((Object)this, (String)"Null identifier on object, class: %s: %s", (Object[])new Object[]{this.m_entityClass.getName(), entity.toString()});
                break;
            }
            cause = cause.getCause();
        }
    }
}

