/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Header;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;

public class HeaderTest
extends TestCase {
    private Header m_h;

    public void setUp() {
        this.m_h = new Header(43981);
    }

    public void test_fixture_state() {
        HeaderTest.assertEquals((int)43981, (int)this.m_h.getID());
        boolean[] flags = this.m_h.getFlags();
        for (int i = 0; i < flags.length; ++i) {
            HeaderTest.assertFalse((boolean)flags[i]);
        }
        HeaderTest.assertEquals((int)0, (int)this.m_h.getRcode());
        HeaderTest.assertEquals((int)0, (int)this.m_h.getOpcode());
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(0));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(1));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(2));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(3));
    }

    public void test_ctor_0arg() {
        this.m_h = new Header();
        HeaderTest.assertTrue((0 <= this.m_h.getID() && this.m_h.getID() < 65535 ? 1 : 0) != 0);
        boolean[] flags = this.m_h.getFlags();
        for (int i = 0; i < flags.length; ++i) {
            HeaderTest.assertFalse((boolean)flags[i]);
        }
        HeaderTest.assertEquals((int)0, (int)this.m_h.getRcode());
        HeaderTest.assertEquals((int)0, (int)this.m_h.getOpcode());
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(0));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(1));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(2));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(3));
    }

    public void test_ctor_DNSInput() throws IOException {
        byte[] raw = new byte[]{18, -85, -113, -67, 101, 28, 16, -16, -104, -70, 113, -112};
        this.m_h = new Header(new DNSInput(raw));
        HeaderTest.assertEquals((int)4779, (int)this.m_h.getID());
        boolean[] flags = this.m_h.getFlags();
        HeaderTest.assertTrue((boolean)flags[0]);
        HeaderTest.assertEquals((int)1, (int)this.m_h.getOpcode());
        HeaderTest.assertTrue((boolean)flags[5]);
        HeaderTest.assertTrue((boolean)flags[6]);
        HeaderTest.assertTrue((boolean)flags[7]);
        HeaderTest.assertTrue((boolean)flags[8]);
        HeaderTest.assertFalse((boolean)flags[9]);
        HeaderTest.assertTrue((boolean)flags[10]);
        HeaderTest.assertTrue((boolean)flags[11]);
        HeaderTest.assertEquals((int)13, (int)this.m_h.getRcode());
        HeaderTest.assertEquals((int)25884, (int)this.m_h.getCount(0));
        HeaderTest.assertEquals((int)4336, (int)this.m_h.getCount(1));
        HeaderTest.assertEquals((int)39098, (int)this.m_h.getCount(2));
        HeaderTest.assertEquals((int)29072, (int)this.m_h.getCount(3));
    }

    public void test_toWire() throws IOException {
        int i;
        byte[] raw = new byte[]{18, -85, -113, -67, 101, 28, 16, -16, -104, -70, 113, -112};
        this.m_h = new Header(raw);
        DNSOutput dout = new DNSOutput();
        this.m_h.toWire(dout);
        byte[] out = dout.toByteArray();
        HeaderTest.assertEquals((int)12, (int)out.length);
        for (i = 0; i < out.length; ++i) {
            HeaderTest.assertEquals((byte)raw[i], (byte)out[i]);
        }
        this.m_h.setOpcode(10);
        HeaderTest.assertEquals((int)10, (int)this.m_h.getOpcode());
        this.m_h.setRcode(7);
        raw[2] = -41;
        raw[3] = -73;
        out = this.m_h.toWire();
        HeaderTest.assertEquals((int)12, (int)out.length);
        for (i = 0; i < out.length; ++i) {
            HeaderTest.assertEquals((String)("i=" + i), (byte)raw[i], (byte)out[i]);
        }
    }

    public void test_flags() {
        this.m_h.setFlag(0);
        this.m_h.setFlag(5);
        HeaderTest.assertTrue((boolean)this.m_h.getFlag(0));
        HeaderTest.assertTrue((boolean)this.m_h.getFlags()[0]);
        HeaderTest.assertTrue((boolean)this.m_h.getFlag(5));
        HeaderTest.assertTrue((boolean)this.m_h.getFlags()[5]);
        this.m_h.unsetFlag(0);
        HeaderTest.assertFalse((boolean)this.m_h.getFlag(0));
        HeaderTest.assertFalse((boolean)this.m_h.getFlags()[0]);
        HeaderTest.assertTrue((boolean)this.m_h.getFlag(5));
        HeaderTest.assertTrue((boolean)this.m_h.getFlags()[5]);
        this.m_h.unsetFlag(5);
        HeaderTest.assertFalse((boolean)this.m_h.getFlag(0));
        HeaderTest.assertFalse((boolean)this.m_h.getFlags()[0]);
        HeaderTest.assertFalse((boolean)this.m_h.getFlag(5));
        HeaderTest.assertFalse((boolean)this.m_h.getFlags()[5]);
        boolean[] flags = this.m_h.getFlags();
        for (int i = 0; i < flags.length; ++i) {
            if (i > 0 && i < 5 || i > 11) continue;
            HeaderTest.assertFalse((boolean)flags[i]);
        }
    }

    public void test_flags_invalid() {
        try {
            this.m_h.setFlag(-1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setFlag(1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setFlag(16);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.unsetFlag(-1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.unsetFlag(13);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.unsetFlag(16);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.getFlag(-1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.getFlag(4);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.getFlag(16);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ID() {
        HeaderTest.assertEquals((int)43981, (int)this.m_h.getID());
        this.m_h = new Header();
        int id = this.m_h.getID();
        HeaderTest.assertEquals((int)id, (int)this.m_h.getID());
        HeaderTest.assertTrue((id >= 0 && id < 65535 ? 1 : 0) != 0);
        this.m_h.setID(56506);
        HeaderTest.assertEquals((int)56506, (int)this.m_h.getID());
    }

    public void test_setID_invalid() {
        try {
            this.m_h.setID(65536);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setID(-1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Rcode() {
        HeaderTest.assertEquals((int)0, (int)this.m_h.getRcode());
        this.m_h.setRcode(10);
        HeaderTest.assertEquals((int)10, (int)this.m_h.getRcode());
        for (int i = 0; i < 12; ++i) {
            if (i > 0 && i < 5 || i > 11) continue;
            HeaderTest.assertFalse((boolean)this.m_h.getFlag(i));
        }
    }

    public void test_setRcode_invalid() {
        try {
            this.m_h.setRcode(-1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setRcode(256);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Opcode() {
        HeaderTest.assertEquals((int)0, (int)this.m_h.getOpcode());
        this.m_h.setOpcode(14);
        HeaderTest.assertEquals((int)14, (int)this.m_h.getOpcode());
        HeaderTest.assertFalse((boolean)this.m_h.getFlag(0));
        for (int i = 5; i < 12; ++i) {
            HeaderTest.assertFalse((boolean)this.m_h.getFlag(i));
        }
        HeaderTest.assertEquals((int)0, (int)this.m_h.getRcode());
    }

    public void test_setOpcode_invalid() {
        try {
            this.m_h.setOpcode(-1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setOpcode(256);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Count() {
        this.m_h.setCount(2, 30);
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(0));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(1));
        HeaderTest.assertEquals((int)30, (int)this.m_h.getCount(2));
        HeaderTest.assertEquals((int)0, (int)this.m_h.getCount(3));
        this.m_h.incCount(0);
        HeaderTest.assertEquals((int)1, (int)this.m_h.getCount(0));
        this.m_h.decCount(2);
        HeaderTest.assertEquals((int)29, (int)this.m_h.getCount(2));
    }

    public void test_setCount_invalid() {
        try {
            this.m_h.setCount(-1, 0);
            HeaderTest.fail((String)"ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.m_h.setCount(4, 0);
            HeaderTest.fail((String)"ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.m_h.setCount(0, -1);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_h.setCount(3, 65536);
            HeaderTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_getCount_invalid() {
        try {
            this.m_h.getCount(-1);
            HeaderTest.fail((String)"ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.m_h.getCount(4);
            HeaderTest.fail((String)"ArrayIndexOutOfBoundsException not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_incCount_invalid() {
        this.m_h.setCount(1, 65535);
        try {
            this.m_h.incCount(1);
            HeaderTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test_decCount_invalid() {
        this.m_h.setCount(2, 0);
        try {
            this.m_h.decCount(2);
            HeaderTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test_toString() {
        this.m_h.setOpcode(Opcode.value("STATUS"));
        this.m_h.setRcode(Rcode.value("NXDOMAIN"));
        this.m_h.setFlag(0);
        this.m_h.setFlag(7);
        this.m_h.setFlag(8);
        this.m_h.setFlag(11);
        this.m_h.setCount(1, 255);
        this.m_h.setCount(2, 10);
        String text = this.m_h.toString();
        HeaderTest.assertFalse((text.indexOf("id: 43981") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf("opcode: STATUS") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf("status: NXDOMAIN") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf(" qr ") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf(" rd ") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf(" ra ") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf(" cd ") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf("qd: 0 ") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf("an: 255 ") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf("au: 10 ") == -1 ? 1 : 0) != 0);
        HeaderTest.assertFalse((text.indexOf("ad: 0 ") == -1 ? 1 : 0) != 0);
    }

    public void test_clone() {
        int i;
        this.m_h.setOpcode(Opcode.value("IQUERY"));
        this.m_h.setRcode(Rcode.value("SERVFAIL"));
        this.m_h.setFlag(0);
        this.m_h.setFlag(7);
        this.m_h.setFlag(8);
        this.m_h.setFlag(11);
        this.m_h.setCount(1, 255);
        this.m_h.setCount(2, 10);
        Header h2 = (Header)this.m_h.clone();
        HeaderTest.assertNotSame((Object)this.m_h, (Object)h2);
        HeaderTest.assertEquals((int)this.m_h.getID(), (int)h2.getID());
        for (i = 0; i < 16; ++i) {
            if (i > 0 && i < 5 || i > 11) continue;
            HeaderTest.assertEquals((boolean)this.m_h.getFlag(i), (boolean)h2.getFlag(i));
        }
        for (i = 0; i < 4; ++i) {
            HeaderTest.assertEquals((int)this.m_h.getCount(i), (int)h2.getCount(i));
        }
    }
}

