/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.xbill.DNS.FormattedTime;
import org.xbill.DNS.TextParseException;

public class FormattedTimeTest
extends TestCase {
    public void test_format() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(2005, 2, 19, 4, 4, 5);
        String out = FormattedTime.format(cal.getTime());
        FormattedTimeTest.assertEquals((String)"20050319040405", (String)out);
    }

    public void test_parse() throws TextParseException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(2005, 2, 19, 4, 4, 5);
        cal.set(14, 0);
        Date out = FormattedTime.parse("20050319040405");
        GregorianCalendar cal2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal2.setTimeInMillis(out.getTime());
        cal2.set(14, 0);
        FormattedTimeTest.assertEquals((Object)cal, (Object)cal2);
    }

    public void test_parse_invalid() {
        try {
            FormattedTime.parse("2004010101010");
            FormattedTimeTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        try {
            FormattedTime.parse("200401010101010");
            FormattedTimeTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        try {
            FormattedTime.parse("2004010101010A");
            FormattedTimeTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }
}

