/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.pool.jmx;

import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.PoolUtilities;
import org.apache.tomcat.jdbc.pool.Validator;
import org.apache.tomcat.jdbc.pool.jmx.ConnectionPoolMBean;

public class ConnectionPool
extends NotificationBroadcasterSupport
implements ConnectionPoolMBean {
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    protected org.apache.tomcat.jdbc.pool.ConnectionPool pool = null;
    protected AtomicInteger sequence = new AtomicInteger(0);
    protected ConcurrentLinkedQueue<NotificationListener> listeners = new ConcurrentLinkedQueue();
    public static final String NOTIFY_INIT = "INIT FAILED";
    public static final String NOTIFY_CONNECT = "CONNECTION FAILED";
    public static final String NOTIFY_ABANDON = "CONNECTION ABANDONED";
    public static final String SLOW_QUERY_NOTIFICATION = "SLOW QUERY";
    public static final String FAILED_QUERY_NOTIFICATION = "FAILED QUERY";
    public static final String SUSPECT_ABANDONED_NOTIFICATION = "SUSPECT CONNETION ABANDONED";

    public ConnectionPool(org.apache.tomcat.jdbc.pool.ConnectionPool pool) {
        this.pool = pool;
    }

    public org.apache.tomcat.jdbc.pool.ConnectionPool getPool() {
        return this.pool;
    }

    public PoolConfiguration getPoolProperties() {
        return this.pool.getPoolProperties();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] pres = super.getNotificationInfo();
        MBeanNotificationInfo[] loc = ConnectionPool.getDefaultNotificationInfo();
        MBeanNotificationInfo[] aug = new MBeanNotificationInfo[pres.length + loc.length];
        if (pres.length > 0) {
            System.arraycopy(pres, 0, aug, 0, pres.length);
        }
        if (loc.length > 0) {
            System.arraycopy(loc, 0, aug, pres.length, loc.length);
        }
        return aug;
    }

    public static MBeanNotificationInfo[] getDefaultNotificationInfo() {
        String[] types = new String[]{NOTIFY_INIT, NOTIFY_CONNECT, NOTIFY_ABANDON, SLOW_QUERY_NOTIFICATION, FAILED_QUERY_NOTIFICATION, SUSPECT_ABANDONED_NOTIFICATION};
        String name = Notification.class.getName();
        String description = "A connection pool error condition was met.";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public boolean notify(String type, String message) {
        try {
            Notification n = new Notification(type, this, this.sequence.incrementAndGet(), System.currentTimeMillis(), "[" + type + "] " + message);
            this.sendNotification(n);
            for (NotificationListener listener : this.listeners) {
                listener.handleNotification(n, this);
            }
            return true;
        }
        catch (Exception x) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notify failed. Type=" + type + "; Message=" + message), (Throwable)x);
            }
            return false;
        }
    }

    public void addListener(NotificationListener list) {
        this.listeners.add(list);
    }

    public boolean removeListener(NotificationListener list) {
        return this.listeners.remove(list);
    }

    public int getSize() {
        return this.pool.getSize();
    }

    public int getIdle() {
        return this.pool.getIdle();
    }

    public int getActive() {
        return this.pool.getActive();
    }

    public int getNumIdle() {
        return this.getIdle();
    }

    public int getNumActive() {
        return this.getActive();
    }

    public int getWaitCount() {
        return this.pool.getWaitCount();
    }

    public void checkIdle() {
        this.pool.checkIdle();
    }

    public void checkAbandoned() {
        this.pool.checkAbandoned();
    }

    public void testIdle() {
        this.pool.testAllIdle();
    }

    public String getConnectionProperties() {
        return this.getPoolProperties().getConnectionProperties();
    }

    public Properties getDbProperties() {
        return PoolUtilities.cloneWithoutPassword(this.getPoolProperties().getDbProperties());
    }

    public String getDefaultCatalog() {
        return this.getPoolProperties().getDefaultCatalog();
    }

    public int getDefaultTransactionIsolation() {
        return this.getPoolProperties().getDefaultTransactionIsolation();
    }

    public String getDriverClassName() {
        return this.getPoolProperties().getDriverClassName();
    }

    public int getInitialSize() {
        return this.getPoolProperties().getInitialSize();
    }

    public String getInitSQL() {
        return this.getPoolProperties().getInitSQL();
    }

    public String getJdbcInterceptors() {
        return this.getPoolProperties().getJdbcInterceptors();
    }

    public int getMaxActive() {
        return this.getPoolProperties().getMaxActive();
    }

    public int getMaxIdle() {
        return this.getPoolProperties().getMaxIdle();
    }

    public int getMaxWait() {
        return this.getPoolProperties().getMaxWait();
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.getPoolProperties().getMinEvictableIdleTimeMillis();
    }

    public int getMinIdle() {
        return this.getPoolProperties().getMinIdle();
    }

    public long getMaxAge() {
        return this.getPoolProperties().getMaxAge();
    }

    public String getName() {
        return this.getPoolName();
    }

    public int getNumTestsPerEvictionRun() {
        return this.getPoolProperties().getNumTestsPerEvictionRun();
    }

    public String getPassword() {
        return "Password not available as DataSource/JMX operation.";
    }

    public int getRemoveAbandonedTimeout() {
        return this.getPoolProperties().getRemoveAbandonedTimeout();
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.getPoolProperties().getTimeBetweenEvictionRunsMillis();
    }

    public String getUrl() {
        return this.getPoolProperties().getUrl();
    }

    public String getUsername() {
        return this.getPoolProperties().getUsername();
    }

    public long getValidationInterval() {
        return this.getPoolProperties().getValidationInterval();
    }

    public String getValidationQuery() {
        return this.getPoolProperties().getValidationQuery();
    }

    public String getValidatorClassName() {
        return this.getPoolProperties().getValidatorClassName();
    }

    public Validator getValidator() {
        return this.getPoolProperties().getValidator();
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.getPoolProperties().isAccessToUnderlyingConnectionAllowed();
    }

    public Boolean isDefaultAutoCommit() {
        return this.getPoolProperties().isDefaultAutoCommit();
    }

    public Boolean isDefaultReadOnly() {
        return this.getPoolProperties().isDefaultReadOnly();
    }

    public boolean isLogAbandoned() {
        return this.getPoolProperties().isLogAbandoned();
    }

    public boolean isPoolSweeperEnabled() {
        return this.getPoolProperties().isPoolSweeperEnabled();
    }

    public boolean isRemoveAbandoned() {
        return this.getPoolProperties().isRemoveAbandoned();
    }

    public int getAbandonWhenPercentageFull() {
        return this.getPoolProperties().getAbandonWhenPercentageFull();
    }

    public boolean isTestOnBorrow() {
        return this.getPoolProperties().isTestOnBorrow();
    }

    public boolean isTestOnConnect() {
        return this.getPoolProperties().isTestOnConnect();
    }

    public boolean isTestOnReturn() {
        return this.getPoolProperties().isTestOnReturn();
    }

    public boolean isTestWhileIdle() {
        return this.getPoolProperties().isTestWhileIdle();
    }

    public Boolean getDefaultAutoCommit() {
        return this.getPoolProperties().getDefaultAutoCommit();
    }

    public Boolean getDefaultReadOnly() {
        return this.getPoolProperties().getDefaultReadOnly();
    }

    public PoolProperties.InterceptorDefinition[] getJdbcInterceptorsAsArray() {
        return this.getPoolProperties().getJdbcInterceptorsAsArray();
    }

    public boolean getUseLock() {
        return this.getPoolProperties().getUseLock();
    }

    public boolean isFairQueue() {
        return this.getPoolProperties().isFairQueue();
    }

    public boolean isJmxEnabled() {
        return this.getPoolProperties().isJmxEnabled();
    }

    public boolean isUseEquals() {
        return this.getPoolProperties().isUseEquals();
    }

    public void setAbandonWhenPercentageFull(int percentage) {
        this.getPoolProperties().setAbandonWhenPercentageFull(percentage);
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean accessToUnderlyingConnectionAllowed) {
        this.getPoolProperties().setAccessToUnderlyingConnectionAllowed(accessToUnderlyingConnectionAllowed);
    }

    public void setDbProperties(Properties dbProperties) {
        this.getPoolProperties().setDbProperties(dbProperties);
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.getPoolProperties().setDefaultReadOnly(defaultReadOnly);
    }

    public void setMaxAge(long maxAge) {
        this.getPoolProperties().setMaxAge(maxAge);
    }

    public void setName(String name) {
        this.getPoolProperties().setName(name);
    }

    public String getPoolName() {
        return this.getPoolProperties().getName();
    }

    public void setConnectionProperties(String connectionProperties) {
        this.getPoolProperties().setConnectionProperties(connectionProperties);
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.getPoolProperties().setDefaultAutoCommit(defaultAutoCommit);
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.getPoolProperties().setDefaultCatalog(defaultCatalog);
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.getPoolProperties().setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    public void setDriverClassName(String driverClassName) {
        this.getPoolProperties().setDriverClassName(driverClassName);
    }

    public void setFairQueue(boolean fairQueue) {
        this.getPoolProperties().setFairQueue(fairQueue);
    }

    public void setInitialSize(int initialSize) {
    }

    public void setInitSQL(String initSQL) {
    }

    public void setJdbcInterceptors(String jdbcInterceptors) {
    }

    public void setJmxEnabled(boolean jmxEnabled) {
    }

    public void setLogAbandoned(boolean logAbandoned) {
    }

    public void setMaxActive(int maxActive) {
    }

    public void setMaxIdle(int maxIdle) {
    }

    public void setMaxWait(int maxWait) {
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
    }

    public void setMinIdle(int minIdle) {
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
    }

    public void setPassword(String password) {
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
    }

    public void setTestOnConnect(boolean testOnConnect) {
    }

    public void setTestOnReturn(boolean testOnReturn) {
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
    }

    public void setUrl(String url) {
    }

    public void setUseEquals(boolean useEquals) {
    }

    public void setUseLock(boolean useLock) {
    }

    public void setUsername(String username) {
    }

    public void setValidationInterval(long validationInterval) {
    }

    public void setValidationQuery(String validationQuery) {
    }

    public void setValidatorClassName(String className) {
        this.getPoolProperties().setValidatorClassName(className);
    }

    public int getSuspectTimeout() {
        return this.getPoolProperties().getSuspectTimeout();
    }

    public void setSuspectTimeout(int seconds) {
    }

    public void setDataSource(Object ds) {
        this.getPoolProperties().setDataSource(ds);
    }

    public Object getDataSource() {
        return this.getPoolProperties().getDataSource();
    }

    public void setDataSourceJNDI(String jndiDS) {
    }

    public String getDataSourceJNDI() {
        return this.getPoolProperties().getDataSourceJNDI();
    }

    public boolean isAlternateUsernameAllowed() {
        return this.getPoolProperties().isAlternateUsernameAllowed();
    }

    public void setAlternateUsernameAllowed(boolean alternateUsernameAllowed) {
    }
}

