/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.vmmgr.InvalidDataSourceException;
import org.opennms.netmgt.vmmgr.MissingDataSourceException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DatabaseChecker {
    private static List<String> m_required = new ArrayList<String>();
    private static List<String> m_optional = new ArrayList<String>();
    private Map<String, JdbcDataSource> m_dataSources = new HashMap<String, JdbcDataSource>();

    protected DatabaseChecker(String configFile) throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        DataSourceConfiguration database = (DataSourceConfiguration)CastorUtils.unmarshal(DataSourceConfiguration.class, (Resource)new FileSystemResource(configFile), (boolean)false);
        for (JdbcDataSource dataSource : database.getJdbcDataSourceCollection()) {
            this.m_dataSources.put(dataSource.getName(), dataSource);
        }
    }

    protected DatabaseChecker() throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        this(ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME).getPath());
    }

    public void check() throws MissingDataSourceException, InvalidDataSourceException {
        boolean dataSourcesFound = true;
        for (String string : m_required) {
            if (this.m_dataSources.containsKey(string)) continue;
            LogUtils.errorf((Object)this, (String)"Required data source '%s' is missing from opennms-datasources.xml", (Object[])new Object[]{string});
            dataSourcesFound = false;
        }
        if (!dataSourcesFound) {
            throw new MissingDataSourceException("OpenNMS is missing one or more data sources required for startup.");
        }
        for (String string : m_optional) {
            if (this.m_dataSources.containsKey(string)) continue;
            LogUtils.infof((Object)this, (String)"Data source '%s' is missing from opennms-datasources.xml", (Object[])new Object[]{string});
        }
        for (JdbcDataSource jdbcDataSource : this.m_dataSources.values()) {
            String name = jdbcDataSource.getName();
            if (!m_required.contains(name) && !m_optional.contains(name)) {
                LogUtils.warnf((Object)this, (String)"Unknown datasource '%s' was found.", (Object[])new Object[]{name});
            }
            try {
                Class.forName(jdbcDataSource.getClassName());
                Connection connection = DriverManager.getConnection(jdbcDataSource.getUrl(), jdbcDataSource.getUserName(), jdbcDataSource.getPassword());
                connection.close();
            }
            catch (Throwable t) {
                String errorMessage = "Unable to connect to data source '%s' at URL '%s' with username '%s', check opennms-datasources.xml and your database permissions.";
                if (m_required.contains(name)) {
                    LogUtils.errorf((Object)this, (String)"Unable to connect to data source '%s' at URL '%s' with username '%s', check opennms-datasources.xml and your database permissions.", (Object[])new Object[]{name, jdbcDataSource.getUrl(), jdbcDataSource.getUserName()});
                    throw new InvalidDataSourceException("Data source '" + name + "' failed.", t);
                }
                LogUtils.warnf((Object)this, (String)"Unable to connect to data source '%s' at URL '%s' with username '%s', check opennms-datasources.xml and your database permissions.", (Object[])new Object[]{name, jdbcDataSource.getUrl(), jdbcDataSource.getUserName()});
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        DatabaseChecker checker = new DatabaseChecker();
        checker.check();
    }

    static {
        m_required.add("opennms");
        m_optional.add("opennms-admin");
    }
}

