/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.config.wmi.WmiAgentConfig;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;

@Distributable
public class WmiMonitor
extends AbstractServiceMonitor {
    private static final String DEFAULT_WMI_CLASS = "Win32_ComputerSystem";
    private static final String DEFAULT_WMI_OBJECT = "Status";
    private static final String DEFAULT_WMI_COMP_VAL = "OK";
    private static final String DEFAULT_WMI_MATCH_TYPE = "all";
    private static final String DEFAULT_WMI_COMP_OP = "EQ";
    private static final String DEFAULT_WMI_WQL = "NOTSET";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String reason = null;
        int serviceStatus = 2;
        WmiResult response = null;
        Double responseTime = null;
        NetworkInterface iface = svc.getNetInterface();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        WmiAgentConfig agentConfig = WmiPeerFactory.getInstance().getAgentConfig(ipv4Addr);
        String matchType = DEFAULT_WMI_MATCH_TYPE;
        String compVal = DEFAULT_WMI_COMP_VAL;
        String compOp = DEFAULT_WMI_COMP_OP;
        String wmiClass = DEFAULT_WMI_CLASS;
        String wmiObject = DEFAULT_WMI_OBJECT;
        String wmiWqlStr = DEFAULT_WMI_WQL;
        if (parameters != null) {
            if (parameters.get("timeout") != null) {
                int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout());
                agentConfig.setTimeout(timeout);
            }
            if (parameters.get("retry") != null) {
                int retries = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)agentConfig.getRetries());
                agentConfig.setRetries(retries);
            }
            if (parameters.get("username") != null) {
                String user = ParameterMap.getKeyedString(parameters, (String)"username", (String)agentConfig.getUsername());
                agentConfig.setUsername(user);
            }
            if (parameters.get("password") != null) {
                String pass = ParameterMap.getKeyedString(parameters, (String)"password", (String)agentConfig.getPassword());
                agentConfig.setUsername(pass);
            }
            if (parameters.get("domain") != null) {
                String domain = ParameterMap.getKeyedString(parameters, (String)"domain", (String)agentConfig.getDomain());
                agentConfig.setUsername(domain);
            }
            matchType = ParameterMap.getKeyedString(parameters, (String)"matchType", (String)DEFAULT_WMI_MATCH_TYPE);
            compVal = ParameterMap.getKeyedString(parameters, (String)"compareValue", (String)DEFAULT_WMI_COMP_VAL);
            compOp = ParameterMap.getKeyedString(parameters, (String)"compareOp", (String)DEFAULT_WMI_COMP_OP);
            wmiWqlStr = ParameterMap.getKeyedString(parameters, (String)"wql", (String)DEFAULT_WMI_WQL);
            wmiClass = ParameterMap.getKeyedString(parameters, (String)"wmiClass", (String)DEFAULT_WMI_CLASS);
            wmiObject = ParameterMap.getKeyedString(parameters, (String)"wmiObject", (String)DEFAULT_WMI_OBJECT);
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, agentConfig.getRetries(), agentConfig.getTimeout());
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        LogUtils.debugf((Object)((Object)this), (String)"poll: address = %s, user = %s, %s", (Object[])new Object[]{hostAddress, agentConfig.getUsername(), tracker});
        WmiManager mgr = null;
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            try {
                tracker.startAttempt();
                LogUtils.debugf((Object)((Object)this), (String)"poll: creating WmiManager object.", (Object[])new Object[0]);
                mgr = new WmiManager(hostAddress, agentConfig.getUsername(), agentConfig.getPassword(), agentConfig.getDomain(), matchType);
                mgr.setTimeout(tracker.getSoTimeout());
                mgr.init();
                LogUtils.debugf((Object)((Object)this), (String)"Completed initializing WmiManager object.", (Object[])new Object[0]);
                serviceStatus = 3;
                WmiParams clientParams = null;
                if (DEFAULT_WMI_WQL.equals(wmiWqlStr)) {
                    clientParams = new WmiParams("InstanceOf", compVal, compOp, wmiClass, wmiObject);
                    LogUtils.debugf((Object)((Object)this), (String)"Attempting to perform operation: \\\\%s\\%s", (Object[])new Object[]{wmiClass, wmiObject});
                } else {
                    clientParams = new WmiParams("Wql", compVal, compOp, wmiWqlStr, wmiObject);
                    LogUtils.debugf((Object)((Object)this), (String)"Attempting to perform operation: %s", (Object[])new Object[]{wmiWqlStr});
                }
                response = mgr.performOp(clientParams);
                LogUtils.debugf((Object)((Object)this), (String)"Received result: %s", (Object[])new Object[]{response});
                responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    ArrayList<Object> wmiObjects = response.getResponse();
                    StringBuffer reasonBuffer = new StringBuffer();
                    if (DEFAULT_WMI_WQL.equals(wmiWqlStr)) {
                        reasonBuffer.append("Result for ").append(wmiClass).append("\\").append(wmiObject);
                    } else {
                        reasonBuffer.append("Result for \"").append(wmiWqlStr).append("\"");
                    }
                    if (response.getResultCode() == 0) {
                        serviceStatus = 1;
                        reasonBuffer.append(": ").append(wmiObjects.get(0));
                    } else if (response.getResultCode() == 1) {
                        serviceStatus = 2;
                        responseTime = null;
                    }
                    reason = reasonBuffer.toString();
                }
            }
            catch (WmiException e) {
                LogUtils.debugf((Object)((Object)this), (Throwable)e, (String)"WMI Poller received exception from client.", (Object[])new Object[0]);
                reason = "WmiException: " + e.getMessage();
            }
            finally {
                if (mgr != null) {
                    try {
                        mgr.close();
                    }
                    catch (WmiException e) {
                        LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"An error occurred closing the WMI Manager.", (Object[])new Object[0]);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return PollStatus.get((int)serviceStatus, reason, responseTime);
    }
}

