/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.wmi;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.collectd.wmi.WmiGroupState;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.config.wmi.WmiAgentConfig;
import org.opennms.protocols.wmi.IWmiClient;
import org.opennms.protocols.wmi.WmiClient;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;

public class WmiAgentState {
    private WmiManager m_manager;
    private IWmiClient m_wmiClient;
    private WmiAgentConfig m_agentConfig;
    private String m_address;
    private HashMap<String, WmiGroupState> m_groupStates = new HashMap();

    public WmiAgentState(InetAddress address, Map<?, ?> parameters) {
        this.m_address = InetAddressUtils.str((InetAddress)address);
        this.m_agentConfig = WmiPeerFactory.getInstance().getAgentConfig(address);
        this.m_manager = new WmiManager(this.m_address, this.m_agentConfig.getUsername(), this.m_agentConfig.getPassword(), this.m_agentConfig.getDomain());
        try {
            this.m_wmiClient = new WmiClient(this.m_address);
        }
        catch (WmiException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Failed to create WMI client.", (Object[])new Object[0]);
        }
    }

    public void connect() {
        try {
            this.m_wmiClient.connect(this.m_agentConfig.getDomain(), this.m_agentConfig.getUsername(), this.m_agentConfig.getPassword());
        }
        catch (WmiException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Failed to connect to host.", (Object[])new Object[0]);
        }
    }

    public String getAddress() {
        return this.m_address;
    }

    public WmiManager getManager() {
        return this.m_manager;
    }

    public boolean groupIsAvailable(String groupName) {
        WmiGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            return false;
        }
        return groupState.isAvailable();
    }

    public void setGroupIsAvailable(String groupName, boolean available) {
        WmiGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            groupState = new WmiGroupState(available);
        }
        groupState.setAvailable(available);
        this.m_groupStates.put(groupName, groupState);
    }

    public boolean shouldCheckAvailability(String groupName, int recheckInterval) {
        WmiGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            return true;
        }
        Date lastchecked = groupState.getLastChecked();
        Date now = new Date();
        return now.getTime() - lastchecked.getTime() > (long)recheckInterval;
    }

    public void didCheckGroupAvailability(String groupName) {
        WmiGroupState groupState = this.m_groupStates.get(groupName);
        if (groupState == null) {
            LogUtils.warnf((Object)this, (String)"didCheckGroupAvailability called on a group without state - this is odd.", (Object[])new Object[0]);
            return;
        }
        groupState.setLastChecked(new Date());
    }

    public IWmiClient getWmiClient() {
        return this.m_wmiClient;
    }

    public void setWmiClient(IWmiClient wmiClient) {
        this.m_wmiClient = wmiClient;
    }
}

