/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.opennms.core.criteria.Order;
import org.opennms.core.utils.LogUtils;

public final class OrderBuilder {
    private final LinkedHashSet<Order> m_orders = new LinkedHashSet();
    private String m_lastAttribute = null;

    boolean append(Order order) {
        if (this.m_orders.add(order)) {
            this.m_lastAttribute = order.getAttribute();
            return true;
        }
        this.m_lastAttribute = null;
        return false;
    }

    public void clear() {
        this.m_orders.clear();
    }

    public Collection<Order> getOrderCollection() {
        return new ArrayList<Order>(this.m_orders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asc() {
        LinkedHashSet<Order> linkedHashSet = this.m_orders;
        synchronized (linkedHashSet) {
            if (this.m_orders.isEmpty()) {
                LogUtils.debugf((Object)this, (String)"asc() called, but no orderBy has been specified.", (Object[])new Object[0]);
            } else if (this.m_lastAttribute == null) {
                LogUtils.debugf((Object)this, (String)"asc() called on an attribute that can't be changed.", (Object[])new Object[0]);
            } else {
                for (Order o : this.m_orders) {
                    if (!o.getAttribute().equals(this.m_lastAttribute)) continue;
                    this.m_orders.remove(o);
                    this.m_orders.add(Order.asc(this.m_lastAttribute));
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void desc() {
        LinkedHashSet<Order> linkedHashSet = this.m_orders;
        synchronized (linkedHashSet) {
            if (this.m_orders.isEmpty()) {
                LogUtils.debugf((Object)this, (String)"desc() called, but no orderBy has been specified.", (Object[])new Object[0]);
            } else if (this.m_lastAttribute == null) {
                LogUtils.debugf((Object)this, (String)"desc() called on an attribute that can't be changed.", (Object[])new Object[0]);
            } else {
                for (Order o : this.m_orders) {
                    if (!o.getAttribute().equals(this.m_lastAttribute)) continue;
                    this.m_orders.remove(o);
                    this.m_orders.add(Order.desc(this.m_lastAttribute));
                    break;
                }
            }
        }
    }
}

