/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.MarshallingExceptionTranslator;
import org.opennms.core.xml.SimpleNamespaceFilter;
import org.opennms.core.xml.ValidateUsing;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class JaxbUtils {
    private static final MarshallingExceptionTranslator EXCEPTION_TRANSLATOR = new MarshallingExceptionTranslator();
    private static ThreadLocal<Map<Class<?>, Marshaller>> m_marshallers = new ThreadLocal();
    private static ThreadLocal<Map<Class<?>, Unmarshaller>> m_unMarshallers = new ThreadLocal();
    private static final Map<Class<?>, JAXBContext> m_contexts = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, Schema> m_schemas = Collections.synchronizedMap(new WeakHashMap());
    private static final boolean VALIDATE_IF_POSSIBLE = true;

    private JaxbUtils() {
    }

    public static String marshal(Object obj) {
        StringWriter jaxbWriter = new StringWriter();
        JaxbUtils.marshal(obj, jaxbWriter);
        return jaxbWriter.toString();
    }

    public static void marshal(Object obj, Writer writer) {
        Marshaller jaxbMarshaller = JaxbUtils.getMarshallerFor(obj, null);
        try {
            jaxbMarshaller.marshal(obj, writer);
        }
        catch (JAXBException e) {
            throw EXCEPTION_TRANSLATOR.translate("marshalling " + obj.getClass().getSimpleName(), e);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, File file) {
        return JaxbUtils.unmarshal(clazz, file, true);
    }

    public static <T> T unmarshal(Class<T> clazz, File file, boolean validate) {
        T t;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            t = JaxbUtils.unmarshal(clazz, new InputSource(reader), null, validate);
        }
        catch (FileNotFoundException e) {
            try {
                throw EXCEPTION_TRANSLATOR.translate("reading " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return t;
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader) {
        return JaxbUtils.unmarshal(clazz, reader, true);
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader, boolean validate) {
        return JaxbUtils.unmarshal(clazz, new InputSource(reader), null, validate);
    }

    public static <T> T unmarshal(Class<T> clazz, String xml) {
        return JaxbUtils.unmarshal(clazz, xml, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(Class<T> clazz, String xml, boolean validate) {
        StringReader sr = new StringReader(xml);
        InputSource is = new InputSource(sr);
        try {
            T t = JaxbUtils.unmarshal(clazz, is, null, validate);
            return t;
        }
        finally {
            IOUtils.closeQuietly((Reader)sr);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, Resource resource) {
        return JaxbUtils.unmarshal(clazz, resource, true);
    }

    public static <T> T unmarshal(Class<T> clazz, Resource resource, boolean validate) {
        try {
            return JaxbUtils.unmarshal(clazz, new InputSource(resource.getInputStream()), null, validate);
        }
        catch (IOException e) {
            throw EXCEPTION_TRANSLATOR.translate("getting a configuration resource from spring", e);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource) {
        return JaxbUtils.unmarshal(clazz, inputSource, true);
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource, boolean validate) {
        return JaxbUtils.unmarshal(clazz, inputSource, null, validate);
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource, JAXBContext jaxbContext) {
        return JaxbUtils.unmarshal(clazz, inputSource, jaxbContext, true);
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource, JAXBContext jaxbContext, boolean validate) {
        Unmarshaller um = JaxbUtils.getUnmarshallerFor(clazz, jaxbContext, validate);
        LogUtils.tracef(clazz, (String)"unmarshalling class %s from input source %s with unmarshaller %s", (Object[])new Object[]{clazz.getSimpleName(), inputSource, um});
        try {
            XMLFilter filter = JaxbUtils.getXMLFilterForClass(clazz);
            SAXSource source = new SAXSource(filter, inputSource);
            um.setEventHandler((ValidationEventHandler)new LoggingValidationEventHandler(clazz));
            JAXBElement element = um.unmarshal((Source)source, clazz);
            return (T)element.getValue();
        }
        catch (SAXException e) {
            throw EXCEPTION_TRANSLATOR.translate("creating an XML reader object", e);
        }
        catch (JAXBException e) {
            throw EXCEPTION_TRANSLATOR.translate("unmarshalling an object (" + clazz.getSimpleName() + ")", e);
        }
    }

    public static <T> XMLFilter getXMLFilterForClass(Class<T> clazz) throws SAXException {
        SimpleNamespaceFilter filter;
        XmlSchema schema = clazz.getPackage().getAnnotation(XmlSchema.class);
        if (schema != null) {
            String namespace = schema.namespace();
            if (namespace != null && !"".equals(namespace)) {
                LogUtils.tracef(clazz, (String)"found namespace %s for class %s", (Object[])new Object[]{namespace, clazz});
                filter = new SimpleNamespaceFilter(namespace, true);
            } else {
                filter = new SimpleNamespaceFilter("", false);
            }
        } else {
            filter = new SimpleNamespaceFilter("", false);
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        filter.setParent(xmlReader);
        return filter;
    }

    public static Marshaller getMarshallerFor(Object obj, JAXBContext jaxbContext) {
        Class<?> clazz = obj instanceof Class ? obj : obj.getClass();
        Map<Class<?>, Marshaller> marshallers = m_marshallers.get();
        if (jaxbContext == null) {
            if (marshallers == null) {
                marshallers = new WeakHashMap();
                m_marshallers.set(marshallers);
            }
            if (marshallers.containsKey(clazz)) {
                LogUtils.tracef(clazz, (String)"found unmarshaller for %s", (Object[])new Object[]{clazz});
                return marshallers.get(clazz);
            }
        }
        LogUtils.tracef(clazz, (String)"creating unmarshaller for %s", (Object[])new Object[]{clazz});
        try {
            JAXBContext context = jaxbContext == null ? JaxbUtils.getContextFor(clazz) : jaxbContext;
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Schema schema = JaxbUtils.getValidatorFor(clazz);
            marshaller.setSchema(schema);
            if (jaxbContext == null) {
                marshallers.put(clazz, marshaller);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw EXCEPTION_TRANSLATOR.translate("creating XML marshaller", e);
        }
    }

    public static Unmarshaller getUnmarshallerFor(Object obj, JAXBContext jaxbContext, boolean validate) {
        Class<?> clazz = obj instanceof Class ? obj : obj.getClass();
        Unmarshaller unmarshaller = null;
        Map<Class<?>, Unmarshaller> unmarshallers = m_unMarshallers.get();
        if (jaxbContext == null) {
            if (unmarshallers == null) {
                unmarshallers = new WeakHashMap();
                m_unMarshallers.set(unmarshallers);
            }
            if (unmarshallers.containsKey(clazz)) {
                LogUtils.tracef(clazz, (String)"found unmarshaller for %s", (Object[])new Object[]{clazz});
                unmarshaller = unmarshallers.get(clazz);
            }
        }
        if (unmarshaller == null) {
            try {
                JAXBContext context = jaxbContext == null ? JaxbUtils.getContextFor(clazz) : jaxbContext;
                unmarshaller = context.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw EXCEPTION_TRANSLATOR.translate("creating XML marshaller", e);
            }
        }
        LogUtils.tracef(clazz, (String)"created unmarshaller for %s", (Object[])new Object[]{clazz});
        if (validate) {
            Schema schema = JaxbUtils.getValidatorFor(clazz);
            if (schema == null) {
                LogUtils.tracef(clazz, (String)"Validation is enabled, but no XSD found for class %s", (Object[])new Object[]{clazz.getSimpleName()});
            }
            unmarshaller.setSchema(schema);
        }
        if (jaxbContext == null) {
            unmarshallers.put(clazz, unmarshaller);
        }
        return unmarshaller;
    }

    private static JAXBContext getContextFor(Class<?> clazz) throws JAXBException {
        JAXBContext context;
        if (m_contexts.containsKey(clazz)) {
            context = m_contexts.get(clazz);
        } else {
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            m_contexts.put(clazz, context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema getValidatorFor(Class<?> origClazz) {
        Class<?> clazz = origClazz instanceof Class ? origClazz : origClazz.getClass();
        LogUtils.tracef(clazz, (String)"finding XSD for class %s", (Object[])new Object[]{clazz});
        if (m_schemas.containsKey(clazz)) {
            return m_schemas.get(clazz);
        }
        ValidateUsing schemaFileAnnotation = clazz.getAnnotation(ValidateUsing.class);
        if (schemaFileAnnotation == null || schemaFileAnnotation.value() == null) {
            return null;
        }
        String schemaFileName = schemaFileAnnotation.value();
        InputStream schemaInputStream = null;
        try {
            URL schemaResource;
            File schemaFile;
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (schemaInputStream == null && (schemaFile = new File(System.getProperty("opennms.home") + "/share/xsds/" + schemaFileName)).exists()) {
                LogUtils.tracef(clazz, (String)"using file %s", (Object[])new Object[]{schemaFile});
                schemaInputStream = new FileInputStream(schemaFile);
            }
            if (schemaInputStream == null && (schemaFile = new File("target/xsds/" + schemaFileName)).exists()) {
                LogUtils.tracef(clazz, (String)"using file %s", (Object[])new Object[]{schemaFile});
                schemaInputStream = new FileInputStream(schemaFile);
            }
            if (schemaInputStream == null) {
                schemaResource = Thread.currentThread().getContextClassLoader().getResource("xsds/" + schemaFileName);
                if (schemaResource == null) {
                    LogUtils.debugf(clazz, (String)"Unable to load resource xsds/%s from the classpath.", (Object[])new Object[]{schemaFileName});
                } else {
                    LogUtils.tracef(clazz, (String)"using resource %s from classpath", (Object[])new Object[]{schemaResource});
                    schemaInputStream = schemaResource.openStream();
                }
            }
            if (schemaInputStream == null) {
                LogUtils.tracef(clazz, (String)"Did not find a suitable XSD.  Skipping.", (Object[])new Object[0]);
                schemaResource = null;
                return schemaResource;
            }
            Schema schema = factory.newSchema(new StreamSource(schemaInputStream));
            m_schemas.put(clazz, schema);
            Schema schema2 = schema;
            return schema2;
        }
        catch (Throwable t) {
            LogUtils.warnf(clazz, (Throwable)t, (String)"an error occurred while attempting to load %s for validation", (Object[])new Object[]{schemaFileName});
            Schema schema = null;
            return schema;
        }
        finally {
            IOUtils.closeQuietly(schemaInputStream);
        }
    }

    private static final class LoggingValidationEventHandler
    implements ValidationEventHandler {
        private final Class<?> m_clazz;

        private LoggingValidationEventHandler(Class<?> clazz) {
            this.m_clazz = clazz;
        }

        public boolean handleEvent(ValidationEvent event) {
            LogUtils.tracef(this.m_clazz, (Throwable)event.getLinkedException(), (String)"event = %s", (Object[])new Object[]{event});
            return false;
        }
    }
}

