/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;

public class AddEventVisitor
extends AbstractEntityVisitor {
    private static final String m_eventSource = "Provisiond";
    private final EventForwarder m_eventForwarder;

    public AddEventVisitor(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    @Override
    public void visitNode(OnmsNode node) {
        LogUtils.infof((Object)this, (String)"Sending nodeAdded Event for %s\n", (Object[])new Object[]{node});
        this.m_eventForwarder.sendNow(this.createNodeAddedEvent(node));
    }

    @Override
    public void visitIpInterface(OnmsIpInterface iface) {
        LogUtils.infof((Object)this, (String)"Sending nodeGainedInterface Event for %s\n", (Object[])new Object[]{iface});
        this.m_eventForwarder.sendNow(this.createNodeGainedInterfaceEvent(iface));
    }

    @Override
    public void visitMonitoredService(OnmsMonitoredService monSvc) {
        LogUtils.infof((Object)this, (String)"Sending nodeGainedService Event for %s\n", (Object[])new Object[]{monSvc});
        this.m_eventForwarder.sendNow(this.createNodeGainedServiceEvent(monSvc));
    }

    protected Event createNodeAddedEvent(OnmsNode node) {
        return EventUtils.createNodeAddedEvent(m_eventSource, node.getId(), node.getLabel(), node.getLabelSource());
    }

    protected Event createNodeGainedInterfaceEvent(OnmsIpInterface iface) {
        return EventUtils.createNodeGainedInterfaceEvent(m_eventSource, iface.getNode().getId(), iface.getIpAddress());
    }

    protected Event createNodeGainedServiceEvent(OnmsMonitoredService monSvc) {
        OnmsIpInterface iface = monSvc.getIpInterface();
        OnmsNode node = iface.getNode();
        LogUtils.debugf((Object)this, (String)"ipinterface = %s", (Object[])new Object[]{iface});
        LogUtils.debugf((Object)this, (String)"snmpinterface = %s", (Object[])new Object[]{iface.getSnmpInterface()});
        LogUtils.debugf((Object)this, (String)"node = %s", (Object[])new Object[]{node});
        return EventUtils.createNodeGainedServiceEvent(m_eventSource, monSvc.getNodeId(), iface.getIpAddress(), monSvc.getServiceType().getName(), node.getLabel(), node.getLabelSource(), node.getSysName(), node.getSysDescription());
    }
}

