/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Where;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="service")
@Entity
@Table(name="ifServices")
public class OnmsMonitoredService
extends OnmsEntity
implements Serializable,
Comparable<OnmsMonitoredService> {
    private static final long serialVersionUID = -7106081378757872886L;
    private Integer m_id;
    private Date m_lastGood;
    private Date m_lastFail;
    private String m_qualifier;
    private String m_status;
    private String m_source;
    private String m_notify;
    private OnmsServiceType m_serviceType;
    private OnmsIpInterface m_ipInterface;
    private Set<OnmsOutage> m_currentOutages = new LinkedHashSet<OnmsOutage>();
    private Set<OnmsApplication> m_applications = new LinkedHashSet<OnmsApplication>();
    private static final Map<String, String> STATUS_MAP = new HashMap<String, String>();

    public OnmsMonitoredService() {
    }

    public OnmsMonitoredService(OnmsIpInterface ipIf, OnmsServiceType serviceType) {
        this.m_ipInterface = ipIf;
        this.m_ipInterface.getMonitoredServices().add(this);
        this.m_serviceType = serviceType;
    }

    @Id
    @Column(nullable=false)
    @XmlAttribute(name="id")
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @XmlTransient
    @Transient
    public InetAddress getIpAddress() {
        return this.m_ipInterface.getIpAddress();
    }

    @XmlTransient
    @Transient
    public String getIpAddressAsString() {
        return this.m_ipInterface.getIpAddressAsString();
    }

    @XmlTransient
    @Transient
    public Integer getIfIndex() {
        return this.m_ipInterface.getIfIndex();
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastGood")
    public Date getLastGood() {
        return this.m_lastGood;
    }

    public void setLastGood(Date lastgood) {
        this.m_lastGood = lastgood;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastFail")
    public Date getLastFail() {
        return this.m_lastFail;
    }

    public void setLastFail(Date lastfail) {
        this.m_lastFail = lastfail;
    }

    @Column(name="qualifier", length=16)
    public String getQualifier() {
        return this.m_qualifier;
    }

    public void setQualifier(String qualifier) {
        this.m_qualifier = qualifier;
    }

    @XmlAttribute
    @Column(name="status", length=1)
    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    @Transient
    public String getStatusLong() {
        return STATUS_MAP.get(this.getStatus());
    }

    @XmlAttribute
    @Column(name="source", length=1)
    public String getSource() {
        return this.m_source;
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    @Column(name="notify", length=1)
    public String getNotify() {
        return this.m_notify;
    }

    public void setNotify(String notify) {
        this.m_notify = notify;
    }

    @XmlIDREF
    @XmlElement(name="ipInterfaceId")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="ipInterfaceId")
    public OnmsIpInterface getIpInterface() {
        return this.m_ipInterface;
    }

    public void setIpInterface(OnmsIpInterface ipInterface) {
        this.m_ipInterface = ipInterface;
    }

    @XmlTransient
    @Transient
    public Integer getNodeId() {
        return this.m_ipInterface.getNode().getId();
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="serviceId")
    public OnmsServiceType getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(OnmsServiceType service) {
        this.m_serviceType = service;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.m_id).append("lastGood", (Object)this.m_lastGood).append("lastFail", (Object)this.m_lastFail).append("qualifier", (Object)this.m_qualifier).append("status", (Object)this.m_status).append("source", (Object)this.m_source).append("notify", (Object)this.m_notify).append("serviceType", (Object)this.m_serviceType).toString();
    }

    @Transient
    public Integer getServiceId() {
        return this.getServiceType().getId();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitMonitoredService(this);
        visitor.visitMonitoredServiceComplete(this);
    }

    @Transient
    public String getServiceName() {
        return this.getServiceType().getName();
    }

    @Transient
    public boolean isDown() {
        boolean down = true;
        if (!"A".equals(this.getStatus()) || this.m_currentOutages.isEmpty()) {
            return !down;
        }
        return down;
    }

    @XmlTransient
    @OneToMany(mappedBy="monitoredService", fetch=FetchType.LAZY)
    @Where(clause="ifRegainedService is null")
    public Set<OnmsOutage> getCurrentOutages() {
        return this.m_currentOutages;
    }

    public void setCurrentOutages(Set<OnmsOutage> currentOutages) {
        this.m_currentOutages = currentOutages;
    }

    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="application_service_map", joinColumns={@JoinColumn(name="ifserviceid")}, inverseJoinColumns={@JoinColumn(name="appid")})
    public Set<OnmsApplication> getApplications() {
        return this.m_applications;
    }

    public void setApplications(Set<OnmsApplication> applications) {
        this.m_applications = applications;
    }

    public boolean addApplication(OnmsApplication application) {
        return this.getApplications().add(application);
    }

    public boolean removeApplication(OnmsApplication application) {
        return this.getApplications().remove(application);
    }

    @Override
    public int compareTo(OnmsMonitoredService o) {
        BigInteger b;
        int diff = this.getIpInterface().getNode().getLabel().compareToIgnoreCase(o.getIpInterface().getNode().getLabel());
        if (diff != 0) {
            return diff;
        }
        BigInteger a = InetAddressUtils.toInteger((InetAddress)this.getIpAddress());
        diff = a.compareTo(b = InetAddressUtils.toInteger((InetAddress)o.getIpAddress()));
        if (diff != 0) {
            return diff;
        }
        return this.getServiceName().compareToIgnoreCase(o.getServiceName());
    }

    public void mergeServiceAttributes(OnmsMonitoredService scanned) {
        if (OnmsMonitoredService.hasNewValue(scanned.getQualifier(), this.getQualifier())) {
            this.setQualifier(scanned.getQualifier());
        }
        if (this.hasNewStatusValue(scanned.getStatus(), this.getStatus())) {
            this.setStatus(scanned.getStatus());
        }
        if (OnmsMonitoredService.hasNewValue(scanned.getSource(), this.getSource())) {
            this.setSource(scanned.getSource());
        }
        if (OnmsMonitoredService.hasNewValue(scanned.getNotify(), this.getNotify())) {
            this.setNotify(scanned.getNotify());
        }
    }

    private boolean hasNewStatusValue(String newStatus, String oldStatus) {
        return !"N".equals(oldStatus) && newStatus != null && !newStatus.equals(oldStatus);
    }

    static {
        STATUS_MAP.put("A", "Managed");
        STATUS_MAP.put("U", "Unmanaged");
        STATUS_MAP.put("D", "Deleted");
        STATUS_MAP.put("F", "Forced Unmanaged");
        STATUS_MAP.put("N", "Not Monitored");
        STATUS_MAP.put("R", "Rescan to Resume");
        STATUS_MAP.put("S", "Rescan to Suspend");
        STATUS_MAP.put("X", "Remotely Monitored");
    }
}

