/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.annotations.CollectionOfElements;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="category")
@Entity
@Table(name="categories")
public class OnmsCategory
implements Serializable,
Comparable<OnmsCategory> {
    private static final long serialVersionUID = 4694348093332239377L;
    private Integer m_id;
    private String m_name;
    private String m_description;
    private Set<String> m_authorizedGroups = new HashSet<String>();

    public OnmsCategory(String name, String descr) {
        this.m_name = name;
        this.m_description = descr;
    }

    public OnmsCategory() {
    }

    public OnmsCategory(String name) {
        this();
        this.setName(name);
    }

    @Id
    @XmlAttribute(name="id")
    @Column(name="categoryid", nullable=false)
    @SequenceGenerator(name="categorySequence", sequenceName="catNxtId")
    @GeneratedValue(generator="categorySequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @XmlAttribute(name="name")
    @Column(name="categoryName", unique=true, nullable=false)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @XmlElement(name="description")
    @Column(name="categoryDescription")
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @CollectionOfElements
    @JoinTable(name="category_group", joinColumns={@JoinColumn(name="categoryId")})
    @Column(name="groupId", nullable=false, length=64)
    public Set<String> getAuthorizedGroups() {
        return this.m_authorizedGroups;
    }

    public void setAuthorizedGroups(Set<String> authorizedGroups) {
        this.m_authorizedGroups = authorizedGroups;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("description", (Object)this.getDescription()).append("authorizedGroups", this.getAuthorizedGroups()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OnmsCategory) {
            OnmsCategory t = (OnmsCategory)obj;
            return this.m_name.equals(t.m_name);
        }
        return false;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    @Override
    public int compareTo(OnmsCategory o) {
        return this.m_name.compareToIgnoreCase(o.m_name);
    }
}

