/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni6;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.util.Queue;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.icmp.jni6.Jni6PingRequest;
import org.opennms.netmgt.icmp.jni6.Jni6PingResponse;
import org.opennms.protocols.icmp6.ICMPv6EchoReply;
import org.opennms.protocols.icmp6.ICMPv6Packet;
import org.opennms.protocols.icmp6.ICMPv6Socket;
import org.opennms.protocols.rt.Messenger;

public class Jni6IcmpMessenger
implements Messenger<Jni6PingRequest, Jni6PingResponse> {
    private int m_pingerId;
    private ICMPv6Socket m_socket;

    public Jni6IcmpMessenger(int pingerId) throws IOException {
        this.m_pingerId = pingerId;
        this.m_socket = new ICMPv6Socket();
    }

    void processPackets(Queue<Jni6PingResponse> pendingReplies) {
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet;
                    Jni6PingResponse reply;
                    if ((reply = Jni6IcmpMessenger.createPingResponse(packet = this.m_socket.receive())) == null || reply.getIdentifier() != this.m_pingerId) {
                        continue;
                    }
                    pendingReplies.offer(reply);
                }
            }
            catch (IOException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"I/O Error occurred reading from ICMP Socket", (Object[])new Object[0]);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Throwable e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected Exception processing reply packet!", (Object[])new Object[0]);
                continue;
            }
            break;
        }
    }

    public void sendRequest(Jni6PingRequest request) {
        request.send(this.m_socket);
    }

    public void start(final Queue<Jni6PingResponse> responseQueue) {
        Thread socketReader = new Thread("JNI-ICMP-" + this.m_pingerId + "-Socket-Reader"){

            @Override
            public void run() {
                try {
                    Jni6IcmpMessenger.this.processPackets(responseQueue);
                }
                catch (Throwable t) {
                    LogUtils.errorf((Object)this, (Throwable)t, (String)"Unexpected exception on Thread %s!", (Object[])new Object[]{this});
                }
            }
        };
        socketReader.setDaemon(true);
        socketReader.start();
    }

    public static Jni6PingResponse createPingResponse(DatagramPacket packet) {
        ICMPv6Packet icmpPacket = new ICMPv6Packet(packet.getData(), packet.getOffset(), packet.getLength());
        if (icmpPacket.getType() != ICMPv6Packet.Type.EchoReply) {
            return null;
        }
        ICMPv6EchoReply echoReply = new ICMPv6EchoReply(icmpPacket);
        if (!echoReply.isEchoReply() || !echoReply.isValid()) {
            return null;
        }
        Inet6Address address = (Inet6Address)packet.getAddress();
        return new Jni6PingResponse(address, echoReply);
    }
}

