/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.standalone;

import java.net.InetAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.opennms.jicmp.standalone.Metric;
import org.opennms.jicmp.standalone.PingReply;
import org.opennms.jicmp.standalone.PingReplyListener;

public class PingReplyMetric
extends Metric
implements PingReplyListener {
    CountDownLatch m_latch;
    int m_count;
    long m_interval;

    public PingReplyMetric(int count, long interval) {
        this.m_latch = new CountDownLatch(count);
        this.m_count = count;
        this.m_interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPingReply(InetAddress address, PingReply reply) {
        try {
            this.update(reply.getElapsedTimeNanos());
        }
        finally {
            this.m_latch.countDown();
        }
    }

    public void await() throws InterruptedException {
        this.m_latch.await(this.m_interval * (long)this.m_count + 1000L, TimeUnit.MILLISECONDS);
    }
}

