/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV2TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;

public abstract class SnmpUtils {
    private static Properties sm_config;
    static final byte[] HEX_CHAR_TABLE;

    public static SnmpWalker createWalker(SnmpAgentConfig agentConfig, String name, CollectionTracker ... trackers) {
        return SnmpUtils.getStrategy().createWalker(agentConfig, name, SnmpUtils.createTooBigTracker(agentConfig, trackers));
    }

    private static TooBigReportingAggregator createTooBigTracker(SnmpAgentConfig agentConfig, CollectionTracker ... trackers) {
        return new TooBigReportingAggregator(trackers, agentConfig.getAddress());
    }

    public static SnmpWalker createWalker(SnmpAgentConfig agentConfig, String name, CollectionTracker tracker) {
        return SnmpUtils.getStrategy().createWalker(agentConfig, name, SnmpUtils.createTooBigTracker(agentConfig, tracker));
    }

    private static TooBigReportingAggregator createTooBigTracker(SnmpAgentConfig agentConfig, CollectionTracker tracker) {
        return SnmpUtils.createTooBigTracker(agentConfig, new CollectionTracker[]{tracker});
    }

    public static SnmpValue get(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        return SnmpUtils.getStrategy().get(agentConfig, oid);
    }

    public static SnmpValue[] get(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().get(agentConfig, oids);
    }

    public static SnmpValue getNext(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        return SnmpUtils.getStrategy().getNext(agentConfig, oid);
    }

    public static SnmpValue[] getNext(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().getNext(agentConfig, oids);
    }

    public static SnmpValue[] getBulk(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().getBulk(agentConfig, oids);
    }

    public static SnmpValue set(SnmpAgentConfig agentConfig, SnmpObjId oid, SnmpValue value) {
        return SnmpUtils.getStrategy().set(agentConfig, oid, value);
    }

    public static SnmpValue[] set(SnmpAgentConfig agentConfig, SnmpObjId[] oids, SnmpValue[] values) {
        return SnmpUtils.getStrategy().set(agentConfig, oids, values);
    }

    public static Properties getConfig() {
        return sm_config == null ? System.getProperties() : sm_config;
    }

    public static List<SnmpValue> getColumns(SnmpAgentConfig agentConfig, String name, SnmpObjId oid) throws InterruptedException {
        final ArrayList<SnmpValue> results = new ArrayList<SnmpValue>();
        SnmpWalker walker = SnmpUtils.createWalker(agentConfig, name, (CollectionTracker)new ColumnTracker(oid){

            @Override
            protected void storeResult(SnmpResult res) {
                results.add(res.getValue());
            }
        });
        walker.start();
        walker.waitFor();
        return results;
    }

    public static Map<SnmpInstId, SnmpValue> getOidValues(SnmpAgentConfig agentConfig, String name, SnmpObjId oid) throws InterruptedException {
        final LinkedHashMap<SnmpInstId, SnmpValue> results = new LinkedHashMap<SnmpInstId, SnmpValue>();
        SnmpWalker walker = SnmpUtils.createWalker(agentConfig, name, (CollectionTracker)new ColumnTracker(oid){

            @Override
            protected void storeResult(SnmpResult res) {
                results.put(res.getInstance(), res.getValue());
            }
        });
        walker.start();
        walker.waitFor();
        return results;
    }

    public static void setConfig(Properties config) {
        sm_config = config;
    }

    public static SnmpStrategy getStrategy() {
        String strategyClass = SnmpUtils.getStrategyClassName();
        try {
            return (SnmpStrategy)Class.forName(strategyClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class " + strategyClass, e);
        }
    }

    private static String getStrategyClassName() {
        return SnmpUtils.getConfig().getProperty("org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy");
    }

    public static void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, InetAddress address, int snmpTrapPort, List<SnmpV3User> snmpUsers) throws IOException {
        SnmpUtils.getStrategy().registerForTraps(listener, processorFactory, address, snmpTrapPort, snmpUsers);
    }

    public static void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, InetAddress address, int snmpTrapPort) throws IOException {
        SnmpUtils.getStrategy().registerForTraps(listener, processorFactory, address, snmpTrapPort);
    }

    public static void unregisterForTraps(TrapNotificationListener listener, InetAddress address, int snmpTrapPort) throws IOException {
        SnmpUtils.getStrategy().unregisterForTraps(listener, snmpTrapPort);
    }

    public static SnmpValueFactory getValueFactory() {
        return SnmpUtils.getStrategy().getValueFactory();
    }

    public static SnmpV1TrapBuilder getV1TrapBuilder() {
        return SnmpUtils.getStrategy().getV1TrapBuilder();
    }

    public static SnmpTrapBuilder getV2TrapBuilder() {
        return SnmpUtils.getStrategy().getV2TrapBuilder();
    }

    public static SnmpV3TrapBuilder getV3TrapBuilder() {
        return SnmpUtils.getStrategy().getV3TrapBuilder();
    }

    public static SnmpV2TrapBuilder getV2InformBuilder() {
        return SnmpUtils.getStrategy().getV2InformBuilder();
    }

    public static SnmpV3TrapBuilder getV3InformBuilder() {
        return SnmpUtils.getStrategy().getV3InformBuilder();
    }

    public static String getLocalEngineID() {
        return SnmpUtils.getHexString(SnmpUtils.getStrategy().getLocalEngineID());
    }

    public static String getHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        try {
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Long getProtoCounter64Value(SnmpValue value) {
        byte[] valBytes = value.getBytes();
        if (valBytes.length != 8) {
            LogUtils.tracef(SnmpUtils.class, (String)"Value should be 8 bytes long for a proto-Counter64 but this one is %d bytes.", (Object[])new Object[]{valBytes});
            return null;
        }
        if (value.isDisplayable()) {
            LogUtils.infof(SnmpUtils.class, (String)"Value '%s' is entirely displayable. Still treating it as a proto-Counter64. This may not be what you want.", (Object[])new Object[]{new String(valBytes)});
        }
        if (valBytes == new byte[]{-128, 0, 0, 0, 0, 0, 0, 0}) {
            LogUtils.tracef(SnmpUtils.class, (String)"Value has high-order bit set and all others zero, which indicates not supported in FCMGMT-MIB convention", (Object[])new Object[0]);
            return null;
        }
        Long retVal = Long.decode(String.format("0x%02x%02x%02x%02x%02x%02x%02x%02x", valBytes[0], valBytes[1], valBytes[2], valBytes[3], valBytes[4], valBytes[5], valBytes[6], valBytes[7]));
        LogUtils.tracef(SnmpUtils.class, (String)"Converted octet-string 0x%02x%02x%02x%02x%02x%02x%02x%02x as a proto-Counter64 of value %d", (Object[])new Object[]{valBytes[0], valBytes[1], valBytes[2], valBytes[3], valBytes[4], valBytes[5], valBytes[6], valBytes[7], retVal});
        return retVal;
    }

    static {
        HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    }

    private static final class TooBigReportingAggregator
    extends AggregateTracker {
        private final InetAddress address;

        private TooBigReportingAggregator(CollectionTracker[] children, InetAddress address) {
            super(children);
            this.address = address;
        }

        @Override
        protected void reportTooBigErr(String msg) {
            ThreadCategory.getInstance(SnmpWalker.class).info("Received tooBig response from " + this.address + ". " + msg);
        }
    }
}

