/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.Serializable;
import java.net.InetAddress;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.bind.InetAddressXmlAdapter;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="snmpAgentConfig")
public class SnmpAgentConfig
extends SnmpConfiguration
implements Serializable {
    private static final long serialVersionUID = 1456963719970029200L;
    private static Logger s_logger = LoggerFactory.getLogger(SnmpAgentConfig.class);
    private InetAddress m_address;
    private InetAddress m_proxyFor;

    public SnmpAgentConfig() {
        this((InetAddress)null);
    }

    public SnmpAgentConfig(InetAddress agentAddress) {
        this(agentAddress, SnmpConfiguration.DEFAULTS);
    }

    public SnmpAgentConfig(InetAddress agentAddress, SnmpConfiguration defaults) {
        super(defaults);
        this.m_address = agentAddress;
    }

    public static SnmpAgentConfig parseProtocolConfigurationString(String protocolConfigString) {
        String[] attributes;
        if (protocolConfigString == null) {
            throw new IllegalArgumentException("Protocol configuration string for SnmpAgentConfig must not be null.");
        }
        if (!protocolConfigString.startsWith("snmp:")) {
            throw new IllegalArgumentException("Invalid protocol configuration string for SnmpAgentConfig: Expected it to start with snmp:" + protocolConfigString);
        }
        SnmpAgentConfig agentConfig = new SnmpAgentConfig();
        for (String attribute : attributes = protocolConfigString.substring("snmp:".length()).split(",")) {
            String[] pair = attribute.split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException("unexpected format for key value pair in SnmpAgentConfig configuration string" + attribute);
            }
            String key = pair[0];
            String value = pair[1];
            if ("address".equalsIgnoreCase(key) && !"null".equals(value)) {
                agentConfig.setAddress(InetAddressUtils.addr((String)value));
                continue;
            }
            if ("port".equalsIgnoreCase(key)) {
                agentConfig.setPort(Integer.parseInt(value));
                continue;
            }
            if ("timeout".equalsIgnoreCase(key)) {
                agentConfig.setTimeout(Integer.parseInt(value));
                continue;
            }
            if ("retries".equalsIgnoreCase(key)) {
                agentConfig.setRetries(Integer.parseInt(value));
                continue;
            }
            if ("max-vars-per-pdu".equalsIgnoreCase(key)) {
                agentConfig.setMaxVarsPerPdu(Integer.parseInt(value));
                continue;
            }
            if ("max-repetitions".equalsIgnoreCase(key)) {
                agentConfig.setMaxRepetitions(Integer.parseInt(value));
                continue;
            }
            if ("max-request-size".equalsIgnoreCase(key)) {
                agentConfig.setMaxRequestSize(Integer.parseInt(value));
                continue;
            }
            if ("version".equalsIgnoreCase(key)) {
                agentConfig.setVersionAsString(value);
                continue;
            }
            if ("security-level".equalsIgnoreCase(key)) {
                agentConfig.setSecurityLevel(Integer.parseInt(value));
                continue;
            }
            if ("security-name".equalsIgnoreCase(key)) {
                agentConfig.setSecurityName(value);
                continue;
            }
            if ("auth-passphrase".equalsIgnoreCase(key)) {
                agentConfig.setAuthPassPhrase(value);
                continue;
            }
            if ("auth-protocol".equalsIgnoreCase(key)) {
                agentConfig.setAuthProtocol(value);
                continue;
            }
            if ("priv-passprhase".equalsIgnoreCase(key)) {
                agentConfig.setPrivPassPhrase(value);
                continue;
            }
            if ("priv-protocol".equalsIgnoreCase(key)) {
                agentConfig.setPrivProtocol(value);
                continue;
            }
            if ("read-community".equalsIgnoreCase(key)) {
                agentConfig.setReadCommunity(value);
                continue;
            }
            s_logger.warn("Unexpected attribute in protocol configuration string for SnmpAgentConfig: '{}'", (Object)attribute);
        }
        return agentConfig;
    }

    public String toProtocolConfigString() {
        StringBuffer buff = new StringBuffer("snmp:");
        buff.append("address=" + (this.m_address == null ? null : InetAddressUtils.str((InetAddress)this.m_address)));
        buff.append(",port=" + this.getPort());
        buff.append(",timeout=" + this.getTimeout());
        buff.append(",retries=" + this.getRetries());
        buff.append(",max-vars-per-pdu=" + this.getMaxVarsPerPdu());
        buff.append(",max-repetitions=" + this.getMaxRepetitions());
        buff.append(",max-request-size=" + this.getMaxRequestSize());
        buff.append(",version=" + SnmpAgentConfig.versionToString(this.getVersion()));
        if (this.getVersion() == 3) {
            buff.append(",security-level=" + this.getSecurityLevel());
            buff.append(",security-name=" + this.getSecurityName());
            buff.append(",auth-passphrase=" + this.getAuthPassPhrase());
            buff.append(",auth-protocol=" + this.getAuthProtocol());
            buff.append(",priv-passprhase=" + this.getPrivPassPhrase());
            buff.append(",priv-protocol=" + this.getPrivProtocol());
        } else {
            buff.append(",read-community=" + this.getReadCommunity());
        }
        return buff.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("AgentConfig[");
        buff.append("Address: " + (this.m_address == null ? null : InetAddressUtils.str((InetAddress)this.m_address)));
        buff.append(", ProxyForAddress: " + (this.m_proxyFor == null ? null : InetAddressUtils.str((InetAddress)this.m_proxyFor)));
        buff.append(", Port: " + this.getPort());
        buff.append(", Community: " + this.getReadCommunity());
        buff.append(", Timeout: " + this.getTimeout());
        buff.append(", Retries: " + this.getRetries());
        buff.append(", MaxVarsPerPdu: " + this.getMaxVarsPerPdu());
        buff.append(", MaxRepetitions: " + this.getMaxRepetitions());
        buff.append(", Max request size: " + this.getMaxRequestSize());
        buff.append(", Version: " + SnmpAgentConfig.versionToString(this.getVersion()));
        if (this.getVersion() == 3) {
            buff.append(", Security level: " + this.getSecurityLevel());
            buff.append(", Security name: " + this.getSecurityName());
            buff.append(", auth-passphrase: " + this.getAuthPassPhrase());
            buff.append(", auth-protocol: " + this.getAuthProtocol());
            buff.append(", priv-passprhase: " + this.getPrivPassPhrase());
            buff.append(", priv-protocol: " + this.getPrivProtocol());
        }
        buff.append("]");
        return buff.toString();
    }

    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getProxyFor() {
        return this.m_proxyFor;
    }

    public void setProxyFor(InetAddress address) {
        this.m_proxyFor = address;
    }

    @XmlTransient
    public InetAddress getEffectiveAddress() {
        if (this.m_proxyFor == null) {
            return this.m_address;
        }
        return this.m_proxyFor;
    }
}

