/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;

public class ColumnTracker
extends CollectionTracker {
    private SnmpObjId m_base;
    private SnmpObjId m_last;
    private int m_maxRepetitions;

    public ColumnTracker(SnmpObjId base) {
        this(null, base);
    }

    public ColumnTracker(SnmpObjId base, int maxRepititions) {
        this(null, base, maxRepititions);
    }

    public ColumnTracker(CollectionTracker parent, SnmpObjId base) {
        this(parent, base, 2);
    }

    public ColumnTracker(CollectionTracker parent, SnmpObjId base, int maxRepititions) {
        super(parent);
        this.m_base = base;
        this.m_last = base;
        this.m_maxRepetitions = maxRepititions;
    }

    public SnmpObjId getBase() {
        return this.m_base;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("base", (Object)this.m_base).append("last oid", (Object)this.m_last).append("max repetitions", this.m_maxRepetitions).append("finished?", this.isFinished()).toString();
    }

    @Override
    public ResponseProcessor buildNextPdu(PduBuilder pduBuilder) {
        if (pduBuilder.getMaxVarsPerPdu() < 1) {
            throw new IllegalArgumentException("maxVarsPerPdu < 1");
        }
        this.log().debug("Requesting oid following: " + this.m_last);
        pduBuilder.addOid(this.m_last);
        pduBuilder.setNonRepeaters(0);
        pduBuilder.setMaxRepetitions(this.getMaxRepetitions());
        ResponseProcessor rp = new ResponseProcessor(){

            @Override
            public void processResponse(SnmpObjId responseObjId, SnmpValue val) {
                SnmpInstId inst;
                if (val.isEndOfMib()) {
                    ColumnTracker.this.receivedEndOfMib();
                    return;
                }
                ColumnTracker.this.log().debug("Processing varBind: " + responseObjId + " = " + val);
                ColumnTracker.this.m_last = responseObjId;
                if (ColumnTracker.this.m_base.isPrefixOf(responseObjId) && !ColumnTracker.this.m_base.equals(responseObjId) && (inst = responseObjId.getInstance(ColumnTracker.this.m_base)) != null) {
                    ColumnTracker.this.storeResult(new SnmpResult(ColumnTracker.this.m_base, inst, val));
                }
                if (!ColumnTracker.this.m_base.isPrefixOf(ColumnTracker.this.m_last)) {
                    ColumnTracker.this.setFinished(true);
                }
            }

            @Override
            public boolean processErrors(int errorStatus, int errorIndex) {
                if (errorStatus == 0) {
                    return false;
                }
                if (errorStatus == 1) {
                    throw new IllegalArgumentException("Unable to handle tooBigError for next oid request after " + ColumnTracker.this.m_last);
                }
                if (errorStatus == 5) {
                    ColumnTracker.this.reportGenErr("Received genErr requesting next oid after " + ColumnTracker.this.m_last + ". Marking column is finished.");
                    ColumnTracker.this.errorOccurred();
                    return true;
                }
                if (errorStatus == 2) {
                    ColumnTracker.this.reportNoSuchNameErr("Received noSuchName requesting next oid after " + ColumnTracker.this.m_last + ". Marking column is finished.");
                    ColumnTracker.this.errorOccurred();
                    return true;
                }
                throw new IllegalArgumentException("Unexpected error processing next oid after " + ColumnTracker.this.m_last + ". Aborting!");
            }
        };
        return rp;
    }

    public int getMaxRepetitions() {
        return this.m_maxRepetitions;
    }

    @Override
    public void setMaxRepetitions(int maxRepetitions) {
        this.m_maxRepetitions = maxRepetitions;
    }

    protected void receivedEndOfMib() {
        this.setFinished(true);
    }

    protected void errorOccurred() {
        this.setFinished(true);
    }

    public SnmpInstId getLastInstance() {
        if (this.m_base.isPrefixOf(this.m_last) && !this.m_base.equals(this.m_last)) {
            return this.m_last.getInstance(this.m_base);
        }
        return null;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

