/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.config.groups.Time;

public class WebSchedEntry {
    int m_schedIndex;
    int m_timeIndex;
    String m_user;
    String m_type;
    String m_day;
    String m_begins;
    String m_ends;

    public WebSchedEntry(int schedIndex, int timeIndex, String user, Date startDate, Date endDate) {
        this(schedIndex, timeIndex, user, new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(startDate), new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(endDate));
    }

    public WebSchedEntry(int schedIndex, int timeIndex, String user, String begins, String ends) {
        this.m_schedIndex = schedIndex;
        this.m_timeIndex = timeIndex;
        this.m_type = "specific";
        this.m_day = null;
        this.m_user = user;
        this.m_begins = begins;
        this.m_ends = ends;
    }

    public boolean isNew() {
        return this.m_schedIndex == -1 && this.m_timeIndex == -1;
    }

    public void update(Role role) {
        if (this.isNew()) {
            this.addToRole(role);
        } else {
            this.modifyRole(role);
        }
    }

    private void modifyRole(Role role) {
        Schedule sched = role.getSchedule(this.m_schedIndex);
        Time time = sched.getTime(this.m_timeIndex);
        sched.setName(this.m_user);
        sched.setType(this.m_type);
        time.setDay(this.m_day);
        time.setBegins(this.m_begins);
        time.setEnds(this.m_ends);
    }

    private void addToRole(Role role) {
        Schedule sched = new Schedule();
        sched.setName(this.m_user);
        sched.setType(this.m_type);
        Time time = new Time();
        if (this.m_day != null) {
            time.setDay(this.m_day);
        }
        time.setBegins(this.m_begins);
        time.setEnds(this.m_ends);
        sched.addTime(time);
        role.addSchedule(sched);
    }
}

