/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;

public final class ThresholdingConfigFactory {
    private static ThresholdingConfigFactory m_singleton = null;
    private ThresholdingConfig m_config;
    private static boolean m_loaded = false;
    private Map<String, Group> m_groupMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThresholdingConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.parseXML(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public ThresholdingConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.parseXML(stream);
    }

    private void parseXML(InputStream stream) throws MarshalException, ValidationException {
        this.m_config = (ThresholdingConfig)CastorUtils.unmarshal(ThresholdingConfig.class, (InputStream)stream);
        this.initGroupMap();
    }

    private void initGroupMap() {
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        for (Group g : this.m_config.getGroupCollection()) {
            groupMap.put(g.getName(), g);
        }
        this.m_groupMap = groupMap;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
        if (ThresholdingConfigFactory.log().isDebugEnabled()) {
            ThresholdingConfigFactory.log().debug("init: config file path: " + cfgFile.getPath());
        }
        ThresholdingConfigFactory tcf = new ThresholdingConfigFactory(cfgFile.getPath());
        for (String groupName : tcf.getGroupNames()) {
            Group g = tcf.getGroup(groupName);
            for (Threshold threshold : g.getThresholdCollection()) {
                if (threshold.getDsName().length() <= 19) continue;
                throw new ValidationException(String.format("ds-name '%s' in group '%s' is greater than %d characters", threshold.getDsName(), groupName, 19));
            }
        }
        m_singleton = tcf;
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ThresholdingConfigFactory.init();
    }

    public static synchronized ThresholdingConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(ThresholdingConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    public String getRrdRepository(String groupName) {
        return this.getGroup(groupName).getRrdRepository();
    }

    public Group getGroup(String groupName) {
        Group group = this.m_groupMap.get(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Thresholding group " + groupName + " does not exist.");
        }
        return group;
    }

    public Collection<Basethresholddef> getThresholds(String groupName) {
        Group group = this.getGroup(groupName);
        ArrayList<Basethresholddef> result = new ArrayList<Basethresholddef>();
        result.addAll(group.getThresholdCollection());
        result.addAll(group.getExpressionCollection());
        return result;
    }

    public Collection<String> getGroupNames() {
        return Collections.unmodifiableCollection(this.m_groupMap.keySet());
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        if (xmlString != null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xmlString);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            this.parseXML(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(ThresholdingConfigFactory.class);
    }
}

