/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.math.BigInteger;
import java.net.UnknownHostException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.MergeableSpecific;
import org.opennms.netmgt.config.RangeComparator;
import org.opennms.netmgt.config.snmp.Range;

final class MergeableRange
implements Comparable<Range> {
    private Range m_range;
    private static final RangeComparator m_comparator = new RangeComparator();
    private final MergeableSpecific m_first;
    private final MergeableSpecific m_last;

    public MergeableRange(Range range) {
        this.m_range = range;
        this.m_first = new MergeableSpecific(range.getBegin());
        this.m_last = new MergeableSpecific(range.getEnd());
    }

    @Override
    public int compareTo(Range range) {
        return m_comparator.compare(this.getRange(), range);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj == null) {
            equals = false;
        } else if (obj instanceof Range) {
            equals = this.equalsRange((Range)obj);
        }
        return equals;
    }

    public int hashCode() {
        return 0;
    }

    private boolean equalsMergeableRange(MergeableRange range) {
        boolean equals = false;
        if (this.getFirst() == range.getFirst() && this.getLast() == range.getLast()) {
            equals = true;
        }
        return equals;
    }

    private boolean equalsRange(Range range) {
        return this.equalsMergeableRange(new MergeableRange(range));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range getRange() {
        Range range = this.m_range;
        synchronized (range) {
            return this.m_range;
        }
    }

    public boolean coversSpecific(String spec) {
        boolean covers = false;
        if (this.getFirst().compareTo(spec) <= 0 && this.getLast().compareTo(spec) >= 0) {
            covers = true;
        }
        return covers;
    }

    public boolean overlapsBegin(Range rng) {
        boolean overlaps = false;
        if (this.m_first.compareTo(rng.getBegin()) < 0 && this.m_last.compareTo(rng.getBegin()) >= 0 && this.m_last.compareTo(rng.getEnd()) <= 0) {
            overlaps = true;
        }
        return overlaps;
    }

    public boolean withInRange(Range rng) {
        boolean within = false;
        if (this.m_first.compareTo(rng.getBegin()) >= 0 && this.m_last.compareTo(rng.getEnd()) <= 0) {
            within = true;
        }
        return within;
    }

    public boolean overlapsEnd(Range rng) {
        boolean overlaps = false;
        if (this.m_first.compareTo(rng.getBegin()) >= 0 && this.m_first.compareTo(rng.getEnd()) <= 0 && this.m_last.compareTo(rng.getEnd()) > 0) {
            overlaps = true;
        }
        return overlaps;
    }

    public boolean eclipses(Range rng) {
        boolean eclipses = false;
        if (this.m_first.compareTo(rng.getBegin()) <= 0 && this.m_last.compareTo(rng.getEnd()) >= 0) {
            eclipses = true;
        }
        return eclipses;
    }

    public boolean isAdjacentToBegin(Range nextRange) {
        return new BigInteger("-1").equals(InetAddressUtils.difference((String)this.m_last.getSpecific(), (String)nextRange.getBegin()));
    }

    public boolean isAdjacentToEnd(Range nextRange) {
        return new BigInteger("-1").equals(InetAddressUtils.difference((String)this.m_first.getSpecific(), (String)nextRange.getEnd()));
    }

    protected Range removeSpecificFromRange(String spec) {
        if (!this.coversSpecific(spec)) {
            throw new IllegalArgumentException("Specific: " + spec + ", doesn't affect range: ");
        }
        MergeableSpecific specific = new MergeableSpecific(spec);
        Range newRange = null;
        ByteArrayComparator comparator = new ByteArrayComparator();
        try {
            if (comparator.compare(specific.getValue(), this.getFirst().getValue()) == 0) {
                this.getRange().setBegin(InetAddressUtils.incr((String)specific.getSpecific()));
            } else if (comparator.compare(specific.getValue(), this.getLast().getValue()) == 0) {
                this.getRange().setEnd(InetAddressUtils.decr((String)specific.getSpecific()));
            } else {
                newRange = new Range();
                newRange.setBegin(InetAddressUtils.incr((String)specific.getSpecific()));
                newRange.setEnd(this.getRange().getEnd());
                this.getRange().setEnd(InetAddressUtils.decr((String)specific.getSpecific()));
            }
        }
        catch (UnknownHostException e) {
            ThreadCategory.getInstance(this.getClass()).error("Error converting string to IP address: " + e.getMessage(), (Throwable)e);
        }
        return newRange;
    }

    public MergeableSpecific getFirst() {
        return this.m_first;
    }

    public MergeableSpecific getLast() {
        return this.m_last;
    }
}

