/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.linkd.ExcludeRange;
import org.opennms.netmgt.config.linkd.Filter;
import org.opennms.netmgt.config.linkd.IncludeRange;
import org.opennms.netmgt.config.linkd.Iproutes;
import org.opennms.netmgt.config.linkd.LinkdConfiguration;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.config.linkd.Vendor;
import org.opennms.netmgt.config.linkd.Vlans;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.protocols.snmp.SnmpObjectId;

public abstract class LinkdConfigManager
implements LinkdConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    public static final String DEFAULT_IP_ROUTE_CLASS_NAME = "org.opennms.netmgt.linkd.snmp.IpCidrRouteTable";
    protected static LinkdConfiguration m_config;
    private static Map<String, List<String>> m_urlIPMap;
    private static Map<Package, List<InetAddress>> m_pkgIpMap;
    private static Map<String, String> m_oidMask2VlanclassName;
    private static Map<String, String> m_oidMask2IpRouteclassName;

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoDiscoveryEnabled() {
        this.getReadLock().lock();
        try {
            if (m_config.hasAutoDiscovery()) {
                boolean bl = m_config.getAutoDiscovery();
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVlanDiscoveryEnabled() {
        this.getReadLock().lock();
        try {
            if (m_config.hasEnableVlanDiscovery()) {
                boolean bl = m_config.getEnableVlanDiscovery();
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInterfaceInPackage(InetAddress iface, Package pkg) {
        boolean filterPassed = false;
        this.getReadLock().lock();
        try {
            List<InetAddress> ipList = m_pkgIpMap.get(pkg);
            if (ipList != null && ipList.size() > 0) {
                filterPassed = ipList.contains(iface);
            }
            LogUtils.debugf((Object)this, (String)"interfaceInPackage: Interface %s passed filter for package %s?: %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)iface), pkg.getName(), filterPassed ? "True" : "False"});
            if (!filterPassed) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.isInterfaceInPackageRange(iface, pkg);
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInterfaceInPackageRange(InetAddress iface, Package pkg) {
        if (pkg == null) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        this.getReadLock().lock();
        try {
            String url;
            byte[] addr = iface.getAddress();
            has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
            for (String spec : pkg.getSpecificCollection()) {
                byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
                if (new ByteArrayComparator().compare(addr, speca) != 0) continue;
                has_specific = true;
                break;
            }
            if (has_specific) {
                boolean i$ = true;
                return i$;
            }
            Iterator i$ = pkg.getIncludeUrlCollection().iterator();
            while (i$.hasNext() && !(has_specific = this.isInterfaceInUrl(iface, url = (String)i$.next()))) {
            }
            if (has_specific) {
                boolean i$2 = true;
                return i$2;
            }
            if (!has_range_include) {
                for (IncludeRange rng : pkg.getIncludeRangeCollection()) {
                    if (!InetAddressUtils.isInetAddressInRange((byte[])iface.getAddress(), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                    has_range_include = true;
                    break;
                }
            }
            for (IncludeRange rng : pkg.getExcludeRangeCollection()) {
                if (!InetAddressUtils.isInetAddressInRange((byte[])iface.getAddress(), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                has_range_exclude = true;
                break;
            }
            boolean bl = has_range_include && !has_range_exclude;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Package> enumeratePackage() {
        this.getReadLock().lock();
        try {
            Enumeration enumeration = this.getConfiguration().enumeratePackage();
            return enumeration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkdConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            LinkdConfiguration linkdConfiguration = m_config;
            return linkdConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String name) {
        this.getReadLock().lock();
        try {
            for (Package thisPackage : m_config.getPackageCollection()) {
                String n = thisPackage.getName();
                if (n == null || !n.equals(name)) continue;
                Package package_ = thisPackage;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InetAddress> getIpList(Package pkg) {
        this.getReadLock().lock();
        try {
            if (pkg == null) {
                List<InetAddress> list = null;
                return list;
            }
            Filter filter = pkg.getFilter();
            if (filter == null) {
                List<InetAddress> list = null;
                return list;
            }
            StringBuffer filterRules = new StringBuffer(filter.getContent());
            LogUtils.debugf((Object)this, (String)"getIpList: package is %s. filter rules are: %s", (Object[])new Object[]{pkg.getName(), filterRules.toString()});
            List<InetAddress> list = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIpRouteClassName(String sysoid) {
        this.getReadLock().lock();
        try {
            for (String oidMask : m_oidMask2IpRouteclassName.keySet()) {
                if (!sysoid.startsWith(oidMask)) continue;
                String string = m_oidMask2IpRouteclassName.get(oidMask);
                return string;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return DEFAULT_IP_ROUTE_CLASS_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVlanClassName(String sysoid) {
        this.getReadLock().lock();
        try {
            for (String oidMask : m_oidMask2VlanclassName.keySet()) {
                if (!sysoid.startsWith(oidMask)) continue;
                String string = m_oidMask2VlanclassName.get(oidMask);
                return string;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getFirstPackageMatch(InetAddress ipaddr) {
        this.getReadLock().lock();
        try {
            for (Package pkg : m_config.getPackageCollection()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllPackageMatches(InetAddress ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        this.getReadLock().lock();
        try {
            for (Package pkg : m_config.getPackageCollection()) {
                String pkgName = pkg.getName();
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                matchingPkgs.add(pkgName);
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasClassName(String sysoid) {
        this.getReadLock().lock();
        try {
            for (String oidMask : m_oidMask2VlanclassName.keySet()) {
                if (!sysoid.startsWith(oidMask)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    @Override
    public String getDefaultIpRouteClassName() {
        return DEFAULT_IP_ROUTE_CLASS_NAME;
    }

    @Override
    public boolean useIpRouteDiscovery() {
        if (m_config.hasUseIpRouteDiscovery()) {
            return m_config.getUseIpRouteDiscovery();
        }
        return true;
    }

    @Override
    public boolean saveRouteTable() {
        if (m_config.hasSaveRouteTable()) {
            return m_config.getSaveRouteTable();
        }
        return true;
    }

    @Override
    public boolean useCdpDiscovery() {
        if (m_config.hasUseCdpDiscovery()) {
            return m_config.getUseCdpDiscovery();
        }
        return true;
    }

    @Override
    public boolean useBridgeDiscovery() {
        if (m_config.hasUseBridgeDiscovery()) {
            return m_config.getUseBridgeDiscovery();
        }
        return true;
    }

    @Override
    public boolean useLldpDiscovery() {
        if (m_config.hasUseLldpDiscovery()) {
            return m_config.getUseLldpDiscovery();
        }
        return true;
    }

    @Override
    public boolean useOspfDiscovery() {
        if (m_config.hasUseOspfDiscovery()) {
            return m_config.getUseOspfDiscovery();
        }
        return true;
    }

    @Override
    public boolean saveStpNodeTable() {
        if (m_config.hasSaveStpNodeTable()) {
            return m_config.getSaveStpNodeTable();
        }
        return true;
    }

    @Override
    public boolean enableDiscoveryDownload() {
        if (m_config.hasEnableDiscoveryDownload()) {
            return m_config.getEnableDiscoveryDownload();
        }
        return false;
    }

    @Override
    public boolean saveStpInterfaceTable() {
        if (m_config.hasSaveStpInterfaceTable()) {
            return m_config.getSaveStpInterfaceTable();
        }
        return true;
    }

    @Override
    public long getInitialSleepTime() {
        if (m_config.hasInitial_sleep_time()) {
            return m_config.getInitial_sleep_time();
        }
        return 1800000L;
    }

    @Override
    public long getSnmpPollInterval() {
        if (m_config.hasSnmp_poll_interval()) {
            return m_config.getSnmp_poll_interval();
        }
        return 900000L;
    }

    @Override
    public long getDiscoveryLinkInterval() {
        if (m_config.hasSnmp_poll_interval()) {
            return m_config.getDiscovery_link_interval();
        }
        return 3600000L;
    }

    @Override
    public int getThreads() {
        if (m_config.hasThreads()) {
            return m_config.getThreads();
        }
        return 5;
    }

    @Override
    public boolean hasIpRouteClassName(String sysoid) {
        for (String oidMask : m_oidMask2IpRouteclassName.keySet()) {
            if (!sysoid.startsWith(oidMask)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract void update();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePackageIpListMap() {
        m_pkgIpMap.clear();
        this.getWriteLock().lock();
        try {
            for (Package pkg : m_config.getPackageCollection()) {
                try {
                    List<InetAddress> ipList = this.getIpList(pkg);
                    LogUtils.tracef((Object)this, (String)"createPackageIpMap: package %s: ipList size = %d", (Object[])new Object[]{pkg.getName(), ipList.size()});
                    if (ipList == null || ipList.size() <= 0) continue;
                    m_pkgIpMap.put(pkg, ipList);
                }
                catch (Throwable t) {
                    LogUtils.errorf((Object)this, (Throwable)t, (String)"createPackageIpMap: failed to map package: %s to an IP list", (Object[])new Object[]{pkg.getName()});
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected void updateUrlIpMap() {
        m_urlIPMap.clear();
        for (Package pkg : m_config.getPackageCollection()) {
            if (pkg == null) continue;
            for (String urlname : pkg.getIncludeUrlCollection()) {
                List iplist = IpListFromUrl.parse((String)urlname);
                if (iplist.size() <= 0) continue;
                m_urlIPMap.put(urlname, iplist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIpRouteClassNames() {
        m_oidMask2IpRouteclassName.clear();
        this.getWriteLock().lock();
        try {
            Iproutes iproutes = m_config.getIproutes();
            if (iproutes == null) {
                LogUtils.infof((Object)this, (String)"no iproutes found in config", (Object[])new Object[0]);
                return;
            }
            for (Vendor vendor : iproutes.getVendorCollection()) {
                SnmpObjectId curRootSysOid = new SnmpObjectId(vendor.getSysoidRootMask());
                String curClassName = vendor.getClassName();
                for (String specific : vendor.getSpecific()) {
                    SnmpObjectId oidMask = new SnmpObjectId(specific);
                    oidMask.prepend(curRootSysOid);
                    m_oidMask2IpRouteclassName.put(oidMask.toString(), curClassName);
                    LogUtils.debugf((Object)this, (String)"initializeIpRouteClassNames:  adding class %s for oid %s", (Object[])new Object[]{curClassName, oidMask.toString()});
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateVlanClassNames() {
        m_oidMask2VlanclassName.clear();
        this.getWriteLock().lock();
        try {
            Vlans vlans = m_config.getVlans();
            if (vlans == null) {
                LogUtils.infof((Object)this, (String)"initializeVlanClassNames: no vlans found in config", (Object[])new Object[0]);
            }
            ArrayList<String> excludedOids = new ArrayList<String>();
            for (Vendor vendor : vlans.getVendorCollection()) {
                int[] identifiers;
                SnmpObjectId snmpCurOid;
                SnmpObjectId snmpEndOid;
                SnmpObjectId curRootSysOid = new SnmpObjectId(vendor.getSysoidRootMask());
                String curClassName = vendor.getClassName();
                for (String specific : vendor.getSpecific()) {
                    SnmpObjectId oidMask = new SnmpObjectId(specific);
                    oidMask.prepend(curRootSysOid);
                    m_oidMask2VlanclassName.put(oidMask.toString(), curClassName);
                    LogUtils.debugf((Object)this, (String)"initializeVlanClassNames:  adding class %s for oid %s", (Object[])new Object[]{curClassName, oidMask.toString()});
                }
                for (ExcludeRange excludeRange : vendor.getExcludeRangeCollection()) {
                    SnmpObjectId snmpBeginOid = new SnmpObjectId(excludeRange.getBegin());
                    snmpEndOid = new SnmpObjectId(excludeRange.getEnd());
                    SnmpObjectId snmpRootOid = this.getRootOid(snmpBeginOid);
                    if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !snmpRootOid.isRootOf(snmpEndOid)) continue;
                    snmpCurOid = new SnmpObjectId(snmpBeginOid);
                    while (snmpCurOid.compare(snmpEndOid) <= 0) {
                        excludedOids.add(snmpCurOid.toString());
                        LogUtils.debugf((Object)this, (String)"initializeVlanClassNames:  signing excluded class %s for oid %s", (Object[])new Object[]{curClassName, curRootSysOid.toString().concat(snmpCurOid.toString())});
                        int lastCurCipher = snmpCurOid.getLastIdentifier();
                        identifiers = snmpCurOid.getIdentifiers();
                        identifiers[identifiers.length - 1] = ++lastCurCipher;
                        snmpCurOid.setIdentifiers(identifiers);
                    }
                }
                for (IncludeRange includeRange : vendor.getIncludeRangeCollection()) {
                    SnmpObjectId snmpBeginOid = new SnmpObjectId(includeRange.getBegin());
                    snmpEndOid = new SnmpObjectId(includeRange.getEnd());
                    SnmpObjectId rootOid = this.getRootOid(snmpBeginOid);
                    if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !rootOid.isRootOf(snmpEndOid)) continue;
                    snmpCurOid = new SnmpObjectId(snmpBeginOid);
                    while (snmpCurOid.compare(snmpEndOid) <= 0) {
                        if (!excludedOids.contains(snmpBeginOid.toString())) {
                            SnmpObjectId oidMask = new SnmpObjectId(snmpBeginOid);
                            oidMask.prepend(curRootSysOid);
                            m_oidMask2VlanclassName.put(oidMask.toString(), curClassName);
                            LogUtils.debugf((Object)this, (String)"initializeVlanClassNames:  adding class %s for oid %s", (Object[])new Object[]{curClassName, oidMask.toString()});
                        }
                        int lastCipher = snmpBeginOid.getLastIdentifier();
                        identifiers = snmpBeginOid.getIdentifiers();
                        identifiers[identifiers.length - 1] = ++lastCipher;
                        snmpCurOid.setIdentifiers(identifiers);
                    }
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnmpObjectId getRootOid(SnmpObjectId snmpObj) {
        this.getReadLock().lock();
        try {
            int[] identifiers = snmpObj.getIdentifiers();
            int[] rootIdentifiers = new int[identifiers.length - 1];
            for (int i = 0; i < identifiers.length - 1; ++i) {
                rootIdentifiers[i] = identifiers[i];
            }
            SnmpObjectId snmpObjectId = new SnmpObjectId(rootIdentifiers);
            return snmpObjectId;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInterfaceInUrl(InetAddress addr, String url) {
        this.getReadLock().lock();
        try {
            List<String> iplist = m_urlIPMap.get(url);
            if (iplist != null && iplist.size() > 0) {
                boolean bl = iplist.contains(InetAddressUtils.str((InetAddress)addr));
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    protected abstract void saveXml(String var1) throws IOException;

    @Override
    public boolean forceIpRouteDiscoveryOnEthernet() {
        if (m_config.hasForceIpRouteDiscoveryOnEthernet()) {
            return m_config.getForceIpRouteDiscoveryOnEthernet();
        }
        return false;
    }

    static {
        m_urlIPMap = new HashMap<String, List<String>>();
        m_pkgIpMap = new HashMap<Package, List<InetAddress>>();
        m_oidMask2VlanclassName = new HashMap<String, String>();
        m_oidMask2IpRouteclassName = new HashMap<String, String>();
    }
}

