/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.BaseConnectionFactory;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import snaq.db.DBPoolDataSource;

public class DBPoolConnectionFactory
extends BaseConnectionFactory {
    private DBPoolDataSource m_dataSource;

    public DBPoolConnectionFactory(InputStream stream, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(stream, dsName);
    }

    public DBPoolConnectionFactory(String configFile, String dsName) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(configFile, dsName);
    }

    protected void initializePool(JdbcDataSource dataSource) throws SQLException {
        this.m_dataSource = new DBPoolDataSource();
        this.m_dataSource.setName(dataSource.getName());
        this.m_dataSource.setDriverClassName(dataSource.getClassName());
        this.m_dataSource.setUrl(dataSource.getUrl());
        this.m_dataSource.setUser(dataSource.getUserName());
        this.m_dataSource.setPassword(dataSource.getPassword());
    }

    public Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    public String getUrl() {
        return this.m_dataSource.getUrl();
    }

    public void setUrl(String url) {
        DBPoolConnectionFactory.validateJdbcUrl((String)url);
        this.m_dataSource.setUrl(url);
    }

    public String getUser() {
        return this.m_dataSource.getUser();
    }

    public void setUser(String user) {
        this.m_dataSource.setUser(user);
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_dataSource.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_dataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    public void close() throws SQLException {
        super.close();
        LogUtils.infof((Object)((Object)this), (String)"Closing DBPool pool.", (Object[])new Object[0]);
        this.m_dataSource.release();
    }

    public void setIdleTimeout(int idleTimeout) {
        this.m_dataSource.setIdleTimeout(idleTimeout);
    }

    public void setMinPool(int minPool) {
        this.m_dataSource.setMinPool(minPool);
    }

    public void setMaxPool(int maxPool) {
        this.m_dataSource.setMaxPool(maxPool);
    }

    public void setMaxSize(int maxSize) {
        this.m_dataSource.setMaxSize(maxSize);
    }
}

