/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.IncludeURL;
import org.opennms.netmgt.config.collectd.ExcludeRange;
import org.opennms.netmgt.config.collectd.IncludeRange;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.filter.FilterDaoFactory;

public class CollectdPackage {
    private Package m_pkg;
    private List<InetAddress> m_ipList;
    private List<IncludeURL> m_includeURLs;

    public CollectdPackage(Package pkg, String localServer, boolean verifyServer) {
        this.m_pkg = pkg;
        this.m_includeURLs = new LinkedList<IncludeURL>();
        this.createIpList(localServer, verifyServer);
        this.createIncludeURLs(pkg);
    }

    private void createIncludeURLs(Package pkg) {
        Enumeration urlEnum = pkg.enumerateIncludeUrl();
        while (urlEnum.hasMoreElements()) {
            this.m_includeURLs.add(new IncludeURL((String)urlEnum.nextElement()));
        }
    }

    public Package getPackage() {
        return this.m_pkg;
    }

    public boolean serviceInPackageAndEnabled(String svcName) {
        Package pkg = this.getPackage();
        boolean result = false;
        Enumeration esvcs = pkg.enumerateService();
        while (!result && esvcs.hasMoreElements()) {
            String status;
            Service tsvc = (Service)esvcs.nextElement();
            if (!tsvc.getName().equalsIgnoreCase(svcName) || !(status = tsvc.getStatus()).equals("on")) continue;
            result = true;
        }
        return result;
    }

    protected boolean hasSpecific(byte[] addr) {
        for (String espec : this.getPackage().getSpecific()) {
            if (new ByteArrayComparator().compare(InetAddressUtils.toIpAddrBytes((String)espec), addr) != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean hasIncludeRange(String addr) {
        Package pkg = this.getPackage();
        if (pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0) {
            return true;
        }
        for (IncludeRange rng : pkg.getIncludeRange()) {
            if (!InetAddressUtils.isInetAddressInRange((String)addr, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.m_pkg.getName();
    }

    protected boolean hasExcludeRange(String addr, boolean has_specific) {
        for (ExcludeRange rng : this.getPackage().getExcludeRange()) {
            if (!InetAddressUtils.isInetAddressInRange((String)addr, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            return true;
        }
        return false;
    }

    public void putIpList(List<InetAddress> ipList) {
        this.m_ipList = ipList;
    }

    protected List<InetAddress> getIpList() {
        return this.m_ipList;
    }

    protected boolean interfaceInFilter(String iface) {
        if (iface == null) {
            return false;
        }
        InetAddress ifaceAddress = InetAddressUtils.addr((String)iface);
        boolean filterPassed = false;
        List<InetAddress> ipList = this.getIpList();
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddress);
        } else {
            this.log().debug("interfaceInFilter: ipList contains no data");
        }
        if (!filterPassed) {
            this.log().debug("interfaceInFilter: Interface " + iface + " passed filter for package " + this.getName() + "?: false");
        }
        return filterPassed;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public List<IncludeURL> getIncludeURLs() {
        return this.m_includeURLs;
    }

    protected boolean hasSpecificUrl(String iface, boolean has_specific) {
        Iterator<IncludeURL> it = this.getIncludeURLs().iterator();
        while (it.hasNext() && !has_specific) {
            IncludeURL includeURL = it.next();
            has_specific = includeURL.interfaceInUrl(iface);
        }
        return has_specific;
    }

    public boolean interfaceInPackage(String iface) {
        boolean packagePassed;
        boolean filterPassed = this.interfaceInFilter(iface);
        if (!filterPassed) {
            return false;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        boolean has_range_include = this.hasIncludeRange(iface);
        boolean has_specific = this.hasSpecific(addr);
        has_specific = this.hasSpecificUrl(iface, has_specific);
        boolean has_range_exclude = this.hasExcludeRange(iface, has_specific);
        boolean bl = packagePassed = has_specific || has_range_include && !has_range_exclude;
        if (packagePassed) {
            this.log().info("interfaceInPackage: Interface " + iface + " passed filter and specific/range for package " + this.getName() + "?: " + packagePassed);
        } else {
            this.log().debug("interfaceInPackage: Interface " + iface + " passed filter and specific/range for package " + this.getName() + "?: " + packagePassed);
        }
        return packagePassed;
    }

    String getFilterRule(String localServer, boolean verifyServer) {
        Package pkg = this.getPackage();
        String filter = pkg.getFilter().getContent();
        StringBuffer filterRules = new StringBuffer(filter);
        if (verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        return filterRules.toString();
    }

    void createIpList(String localServer, boolean verifyServer) {
        Package pkg = this.getPackage();
        String filterRules = this.getFilterRule(localServer, verifyServer);
        if (this.log().isDebugEnabled()) {
            this.log().debug("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules);
        }
        try {
            this.putIpList(FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules));
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)this, (Throwable)t, (String)"createPackageIpMap: failed to map package: %s to an IP List with filter \"%s\"", (Object[])new Object[]{pkg.getName(), pkg.getFilter().getContent()});
        }
    }

    public Service getService(String svcName) {
        List pkgSvcs = this.m_pkg.getServiceCollection();
        for (Service svc : pkgSvcs) {
            if (!svc.getName().equalsIgnoreCase(svcName)) continue;
            return svc;
        }
        throw new RuntimeException("Service name not part of package!");
    }

    public String storeByIfAlias() {
        return this.getPackage().getStoreByIfAlias();
    }

    public String ifAliasComment() {
        return this.getPackage().getIfAliasComment();
    }

    public String getStorFlagOverride() {
        return this.getPackage().getStorFlagOverride();
    }

    public String ifAliasDomain() {
        return this.getPackage().getIfAliasDomain();
    }

    public String storeByNodeId() {
        return this.getPackage().getStoreByNodeID();
    }
}

