/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.DetectFutureNettyImpl;

public class DetectorHandlerNettyImpl<Request, Response>
extends SimpleChannelHandler {
    private AsyncClientConversation<Request, Response> m_conversation;

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        LogUtils.debugf((Object)((Object)this), (String)"channelOpen()", (Object[])new Object[0]);
        if (!this.getConversation().hasBanner() && this.getConversation().getRequest() != null) {
            Request request = this.getConversation().getRequest();
            ctx.getChannel().write(request);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        LogUtils.debugf((Object)((Object)this), (String)"channelClosed()", (Object[])new Object[0]);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LogUtils.debugf((Object)((Object)this), (Throwable)event.getCause(), (String)"Caught a Throwable in %s", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
        ctx.getChannel().close();
        ctx.sendUpstream((ChannelEvent)event);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent message) {
        try {
            AsyncClientConversation<Request, Object> conversation = this.getConversation();
            LogUtils.debugf((Object)((Object)this), (String)"Client Receiving: %s", (Object[])new Object[]{message.getMessage().toString().trim()});
            LogUtils.debugf((Object)((Object)this), (String)"Conversation: %s", (Object[])new Object[]{conversation});
            if (conversation.hasExchanges() && conversation.validate(message.getMessage())) {
                Request request = conversation.getRequest();
                if (request != null) {
                    LogUtils.debugf((Object)((Object)this), (String)"Writing request: %s", (Object[])new Object[]{request});
                    ctx.getChannel().write(request);
                } else if (request == null && conversation.isComplete()) {
                    LogUtils.debugf((Object)((Object)this), (String)"Closing channel: %s", (Object[])new Object[]{conversation});
                    ctx.getChannel().close();
                } else {
                    LogUtils.debugf((Object)((Object)this), (String)"Closing channel, detection failed: %s", (Object[])new Object[]{conversation});
                    ctx.getChannel().close();
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
                }
            } else {
                LogUtils.debugf((Object)((Object)this), (String)"Invalid response: %s", (Object[])new Object[]{message.getMessage().toString().trim()});
                ctx.getChannel().close();
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
            }
        }
        catch (Throwable e) {
            LogUtils.debugf((Object)((Object)this), (Throwable)e, (String)"Exception caught!", (Object[])new Object[0]);
            ctx.getChannel().close();
            Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
        }
    }

    public void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    public AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

