/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.DetectFutureMinaImpl;

public class BaseDetectorHandler<Request, Response>
extends IoHandlerAdapter {
    private DetectFutureMinaImpl m_future;
    private AsyncClientConversation<Request, Response> m_conversation;

    public void setFuture(DetectFutureMinaImpl future) {
        this.m_future = future;
    }

    public DetectFutureMinaImpl getFuture() {
        return this.m_future;
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
        if (!this.getConversation().hasBanner() && this.getConversation().getRequest() != null) {
            Request request = this.getConversation().getRequest();
            session.write(request);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (!this.getFuture().isDone()) {
            LogUtils.infof((Object)((Object)this), (String)"Session closed and detection is not complete. Setting service detection to false.", (Object[])new Object[0]);
            this.getFuture().setServiceDetected(false);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (this.getConversation().hasBanner() && status == IdleStatus.READER_IDLE) {
            LogUtils.infof((Object)((Object)this), (String)"Session went idle without receiving banner. Setting service detection to false.", (Object[])new Object[0]);
            this.getFuture().setServiceDetected(false);
            session.close(true);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LogUtils.debugf((Object)((Object)this), (Throwable)cause, (String)"Caught a Throwable in BaseDetectorHandler", (Object[])new Object[0]);
        this.getFuture().setException(cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        block8: {
            try {
                LogUtils.debugf((Object)((Object)this), (String)"Client Receiving: %s", (Object[])new Object[]{message.toString().trim()});
                if (this.getConversation().hasExchanges() && this.getConversation().validate(message)) {
                    Request request = this.getConversation().getRequest();
                    if (request != null) {
                        session.write(request);
                    } else if (request == null && this.getConversation().isComplete()) {
                        LogUtils.infof((Object)((Object)this), (String)"Conversation is complete and there are no more pending requests. Setting service detection to true.", (Object[])new Object[0]);
                        this.getFuture().setServiceDetected(true);
                        session.close(false);
                    } else {
                        LogUtils.infof((Object)((Object)this), (String)"Conversation is incomplete. Setting service detection to false.", (Object[])new Object[0]);
                        this.getFuture().setServiceDetected(false);
                        session.close(false);
                    }
                } else {
                    LogUtils.infof((Object)((Object)this), (String)"Conversation response was invalid. Setting service detection to false.", (Object[])new Object[0]);
                    this.getFuture().setServiceDetected(false);
                    session.close(false);
                }
            }
            catch (Throwable e) {
                if (session.isClosing()) break block8;
                session.close(true);
            }
        }
    }

    public void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    public AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

