/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.xmlrpc.DefaultXmlRpcTransport;
import org.opennms.core.utils.LogUtils;

public class TimeoutSecureXmlRpcTransport
extends DefaultXmlRpcTransport {
    protected int m_timeout = 0;

    public TimeoutSecureXmlRpcTransport(URL url, String auth, int timeout) {
        super(url, auth);
        this.m_timeout = timeout;
    }

    public TimeoutSecureXmlRpcTransport(URL url, int timeout) {
        super(url, null);
        this.m_timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream sendXmlRpc(byte[] request) throws IOException {
        this.con = this.url.openConnection();
        LogUtils.debugf((Object)((Object)this), (String)"Setting read timeout to %d", (Object[])new Object[]{this.m_timeout});
        this.con.setReadTimeout(this.m_timeout);
        this.con.setDoInput(true);
        this.con.setDoOutput(true);
        this.con.setUseCaches(false);
        this.con.setAllowUserInteraction(false);
        this.con.setRequestProperty("Content-Length", Integer.toString(request.length));
        this.con.setRequestProperty("Content-Type", "text/xml");
        if (this.auth != null) {
            this.con.setRequestProperty("Authorization", "Basic " + this.auth);
        }
        OutputStream out = null;
        try {
            out = this.con.getOutputStream();
            out.write(request);
            out.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            out = null;
        }
        return this.con.getInputStream();
    }
}

