/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.xmlrpcd.SubscribedEvent;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private final FifoQueue<Event> m_eventQ;
    private final int m_maxQSize;
    private final HashSet<String> m_events;
    private final String m_nameSuffix;

    BroadcastEventProcessor(String nameSuffix, FifoQueue<Event> eventQ, int maxQSize, List<SubscribedEvent> eventList) {
        this.m_nameSuffix = nameSuffix;
        ArrayList<String> ueiList = new ArrayList<String>();
        for (SubscribedEvent event : eventList) {
            ueiList.add(event.getUei());
        }
        this.m_eventQ = eventQ;
        this.m_maxQSize = maxQSize;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
        this.m_events = new HashSet();
        this.m_events.addAll(ueiList);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        LogUtils.debugf((Object)this, (String)"Received event: %s", (Object[])new Object[]{eventUei});
        try {
            if (this.m_events.contains(eventUei)) {
                if (this.m_eventQ.size() >= this.m_maxQSize) {
                    this.m_eventQ.remove(1000L);
                    LogUtils.debugf((Object)this, (String)"Event %s removed from event queue", (Object[])new Object[]{eventUei});
                }
                this.m_eventQ.add((Object)event);
                LogUtils.debugf((Object)this, (String)"Event %s added to event queue", (Object[])new Object[]{eventUei});
            }
        }
        catch (InterruptedException ex) {
            LogUtils.errorf((Object)this, (Throwable)ex, (String)"Failed to process event", (Object[])new Object[0]);
            return;
        }
        catch (FifoQueueException ex) {
            LogUtils.errorf((Object)this, (Throwable)ex, (String)"Failed to process event", (Object[])new Object[0]);
            return;
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)this, (Throwable)t, (String)"Failed to process event", (Object[])new Object[0]);
            return;
        }
    }

    public String getName() {
        return "Xmlrpcd:BroadcastEventProcessor_" + this.m_nameSuffix;
    }
}

