/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;

public class NodeLabel {
    private static final String SQL_DB_UPDATE_NODE_LABEL = "UPDATE node SET nodelabel=?,nodelabelsource=? WHERE nodeid=?";
    private static final String SQL_DB_RETRIEVE_NETBIOS_NAME = "SELECT nodenetbiosname FROM node WHERE nodeid=?";
    private static final String SQL_DB_RETRIEVE_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged='M'";
    private static final String SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged!='M'";
    private static final String SQL_DB_RETRIEVE_SYSNAME = "SELECT nodesysname FROM node WHERE nodeid=?";
    private static final String SQL_DB_RETRIEVE_NODELABEL = "SELECT nodelabel,nodelabelsource FROM node WHERE nodeid=?";
    public static final char SOURCE_USERDEFINED = 'U';
    public static final char SOURCE_NETBIOS = 'N';
    public static final char SOURCE_HOSTNAME = 'H';
    public static final char SOURCE_SYSNAME = 'S';
    public static final char SOURCE_ADDRESS = 'A';
    public static final char SOURCE_UNKNOWN = 'X';
    public static final int MAX_NODE_LABEL_LENGTH = 256;
    private static final String SELECT_METHOD_MIN = "min";
    private static final String SELECT_METHOD_MAX = "max";
    private static final String DEFAULT_SELECT_METHOD = "min";
    private final String m_nodeLabel;
    private final char m_nodeLabelSource;
    public static final String PROP_PRIMARY_INTERFACE_SELECT_METHOD = "org.opennms.bluebird.dp.primaryInterfaceSelectMethod";

    public NodeLabel() {
        this.m_nodeLabel = null;
        this.m_nodeLabelSource = (char)88;
    }

    public NodeLabel(String nodeLabel, String nodeLabelSource) {
        this(nodeLabel, nodeLabelSource.charAt(0));
    }

    public NodeLabel(String nodeLabel, char nodeLabelSource) {
        switch (nodeLabelSource) {
            case 'A': 
            case 'H': 
            case 'N': 
            case 'S': 
            case 'U': 
            case 'X': {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for node label source: " + nodeLabelSource);
            }
        }
        this.m_nodeLabel = nodeLabel;
        this.m_nodeLabelSource = nodeLabelSource;
    }

    public String getLabel() {
        return this.m_nodeLabel;
    }

    public char getSource() {
        return this.m_nodeLabelSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel retrieveLabel(int nodeID) throws SQLException {
        NodeLabel label = null;
        Connection dbConnection = Vault.getDbConnection();
        try {
            label = NodeLabel.retrieveLabel(nodeID, dbConnection);
        }
        finally {
            Vault.releaseDbConnection((Connection)dbConnection);
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel retrieveLabel(int nodeID, Connection dbConnection) throws SQLException {
        String nodeLabel = null;
        String nodeLabelSource = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(NodeLabel.class);
        if (NodeLabel.log().isDebugEnabled()) {
            NodeLabel.log().debug("NodeLabel.retrieveLabel: sql: SELECT nodelabel,nodelabelsource FROM node WHERE nodeid=? node id: " + nodeID);
        }
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NODELABEL);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeLabel = rs.getString(1);
                nodeLabelSource = rs.getString(2);
            }
        }
        finally {
            d.cleanUp();
        }
        if (nodeLabelSource != null) {
            char[] temp = nodeLabelSource.toCharArray();
            return new NodeLabel(nodeLabel, temp[0]);
        }
        return new NodeLabel(nodeLabel, 'X');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignLabel(int nodeID, NodeLabel nodeLabel) throws SQLException {
        Connection dbConnection = Vault.getDbConnection();
        try {
            NodeLabel.assignLabel(nodeID, nodeLabel, dbConnection);
        }
        finally {
            Vault.releaseDbConnection((Connection)dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignLabel(int nodeID, NodeLabel nodeLabel, Connection dbConnection) throws SQLException {
        if (nodeLabel == null) {
            nodeLabel = NodeLabel.computeLabel(nodeID, dbConnection);
        }
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(NodeLabel.class);
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_UPDATE_NODE_LABEL);
            d.watch((Object)stmt);
            int column = 1;
            if (NodeLabel.log().isDebugEnabled()) {
                NodeLabel.log().debug("NodeLabel.assignLabel: Node label: " + nodeLabel.getLabel() + " source: " + nodeLabel.getSource());
            }
            if (nodeLabel.getLabel() != null) {
                String label = nodeLabel.getLabel();
                if (label.length() > 256) {
                    label = label.substring(0, 256);
                }
                stmt.setString(column++, label);
            } else {
                stmt.setNull(column++, 12);
            }
            stmt.setString(column++, String.valueOf(nodeLabel.getSource()));
            stmt.setInt(column++, nodeID);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel computeLabel(int nodeID) throws SQLException {
        Connection dbConnection = Vault.getDbConnection();
        try {
            NodeLabel nodeLabel = NodeLabel.computeLabel(nodeID, dbConnection);
            return nodeLabel;
        }
        finally {
            Vault.releaseDbConnection((Connection)dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel computeLabel(int nodeID, Connection dbConnection) throws SQLException {
        String netbiosName = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(NodeLabel.class);
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NETBIOS_NAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                netbiosName = rs.getString(1);
            }
            if (netbiosName != null) {
                NodeLabel nodeLabel;
                if (netbiosName.length() > 256) {
                    netbiosName = netbiosName.substring(0, 256);
                }
                if (NodeLabel.log().isDebugEnabled()) {
                    NodeLabel.log().debug("NodeLabel.computeLabel: returning NetBIOS name as nodeLabel: " + netbiosName);
                }
                NodeLabel nodeLabel2 = nodeLabel = new NodeLabel(netbiosName, 'N');
                return nodeLabel2;
            }
        }
        finally {
            d.cleanUp();
        }
        String method = System.getProperty(PROP_PRIMARY_INTERFACE_SELECT_METHOD);
        if (method == null) {
            method = "min";
        }
        if (!method.equals("min") && !method.equals(SELECT_METHOD_MAX)) {
            NodeLabel.log().warn("Interface selection method is '" + method + "'.  Valid values are 'min' & 'max'.  Will use default value: " + "min");
            method = "min";
        }
        ArrayList<InetAddress> ipv4AddrList = new ArrayList<InetAddress>();
        ArrayList<String> ipHostNameList = new ArrayList<String>();
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_MANAGED_INTERFACES);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            NodeLabel.loadAddressList(rs, ipv4AddrList, ipHostNameList);
        }
        catch (Throwable e) {
            NodeLabel.log().warn("Exception thrown while fetching managed interfaces: " + e.getMessage(), e);
        }
        finally {
            d.cleanUp();
        }
        InetAddress primaryAddr = NodeLabel.selectPrimaryAddress(ipv4AddrList, method);
        if (primaryAddr == null) {
            if (NodeLabel.log().isDebugEnabled()) {
                NodeLabel.log().debug("NodeLabel.computeLabel: unable to find a primary address for node " + nodeID + ", returning null");
            }
            ipv4AddrList.clear();
            ipHostNameList.clear();
            try {
                stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES);
                d.watch((Object)stmt);
                stmt.setInt(1, nodeID);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                NodeLabel.loadAddressList(rs, ipv4AddrList, ipHostNameList);
            }
            catch (Throwable e) {
                NodeLabel.log().warn("Exception thrown while fetching managed interfaces: " + e.getMessage(), e);
            }
            finally {
                d.cleanUp();
            }
            primaryAddr = NodeLabel.selectPrimaryAddress(ipv4AddrList, method);
        }
        if (primaryAddr == null) {
            NodeLabel.log().warn("Could not find primary interface for node " + nodeID + ", cannot compute nodelabel");
            return new NodeLabel("Unknown", 'X');
        }
        int index = ipv4AddrList.indexOf(primaryAddr);
        String primaryHostName = (String)ipHostNameList.get(index);
        if (primaryHostName.length() != 0) {
            if (primaryHostName.length() > 256) {
                primaryHostName = primaryHostName.substring(0, 256);
            }
            return new NodeLabel(primaryHostName, 'H');
        }
        String primarySysName = null;
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_SYSNAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                primarySysName = rs.getString(1);
            }
        }
        finally {
            d.cleanUp();
        }
        if (primarySysName != null && primarySysName.length() > 0) {
            if (primarySysName.length() > 256) {
                primarySysName = primarySysName.substring(0, 256);
            }
            NodeLabel nodeLabel = new NodeLabel(primarySysName, 'S');
            return nodeLabel;
        }
        NodeLabel nodeLabel = new NodeLabel(primaryAddr.toString(), 'A');
        return nodeLabel;
    }

    private static void loadAddressList(ResultSet rs, List<InetAddress> ipv4AddrList, List<String> ipHostNameList) throws SQLException {
        ThreadCategory log = NodeLabel.log();
        while (rs.next()) {
            InetAddress inetAddr = InetAddressUtils.getInetAddress((String)rs.getString(1));
            ipv4AddrList.add(inetAddr);
            String hostName = rs.getString(2);
            if (hostName == null || hostName.equals(inetAddr.toString())) {
                ipHostNameList.add("");
            } else {
                ipHostNameList.add(hostName);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("NodeLabel.computeLabel: adding address " + inetAddr.toString() + " with hostname: " + hostName);
        }
    }

    private static InetAddress selectPrimaryAddress(List<InetAddress> ipv4AddrList, String method) {
        InetAddress primaryAddr = null;
        Iterator<InetAddress> iter = ipv4AddrList.iterator();
        while (iter.hasNext()) {
            if (primaryAddr == null) {
                primaryAddr = iter.next();
                continue;
            }
            InetAddress currentAddr = iter.next();
            byte[] current = currentAddr.getAddress();
            byte[] primary = primaryAddr.getAddress();
            if (method.equals("min")) {
                if (new ByteArrayComparator().compare(current, primary) >= 0) continue;
                primaryAddr = currentAddr;
                continue;
            }
            if (new ByteArrayComparator().compare(current, primary) <= 0) continue;
            primaryAddr = currentAddr;
        }
        return primaryAddr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_nodeLabel);
        buffer.append(":");
        buffer.append(this.m_nodeLabelSource);
        return buffer.toString();
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(NodeLabel.class);
    }
}

