/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.poller.InetNetworkInterface;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.Threshd;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholderUpdates;

final class ThresholdableService
extends InetNetworkInterface
implements ThresholdNetworkInterface,
ReadyRunnable {
    private static final long serialVersionUID = 2477161545461824755L;
    private int m_nodeId;
    private Package m_package;
    private final Service m_service;
    private int m_status;
    private long m_lastThresholdCheckTime;
    private long m_lastScheduledThresholdCheckTime;
    private final EventProxy m_proxy;
    private final LegacyScheduler m_scheduler;
    private ThresholderUpdates m_updates;
    private static final boolean ABORT_THRESHOLD_CHECK = true;
    private ServiceThresholder m_thresholder;
    private final String m_svcPropKey;
    private static Map<String, Map<?, ?>> SVC_PROP_MAP = new ConcurrentSkipListMap();
    private Threshd m_threshd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThresholdableService(Threshd threshd, int dbNodeId, InetAddress address, String svcName, Package pkg) {
        super(address);
        this.m_nodeId = dbNodeId;
        this.m_package = pkg;
        this.m_status = 1;
        this.m_threshd = threshd;
        this.m_proxy = EventIpcManagerFactory.getIpcManager();
        this.m_scheduler = threshd.getScheduler();
        this.m_thresholder = Threshd.getServiceThresholder(svcName);
        this.m_updates = new ThresholderUpdates();
        this.m_lastScheduledThresholdCheckTime = System.currentTimeMillis();
        this.m_lastThresholdCheckTime = System.currentTimeMillis();
        Service svc = null;
        for (Service s : this.m_package.getServiceCollection()) {
            if (!s.getName().equalsIgnoreCase(svcName)) continue;
            svc = s;
            break;
        }
        if (svc == null) {
            throw new RuntimeException("Service name not part of package!");
        }
        this.m_service = svc;
        this.m_svcPropKey = this.m_package.getName() + "." + this.m_service.getName();
        Map<String, Map<?, ?>> map = SVC_PROP_MAP;
        synchronized (map) {
            if (!SVC_PROP_MAP.containsKey(this.m_svcPropKey)) {
                ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
                for (Parameter p : this.m_service.getParameterCollection()) {
                    m.put(p.getKey(), p.getValue());
                }
                m.put("interval", Integer.toString((int)this.m_service.getInterval()));
                SVC_PROP_MAP.put(this.m_svcPropKey, m);
            }
        }
    }

    @Override
    public int getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(int nodeId) {
        this.m_nodeId = nodeId;
    }

    public String getServiceName() {
        return this.m_service.getName();
    }

    public String getPackageName() {
        return this.m_package.getName();
    }

    public void refreshPackage() {
        Package refreshedPackage = this.m_threshd.getPackage(this.getPackageName());
        if (refreshedPackage != null) {
            this.m_package = refreshedPackage;
        }
    }

    public ThresholderUpdates getThresholderUpdates() {
        return this.m_updates;
    }

    @Override
    public boolean isReady() {
        boolean ready = false;
        if (!this.m_threshd.isSchedulingCompleted()) {
            return false;
        }
        ready = this.m_service.getInterval() < 1L ? true : this.m_service.getInterval() - (System.currentTimeMillis() - this.m_lastScheduledThresholdCheckTime) < 1L;
        return ready;
    }

    public long getInterval() {
        return this.m_service.getInterval();
    }

    private void sendEvent(String uei) {
        EventBuilder bldr = new EventBuilder(uei, "OpenNMS.Threshd");
        bldr.setNodeid((long)this.m_nodeId);
        bldr.setInterface(this.m_address);
        bldr.setService("SNMP");
        bldr.setHost(InetAddressUtils.getLocalHostName());
        try {
            this.m_proxy.send(bldr.getEvent());
        }
        catch (Exception ex) {
            LogUtils.errorf((Object)this, (Throwable)ex, (String)"Failed to send the event %s for interface %s", (Object[])new Object[]{uei, this.getHostAddress()});
        }
        LogUtils.debugf((Object)this, (String)"sendEvent: Sent event %s for %s/%s/%s", (Object[])new Object[]{uei, this.m_nodeId, this.getHostAddress(), this.m_service.getName()});
    }

    private String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.m_address);
    }

    @Override
    public void run() {
        if (this.processUpdates()) {
            return;
        }
        this.m_lastScheduledThresholdCheckTime = System.currentTimeMillis();
        if (this.scheduledOutage()) {
            this.m_scheduler.schedule(this, this.m_service.getInterval());
            return;
        }
        LogUtils.debugf((Object)this, (String)"run: starting new threshold check for %s", (Object[])new Object[]{this.getHostAddress()});
        int status = 2;
        Map<?, ?> propertiesMap = SVC_PROP_MAP.get(this.m_svcPropKey);
        try {
            status = this.m_thresholder.check(this, this.m_proxy, propertiesMap);
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)this, (Throwable)t, (String)"run: An undeclared throwable was caught during SNMP thresholding for interface %s", (Object[])new Object[]{this.getHostAddress()});
        }
        this.m_lastThresholdCheckTime = System.currentTimeMillis();
        if (status != this.m_status) {
            LogUtils.debugf((Object)this, (String)"run: change in thresholding status, generating event.", (Object[])new Object[0]);
            switch (status) {
                case 1: {
                    this.sendEvent("uei.opennms.org/nodes/thresholdingSucceeded");
                    break;
                }
                case 2: {
                    this.sendEvent("uei.opennms.org/nodes/thresholdingFailed");
                    break;
                }
            }
        }
        this.m_status = status;
        this.m_scheduler.schedule(this, this.getInterval());
    }

    Map<?, ?> getPropertyMap() {
        return Collections.unmodifiableMap(SVC_PROP_MAP.get(this.m_svcPropKey));
    }

    private boolean scheduledOutage() {
        boolean outageFound = false;
        PollOutagesConfigFactory outageFactory = PollOutagesConfigFactory.getInstance();
        for (String outageName : this.m_package.getOutageCalendarCollection()) {
            if (!outageFactory.isCurTimeInOutage(outageName) || !outageFactory.isNodeIdInOutage((long)this.m_nodeId, outageName) && !outageFactory.isInterfaceInOutage(this.getHostAddress(), outageName)) continue;
            LogUtils.debugf((Object)this, (String)"scheduledOutage: configured outage '%s' applies, interface %s will not be thresholded for %s", (Object[])new Object[]{outageName, this.getHostAddress(), this.m_service});
            outageFound = true;
            break;
        }
        return outageFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUpdates() {
        ThresholdableService thresholdableService = this;
        synchronized (thresholdableService) {
            if (!this.m_updates.hasUpdates()) {
                return false;
            }
            if (this.m_updates.isDeletionFlagSet()) {
                LogUtils.debugf((Object)this, (String)"Collector for  %s is marked for deletion...skipping thresholding, will not reschedule.", (Object[])new Object[]{this.getHostAddress()});
                return true;
            }
            if (this.m_updates.isReinitializationFlagSet()) {
                LogUtils.debugf((Object)this, (String)"ReinitializationFlag set for %s", (Object[])new Object[]{this.getHostAddress()});
                try {
                    this.m_thresholder.release(this);
                    this.m_thresholder.initialize(this, this.getPropertyMap());
                    LogUtils.debugf((Object)this, (String)"Completed reinitializing SNMP collector for %s", (Object[])new Object[]{this.getHostAddress()});
                }
                catch (RuntimeException e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to reschedule %s for %s thresholding.", (Object[])new Object[]{this.getHostAddress(), this.m_service.getName()});
                }
                catch (Throwable t) {
                    LogUtils.errorf((Object)this, (Throwable)t, (String)"Uncaught exception, failed to reschedule interface %s for %s thresholding.", (Object[])new Object[]{this.getHostAddress(), this.m_service.getName()});
                }
            }
            if (this.m_updates.isReparentingFlagSet()) {
                LogUtils.debugf((Object)this, (String)"ReparentingFlag set for %s", (Object[])new Object[]{this.getHostAddress()});
                int newNodeId = -1;
                try {
                    newNodeId = Integer.parseInt(this.m_updates.getReparentNewNodeId());
                }
                catch (NumberFormatException nfE) {
                    LogUtils.warnf((Object)this, (Throwable)nfE, (String)"Unable to convert new nodeId value to an int while processing reparenting update: %s", (Object[])new Object[]{this.m_updates.getReparentNewNodeId()});
                }
                this.m_nodeId = newNodeId;
                try {
                    LogUtils.debugf((Object)this, (String)"Reinitializing SNMP thresholder for %s", (Object[])new Object[]{this.getHostAddress()});
                    this.m_thresholder.release(this);
                    this.m_thresholder.initialize(this, this.getPropertyMap());
                    LogUtils.debugf((Object)this, (String)"Completed reinitializing SNMP thresholder for %s", (Object[])new Object[]{this.getHostAddress()});
                }
                catch (RuntimeException rE) {
                    LogUtils.warnf((Object)this, (Throwable)rE, (String)"Unable to initialize %s for %s thresholding.", (Object[])new Object[]{this.getHostAddress(), this.m_service.getName()});
                }
                catch (Throwable t) {
                    LogUtils.errorf((Object)this, (Throwable)t, (String)"Uncaught exception, failed to initialize interface %s for %s thresholding.", (Object[])new Object[]{this.getHostAddress(), this.m_service.getName()});
                }
            }
            this.m_updates.reset();
        }
        return false;
    }
}

