/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.List;
import java.util.concurrent.Callable;
import org.opennms.core.concurrent.EndOfTheWaterfall;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.xml.event.Parm;

final class SyslogProcessor
implements EndOfTheWaterfall {
    private final boolean m_NewSuspectOnMessage;
    private final String m_localAddr;
    private final ConvertToEvent m_event;

    public SyslogProcessor(ConvertToEvent event) {
        this.m_event = event;
        this.m_NewSuspectOnMessage = SyslogdConfigFactory.getInstance().getNewSuspectOnMessage();
        this.m_localAddr = InetAddressUtils.getLocalHostName();
    }

    public Callable<Void> call() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isEnabledFor(ThreadCategory.Level.TRACE);
        try {
            if (isTracing) {
                List parms;
                log.trace("Processing a syslog to event dispatch" + this.m_event.toString());
                String uuid = this.m_event.getEvent().getUuid();
                log.trace("Event {");
                log.trace("  uuid  = " + (uuid != null && uuid.length() > 0 ? uuid : "<not-set>"));
                log.trace("  uei   = " + this.m_event.getEvent().getUei());
                log.trace("  src   = " + this.m_event.getEvent().getSource());
                log.trace("  iface = " + this.m_event.getEvent().getInterface());
                log.trace("  time  = " + this.m_event.getEvent().getTime());
                log.trace("  Msg   = " + this.m_event.getEvent().getLogmsg().getContent());
                log.trace("  Dst   = " + this.m_event.getEvent().getLogmsg().getDest());
                List list = parms = this.m_event.getEvent().getParmCollection() == null ? null : this.m_event.getEvent().getParmCollection();
                if (parms != null) {
                    log.trace("  parms {");
                    for (Parm parm : parms) {
                        if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                        log.trace("    (" + parm.getParmName().trim() + ", " + parm.getValue().getContent().trim() + ")");
                    }
                    log.trace("  }");
                }
                log.trace("}");
            }
            EventIpcManagerFactory.getIpcManager().sendNow(this.m_event.getEvent());
            if (this.m_NewSuspectOnMessage && !this.m_event.getEvent().hasNodeid()) {
                if (isTracing) {
                    log.trace("Syslogd: Found a new suspect " + this.m_event.getEvent().getInterface());
                }
                SyslogProcessor.sendNewSuspectEvent(this.m_localAddr, this.m_event.getEvent().getInterface());
            }
        }
        catch (Throwable t) {
            log.error("Unexpected error processing SyslogMessage - Could not send", t);
        }
        return null;
    }

    private static void sendNewSuspectEvent(String localAddr, String trapInterface) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "syslogd");
        bldr.setInterface(InetAddressUtils.addr((String)trapInterface));
        bldr.setHost(localAddr);
        EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
    }
}

