/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParserException;

public class SyslogParser {
    private static Pattern m_pattern = Pattern.compile("^.*$");
    private Matcher m_matcher = null;
    private final String m_text;
    private Boolean m_found = null;
    private Boolean m_matched = null;
    private boolean m_traceEnabled = false;

    protected SyslogParser(String text) {
        this.m_text = text;
        this.m_traceEnabled = LogUtils.isTraceEnabled((Object)this);
    }

    public boolean find() {
        if (this.m_found == null) {
            this.getMatcher().reset();
            this.m_found = this.getMatcher().find();
        }
        return this.m_found;
    }

    public boolean matches() {
        if (this.m_matched == null) {
            this.getMatcher().reset();
            this.m_matched = this.getMatcher().matches();
        }
        return this.m_matched;
    }

    protected Boolean matched() {
        return this.m_matched;
    }

    protected String getText() {
        return this.m_text;
    }

    protected boolean traceEnabled() {
        return this.m_traceEnabled;
    }

    public static SyslogParser getParser(String text) throws SyslogParserException {
        throw new UnsupportedOperationException("You must implement getParser() in your subclass!");
    }

    protected Pattern getPattern() {
        return m_pattern;
    }

    public SyslogMessage parse() throws SyslogParserException {
        SyslogMessage message = new SyslogMessage();
        message.setMessage(this.getMatcher().group().trim());
        return message;
    }

    protected Matcher getMatcher() {
        if (this.m_matcher == null) {
            this.m_matcher = this.getPattern().matcher(this.m_text);
        }
        return this.m_matcher;
    }

    protected Date parseDate(String dateString) {
        Date date;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            date = df.parse(dateString);
        }
        catch (Exception e) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("MMM d HH:mm:ss", Locale.ROOT);
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                date = df.parse(dateString);
                Calendar c = df.getCalendar();
                c.setTime(date);
                c.set(1, Calendar.getInstance().get(1));
                date = c.getTime();
            }
            catch (Exception e2) {
                LogUtils.debugf((Object)this, (Throwable)e2, (String)"Unable to parse date '%s'", (Object[])new Object[]{dateString});
                date = null;
            }
        }
        return date;
    }
}

