/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.syslogd.CustomSyslogParser;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogSeverity;

public class JuniperSyslogParser
extends SyslogParser {
    private static final Pattern m_juniperPattern = Pattern.compile("^<(\\d+)>\\s*(\\S\\S\\S\\s+\\d{1,2}\\s+\\d\\d:\\d\\d:\\d\\d)\\s+(\\S+)\\s+(\\S+)\\[(\\d+)\\]: (.*?)$", 8);

    protected JuniperSyslogParser(String text) {
        super(text);
    }

    public static SyslogParser getParser(String text) {
        return new JuniperSyslogParser(text);
    }

    @Override
    protected Pattern getPattern() {
        return m_juniperPattern;
    }

    @Override
    public SyslogMessage parse() throws SyslogParserException {
        if (!this.find()) {
            if (this.traceEnabled()) {
                LogUtils.tracef((Object)this, (String)"'%s' did not match '%s', falling back to the custom parser", (Object[])new Object[]{m_juniperPattern, this.getText()});
                SyslogParser custom = CustomSyslogParser.getParser(this.getText());
                return custom.parse();
            }
            return null;
        }
        Matcher matcher = this.getMatcher();
        SyslogMessage message = new SyslogMessage();
        try {
            int priorityField = Integer.parseInt(matcher.group(1));
            message.setFacility(SyslogFacility.getFacilityForCode(priorityField));
            message.setSeverity(SyslogSeverity.getSeverityForCode(priorityField));
        }
        catch (NumberFormatException nfe) {
            LogUtils.debugf((Object)this, (Throwable)nfe, (String)"Unable to parse '%s' as a PRI code.", (Object[])new Object[]{matcher.group(1)});
        }
        Date date = this.parseDate(matcher.group(2));
        if (date == null) {
            date = new Date();
        }
        message.setDate(date);
        message.setHostName(matcher.group(3));
        message.setProcessName(matcher.group(4));
        try {
            Integer pid = Integer.parseInt(matcher.group(5));
            message.setProcessId(pid);
        }
        catch (NumberFormatException nfe) {
            LogUtils.debugf((Object)this, (Throwable)nfe, (String)"Unable to parse '%s' as a process ID.", (Object[])new Object[]{matcher.group(5)});
        }
        message.setMessage(matcher.group(6).trim());
        return message;
    }
}

