/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.rtc.DataUpdater;
import org.opennms.netmgt.rtc.RTCManager;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private final ExecutorService m_updater;

    BroadcastEventProcessor(ExecutorService updaterQ) {
        this.m_updater = updaterQ;
    }

    public void start() {
        ArrayList<String> ueisOfInterest = new ArrayList<String>();
        ueisOfInterest.add("uei.opennms.org/nodes/nodeGainedService");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeLostService");
        ueisOfInterest.add("uei.opennms.org/nodes/interfaceDown");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeDown");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeUp");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeCategoryMembershipChanged");
        ueisOfInterest.add("uei.opennms.org/nodes/interfaceUp");
        ueisOfInterest.add("uei.opennms.org/nodes/nodeRegainedService");
        ueisOfInterest.add("uei.opennms.org/nodes/serviceDeleted");
        ueisOfInterest.add("uei.opennms.org/nodes/serviceUnmanaged");
        ueisOfInterest.add("uei.opennms.org/nodes/interfaceReparented");
        ueisOfInterest.add("uei.opennms.org/internal/rtc/subscribe");
        ueisOfInterest.add("uei.opennms.org/internal/rtc/unsubscribe");
        ueisOfInterest.add("uei.opennms.org/nodes/assetInfoChanged");
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueisOfInterest);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("About to start processing recd. event");
        }
        try {
            RTCManager.getInstance().checkTimerTasksOnEventReceipt();
            String uei = event.getUei();
            if (uei == null) {
                return;
            }
            this.m_updater.execute(new DataUpdater(event));
            if (log.isDebugEnabled()) {
                log.debug("Event " + uei + " added to updater queue");
            }
            RTCManager.getInstance().resetUserTimer();
        }
        catch (RejectedExecutionException ex) {
            log.error("Failed to process event", (Throwable)ex);
            return;
        }
        catch (Throwable t) {
            log.error("Failed to process event", t);
            return;
        }
    }

    public String getName() {
        return "RTCManager:BroadcastEventProcessor";
    }
}

