/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import jcifs.netbios.NbtAddress;
import org.apache.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;

@Distributable(value={DistributionContext.DAEMON})
public final class SmbMonitor
extends AbstractServiceMonitor {
    private static final String DO_NODE_STATUS = "do-node-status";
    private static final boolean DO_NODE_STATUS_DEFAULT = true;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        NbtAddress nbtAddr = null;
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        boolean doNodeStatus = ParameterMap.getKeyedBoolean(parameters, (String)DO_NODE_STATUS, (boolean)true);
        try {
            nbtAddr = NbtAddress.getByName((String)hostAddress);
            if (doNodeStatus) {
                nbtAddr.getNodeType();
            }
            if (!nbtAddr.getHostName().equals(hostAddress)) {
                serviceStatus = PollStatus.available();
            }
        }
        catch (UnknownHostException uhE) {
            serviceStatus = this.logDown(Level.DEBUG, "Unknown host exception generated for " + hostAddress + ", reason: " + uhE.getLocalizedMessage());
        }
        catch (RuntimeException rE) {
            serviceStatus = this.logDown(Level.ERROR, "Unexpected runtime exception", rE);
        }
        catch (Throwable e) {
            serviceStatus = this.logDown(Level.DEBUG, "Unexpected exception", e);
        }
        return serviceStatus;
    }
}

