/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;

@Distributable
public final class Pop3Monitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_PORT = 110;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)110);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: address = " + ipv4Addr + ", port = " + port + ", " + tracker);
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            Socket socket = null;
            String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                this.log().debug("Pop3Monitor: connected to host: " + ipv4Addr + " on port: " + port);
                serviceStatus = PollStatus.unresponsive();
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = rdr.readLine();
                double responseTime = tracker.elapsedTimeInMillis();
                if (banner != null) {
                    StringTokenizer t = new StringTokenizer(banner);
                    if (t.nextToken().equals("+OK")) {
                        String cmd = "QUIT\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        t = new StringTokenizer(rdr.readLine());
                        if (t.nextToken().equals("+OK")) {
                            serviceStatus = PollStatus.available((Double)responseTime);
                        }
                    }
                    if (!serviceStatus.isAvailable()) {
                        serviceStatus = PollStatus.unavailable();
                    }
                }
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + hostAddress, e);
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address " + hostAddress, e);
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address " + hostAddress, e);
            }
            finally {
                block35: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!this.log().isDebugEnabled()) break block35;
                        this.log().debug("poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

