/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

@Distributable(value={DistributionContext.DAEMON})
public final class CiscoIpSlaMonitor
extends SnmpMonitorStrategy {
    private static final String SERVICE_NAME = "Cisco_IP_SLA";
    private static final String RTT_ADMIN_TAG_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.3";
    private static final String RTT_OPER_STATE_OID = ".1.3.6.1.4.1.9.9.42.1.2.9.1.10";
    private static final String RTT_LATEST_OPERSENSE_OID = ".1.3.6.1.4.1.9.9.42.1.2.10.1.2";
    private static final String RTT_ADMIN_THRESH_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.5";
    private static final String RTT_ADMIN_TYPE_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.4";
    private static final String RTT_LATEST_OID = ".1.3.6.1.4.1.9.9.42.1.2.10.1.1";

    public String serviceName() {
        return SERVICE_NAME;
    }

    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String returnValue = "SNMP request failed or Cisco IP SLA tag ";
        boolean monitorThresh = false;
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        this.log().debug("poll: setting SNMP peer attribute for interface " + hostAddress);
        String adminTag = ParameterMap.getKeyedString(parameters, (String)"admin-tag", null);
        if (adminTag == null) {
            status = this.logDown(Level.ERROR, "No IP SLA admin-tag parameter defined! ");
            return status;
        }
        returnValue = returnValue + adminTag + " not found";
        String ignoreThreshold = ParameterMap.getKeyedString(parameters, (String)"ignore-thresh", null);
        if (ignoreThreshold == null) {
            status = this.logDown(Level.ERROR, "No ignoreThreshold parmater defined! ");
            return status;
        }
        if (ignoreThreshold.equals("false")) {
            monitorThresh = true;
        }
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        try {
            Map tagResults;
            if (this.log().isDebugEnabled()) {
                this.log().debug("poll: SnmpAgentConfig address: " + agentConfig);
            }
            if ((tagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_TAG_OID))) == null) {
                status = this.logDown(Level.ERROR, "No admin tags received! ");
                return status;
            }
            for (SnmpInstId ipslaInstance : tagResults.keySet()) {
                if (!((SnmpValue)tagResults.get(ipslaInstance)).toString().equals(adminTag)) continue;
                Map operSenseResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_LATEST_OPERSENSE_OID));
                if (operSenseResults == null) {
                    status = this.logDown(Level.ERROR, "No latest oper sense received! ");
                    return status;
                }
                Map operStateResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_OPER_STATE_OID));
                if (operStateResults == null) {
                    status = this.logDown(Level.ERROR, "No oper state received! ");
                    return status;
                }
                Map adminTypeResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_TYPE_OID));
                if (adminTypeResults == null) {
                    status = this.logDown(Level.ERROR, "No ip sla types received! ");
                    return status;
                }
                Map latestRttResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_LATEST_OID));
                if (latestRttResults == null) {
                    status = this.logDown(Level.ERROR, "No ip sla latest RTT received! ");
                    return status;
                }
                this.log().debug("poll: instance=" + ipslaInstance.toInt() + "admin tag=" + adminTag + " value=" + tagResults.get(ipslaInstance) + " oper state=" + operStateResults.get(ipslaInstance) + " ignoreThreshold=" + ignoreThreshold + " latest RTT" + latestRttResults.get(ipslaInstance));
                returnValue = "Cisco IP SLA tag " + adminTag + " with oper state " + this.resolveOperSate(((SnmpValue)operStateResults.get(ipslaInstance)).toInt()) + " returned with oper sense " + this.resolveOperSense(((SnmpValue)operSenseResults.get(ipslaInstance)).toInt()) + ". Configured IP SLA type is " + this.resolveAdminType(((SnmpValue)adminTypeResults.get(ipslaInstance)).toInt()) + ". Latest RTT is " + latestRttResults.get(ipslaInstance);
                this.log().debug(returnValue);
                if (monitorThresh && ((SnmpValue)operSenseResults.get(ipslaInstance)).toInt() == RTT_MON_OPER_SENSE.OVER_THRESHOLD.value()) {
                    Map threshResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_THRESH_OID));
                    if (monitorThresh && threshResults == null) {
                        status = this.logDown(Level.ERROR, "No ip sla thresholds received! ");
                        return status;
                    }
                    this.log().debug("IP SLA: " + tagResults.get(ipslaInstance) + " threshold exceeded.");
                    returnValue = returnValue + ". Monitoring threshold is enabled. Threshold value is " + threshResults.get(ipslaInstance);
                    return PollStatus.unavailable((String)returnValue);
                }
                if (((SnmpValue)operSenseResults.get(ipslaInstance)).toInt() != RTT_MON_OPER_SENSE.OK.value() && ((SnmpValue)operSenseResults.get(ipslaInstance)).toInt() != RTT_MON_OPER_SENSE.OVER_THRESHOLD.value()) continue;
                this.log().debug("Threshold is ignored rttMonLatestOperSense: " + ((SnmpValue)operSenseResults.get(ipslaInstance)).toInt());
                status = this.logUp(Level.INFO, Double.parseDouble(((SnmpValue)latestRttResults.get(ipslaInstance)).toString()), returnValue);
                return status;
            }
            status = PollStatus.unavailable((String)returnValue);
        }
        catch (NullPointerException e) {
            status = this.logDown(Level.WARN, "Unexpected error during SNMP poll of interface " + hostAddress, e);
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.WARN, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.WARN, "Invalid SNMP Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + hostAddress, t);
        }
        return status;
    }

    private String resolveOperSate(int sc) {
        String name = "UNKNOWN";
        if (RTT_MON_OPER_STATE.RESET.value() == sc) {
            name = RTT_MON_OPER_STATE.RESET.name();
        }
        if (RTT_MON_OPER_STATE.ORDERLY_STOP.value() == sc) {
            name = RTT_MON_OPER_STATE.ORDERLY_STOP.name();
        }
        if (RTT_MON_OPER_STATE.IMMEDIATE_STOP.value() == sc) {
            name = RTT_MON_OPER_STATE.IMMEDIATE_STOP.name();
        }
        if (RTT_MON_OPER_STATE.PENDING.value() == sc) {
            name = RTT_MON_OPER_STATE.PENDING.name();
        }
        if (RTT_MON_OPER_STATE.INACTIVE.value() == sc) {
            name = RTT_MON_OPER_STATE.INACTIVE.name();
        }
        if (RTT_MON_OPER_STATE.ACTIVE.value() == sc) {
            name = RTT_MON_OPER_STATE.ACTIVE.name();
        }
        if (RTT_MON_OPER_STATE.RESTART.value() == sc) {
            name = RTT_MON_OPER_STATE.RESTART.name();
        }
        return name;
    }

    private String resolveOperSense(int sc) {
        String name = "UNKNOWN";
        if (RTT_MON_OPER_SENSE.OTHER.value() == sc) {
            name = RTT_MON_OPER_SENSE.OTHER.name();
        }
        if (RTT_MON_OPER_SENSE.OK.value() == sc) {
            name = RTT_MON_OPER_SENSE.OK.name();
        }
        if (RTT_MON_OPER_SENSE.DISCONNECTED.value() == sc) {
            name = RTT_MON_OPER_SENSE.DISCONNECTED.name();
        }
        if (RTT_MON_OPER_SENSE.OVER_THRESHOLD.value() == sc) {
            name = RTT_MON_OPER_SENSE.OVER_THRESHOLD.name();
        }
        if (RTT_MON_OPER_SENSE.TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.BUSY.value() == sc) {
            name = RTT_MON_OPER_SENSE.BUSY.name();
        }
        if (RTT_MON_OPER_SENSE.NOT_CONNECTED.value() == sc) {
            name = RTT_MON_OPER_SENSE.NOT_CONNECTED.name();
        }
        if (RTT_MON_OPER_SENSE.DROPPED.value() == sc) {
            name = RTT_MON_OPER_SENSE.DROPPED.name();
        }
        if (RTT_MON_OPER_SENSE.SEQUENCE_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.SEQUENCE_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.VERIFY_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.VERIFY_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.APPLICATION_SPECIFIC.value() == sc) {
            name = RTT_MON_OPER_SENSE.APPLICATION_SPECIFIC.name();
        }
        if (RTT_MON_OPER_SENSE.DNS_SERVER_TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.DNS_SERVER_TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.TCP_CONNECT_TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.TCP_CONNECT_TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.HTTP_TRANSACTION_TIMEOUT.value() == sc) {
            name = RTT_MON_OPER_SENSE.HTTP_TRANSACTION_TIMEOUT.name();
        }
        if (RTT_MON_OPER_SENSE.DNS_QUERY_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.DNS_QUERY_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.HTTP_ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.HTTP_ERROR.name();
        }
        if (RTT_MON_OPER_SENSE.ERROR.value() == sc) {
            name = RTT_MON_OPER_SENSE.ERROR.name();
        }
        return name;
    }

    private String resolveAdminType(int sc) {
        String name = "UNKNOWN";
        if (RTT_MON_ADMIN_TYPE.ECHO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.ECHO.name();
        }
        if (RTT_MON_ADMIN_TYPE.PATH_ECHO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.PATH_ECHO.name();
        }
        if (RTT_MON_ADMIN_TYPE.FILE_IO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.FILE_IO.name();
        }
        if (RTT_MON_ADMIN_TYPE.SCRIPT.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.SCRIPT.name();
        }
        if (RTT_MON_ADMIN_TYPE.UDP_ECHO.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.UDP_ECHO.name();
        }
        if (RTT_MON_ADMIN_TYPE.TCP_CONNECT.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.TCP_CONNECT.name();
        }
        if (RTT_MON_ADMIN_TYPE.HTTP.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.HTTP.name();
        }
        if (RTT_MON_ADMIN_TYPE.DNS.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.DNS.name();
        }
        if (RTT_MON_ADMIN_TYPE.JITTER.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.JITTER.name();
        }
        if (RTT_MON_ADMIN_TYPE.DLSW.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.DLSW.name();
        }
        if (RTT_MON_ADMIN_TYPE.DHCP.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.DHCP.name();
        }
        if (RTT_MON_ADMIN_TYPE.FTP.value() == sc) {
            name = RTT_MON_ADMIN_TYPE.FTP.name();
        }
        return name;
    }

    private static enum RTT_MON_ADMIN_TYPE {
        ECHO(1),
        PATH_ECHO(2),
        FILE_IO(3),
        SCRIPT(4),
        UDP_ECHO(5),
        TCP_CONNECT(6),
        HTTP(7),
        DNS(8),
        JITTER(9),
        DLSW(10),
        DHCP(11),
        FTP(12);

        private final int state;

        private RTT_MON_ADMIN_TYPE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    private static enum RTT_MON_OPER_SENSE {
        OTHER(0),
        OK(1),
        DISCONNECTED(2),
        OVER_THRESHOLD(3),
        TIMEOUT(4),
        BUSY(5),
        NOT_CONNECTED(6),
        DROPPED(7),
        SEQUENCE_ERROR(8),
        VERIFY_ERROR(9),
        APPLICATION_SPECIFIC(10),
        DNS_SERVER_TIMEOUT(11),
        TCP_CONNECT_TIMEOUT(12),
        HTTP_TRANSACTION_TIMEOUT(13),
        DNS_QUERY_ERROR(14),
        HTTP_ERROR(15),
        ERROR(16);

        private final int state;

        private RTT_MON_OPER_SENSE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    private static enum RTT_MON_OPER_STATE {
        RESET(1),
        ORDERLY_STOP(2),
        IMMEDIATE_STOP(3),
        PENDING(4),
        INACTIVE(5),
        ACTIVE(6),
        RESTART(7);

        private final int state;

        private RTT_MON_OPER_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

