/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.Querier;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.Updater;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.poller.PollerEventProcessor;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.DbPollEvent;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;

public class Poller
extends AbstractServiceDaemon {
    private static final Poller m_singleton = new Poller();
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private PollerEventProcessor m_eventProcessor;
    private PollableNetwork m_network;
    private QueryManager m_queryManager;
    private PollerConfig m_pollerConfig;
    private PollOutagesConfig m_pollOutagesConfig;
    private EventIpcManager m_eventMgr;
    private DataSource m_dataSource;

    public Poller() {
        super("OpenNMS.Poller");
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public PollerEventProcessor getEventProcessor() {
        return this.m_eventProcessor;
    }

    public void setEventProcessor(PollerEventProcessor eventProcessor) {
        this.m_eventProcessor = eventProcessor;
    }

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    public void setNetwork(PollableNetwork network) {
        this.m_network = network;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public PollOutagesConfig getPollOutagesConfig() {
        return this.m_pollOutagesConfig;
    }

    public void setPollOutagesConfig(PollOutagesConfig pollOutagesConfig) {
        this.m_pollOutagesConfig = pollOutagesConfig;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    protected void onInit() {
        this.log().debug("init: serviceUnresponsive behavior: " + (this.getPollerConfig().isServiceUnresponsiveEnabled() ? "enabled" : "disabled"));
        this.createScheduler();
        try {
            this.log().debug("init: Closing outages for unmanaged services");
            this.closeOutagesForUnmanagedServices();
        }
        catch (Throwable e) {
            this.log().error("init: Failed to close ouates for unmanage services", e);
        }
        try {
            this.log().debug("start: Scheduling existing interfaces");
            this.scheduleExistingServices();
        }
        catch (Throwable sqlE) {
            this.log().error("start: Failed to schedule existing interfaces", sqlE);
        }
        try {
            this.log().debug("start: Creating event broadcast event processor");
            this.setEventProcessor(new PollerEventProcessor(this));
        }
        catch (Throwable t) {
            this.log().fatal("start: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_initialized = true;
    }

    private void closeOutagesForUnmanagedServices() {
        Timestamp closeTime = new Timestamp(new Date().getTime());
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_SERVICES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))");
        svcUpdater.execute(new Object[]{closeTime});
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_INTERFACES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater ifUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))");
        ifUpdater.execute(new Object[]{closeTime});
    }

    public void closeOutagesForNode(Date closeDate, int eventId, int nodeId) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_NODE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(new Object[]{closeTime, eventId, nodeId});
    }

    public void closeOutagesForInterface(Date closeDate, int eventId, int nodeId, String ipAddr) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_IFACE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(new Object[]{closeTime, eventId, nodeId, ipAddr});
    }

    public void closeOutagesForService(Date closeDate, int eventId, int nodeId, String ipAddr, String serviceName) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_SERVICE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)");
        svcUpdater.execute(new Object[]{closeTime, eventId, nodeId, ipAddr, serviceName});
    }

    private void createScheduler() {
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        try {
            log.debug("init: Creating poller scheduler");
            this.setScheduler(new LegacyScheduler("Poller", this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            log.fatal("init: Failed to create poller scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStart() {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("start: Starting poller scheduler");
            }
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            if (this.log().isEnabledFor(ThreadCategory.Level.FATAL)) {
                this.log().fatal("start: Failed to start scheduler", (Throwable)e);
            }
            throw e;
        }
    }

    protected void onStop() {
        if (this.getScheduler() != null) {
            this.getScheduler().stop();
        }
        if (this.getEventProcessor() != null) {
            this.getEventProcessor().close();
        }
        this.releaseServiceMonitors();
        this.setScheduler(null);
    }

    private void releaseServiceMonitors() {
        this.getPollerConfig().releaseAllServiceMonitors();
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    public static Poller getInstance() {
        return m_singleton;
    }

    public ServiceMonitor getServiceMonitor(String svcName) {
        return this.getPollerConfig().getServiceMonitor(svcName);
    }

    private void scheduleExistingServices() throws Exception {
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        this.scheduleMatchingServices(null);
        this.getNetwork().recalculateStatus();
        this.getNetwork().propagateInitialCause();
        this.getNetwork().resetStatusChanged();
        if (log.isDebugEnabled()) {
            log.debug("scheduleExistingServices: dumping content of pollable network: ");
            this.getNetwork().dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleService(final int nodeId, String nodeLabel, String ipAddr, final String svcName) {
        final String normalizedAddress = InetAddressUtils.normalize((String)ipAddr);
        try {
            PollableNode node;
            PollableNetwork pollableNetwork = this.getNetwork();
            synchronized (pollableNetwork) {
                node = this.getNetwork().getNode(nodeId);
                if (node == null) {
                    node = this.getNetwork().createNode(nodeId, nodeLabel);
                }
            }
            final PollableNode svcNode = node;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    int matchCount = Poller.this.scheduleMatchingServices("ifServices.nodeId = " + nodeId + " AND ifServices.ipAddr = '" + normalizedAddress + "' AND service.serviceName = '" + svcName + "'");
                    if (matchCount > 0) {
                        svcNode.recalculateStatus();
                        svcNode.processStatusChange(new Date());
                    } else {
                        LogUtils.warnf((Object)this, (String)"Attempt to schedule service %d/%s/%s found no active service", (Object[])new Object[]{nodeId, normalizedAddress, svcName});
                    }
                }
            };
            node.withTreeLock(r);
        }
        catch (Throwable e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"Unable to schedule service %d/%s/%s", (Object[])new Object[]{nodeId, normalizedAddress, svcName});
        }
    }

    private int scheduleMatchingServices(String criteria) {
        String sql = "SELECT ifServices.nodeId AS nodeId, node.nodeLabel AS nodeLabel, ifServices.ipAddr AS ipAddr, ifServices.serviceId AS serviceId, service.serviceName AS serviceName, ifServices.status as status, outages.svcLostEventId AS svcLostEventId, events.eventUei AS svcLostEventUei, outages.ifLostService AS ifLostService, outages.ifRegainedService AS ifRegainedService FROM ifServices JOIN node ON ifServices.nodeId = node.nodeId JOIN service ON ifServices.serviceId = service.serviceId LEFT OUTER JOIN outages ON ifServices.nodeId = outages.nodeId AND ifServices.ipAddr = outages.ipAddr AND ifServices.serviceId = outages.serviceId AND ifRegainedService IS NULL LEFT OUTER JOIN events ON outages.svcLostEventId = events.eventid WHERE ifServices.status in ('A','N')" + (criteria == null ? "" : " AND " + criteria);
        final AtomicInteger count = new AtomicInteger(0);
        Querier querier = new Querier(this.m_dataSource, sql){

            public void processRow(ResultSet rs) throws SQLException {
                if (Poller.this.scheduleService(rs.getInt("nodeId"), rs.getString("nodeLabel"), rs.getString("ipAddr"), rs.getString("serviceName"), "A".equals(rs.getString("status")), (Number)rs.getObject("svcLostEventId"), rs.getTimestamp("ifLostService"), rs.getString("svcLostEventUei"))) {
                    count.incrementAndGet();
                }
            }
        };
        querier.execute(new Object[0]);
        return count.get();
    }

    private void updateServiceStatus(int nodeId, String ipAddr, String serviceName, String status) {
        String sql = "UPDATE ifservices SET status = ? WHERE id  IN (SELECT ifs.id FROM ifservices AS ifs JOIN service AS svc ON ifs.serviceid = svc.serviceid  WHERE ifs.nodeId = ? AND ifs.ipAddr = ? AND svc.servicename = ?)";
        Updater updater = new Updater(this.m_dataSource, "UPDATE ifservices SET status = ? WHERE id  IN (SELECT ifs.id FROM ifservices AS ifs JOIN service AS svc ON ifs.serviceid = svc.serviceid  WHERE ifs.nodeId = ? AND ifs.ipAddr = ? AND svc.servicename = ?)");
        updater.execute(new Object[]{status, nodeId, ipAddr, serviceName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleService(int nodeId, String nodeLabel, String ipAddr, String serviceName, boolean active, Number svcLostEventId, Date date, String svcLostUei) {
        ServiceMonitor monitor;
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        Package pkg = this.findPackageForService(ipAddr, serviceName);
        if (pkg == null) {
            if (active && !OpennmsServerConfigFactory.getInstance().verifyServer()) {
                log.warn("Active service " + serviceName + " on " + ipAddr + " not configured for any package. Marking as Not Polled.");
                this.updateServiceStatus(nodeId, ipAddr, serviceName, "N");
            }
            return false;
        }
        if (!active && !OpennmsServerConfigFactory.getInstance().verifyServer()) {
            log.info("Active service " + serviceName + " on " + ipAddr + " is now configured for any package. Marking as active.");
            this.updateServiceStatus(nodeId, ipAddr, serviceName, "A");
        }
        if ((monitor = this.m_pollerConfig.getServiceMonitor(serviceName)) == null) {
            log.info("Could not find service monitor associated with service " + serviceName);
            return false;
        }
        InetAddress addr = InetAddressUtils.addr((String)ipAddr);
        if (addr == null) {
            log.error("Could not convert " + ipAddr + " as an InetAddress " + ipAddr);
            return false;
        }
        PollableService svc = this.getNetwork().createService(nodeId, nodeLabel, addr, serviceName);
        PollableServiceConfig pollConfig = new PollableServiceConfig(svc, this.m_pollerConfig, this.m_pollOutagesConfig, pkg, this.getScheduler());
        svc.setPollConfig(pollConfig);
        PollableService pollableService = svc;
        synchronized (pollableService) {
            if (svc.getSchedule() == null) {
                Schedule schedule = new Schedule(svc, pollConfig, this.getScheduler());
                svc.setSchedule(schedule);
            }
        }
        if (svcLostEventId == null) {
            if (svc.getParent().getStatus().isUnknown()) {
                svc.updateStatus(PollStatus.up());
            } else {
                svc.updateStatus(svc.getParent().getStatus());
            }
        } else {
            svc.updateStatus(PollStatus.down());
            DbPollEvent cause = new DbPollEvent(svcLostEventId.intValue(), svcLostUei, date);
            svc.setCause(cause);
        }
        svc.schedule();
        return true;
    }

    private Package findPackageForService(String ipAddr, String serviceName) {
        Enumeration en = this.m_pollerConfig.enumeratePackage();
        Package lastPkg = null;
        while (en.hasMoreElements()) {
            Package pkg = (Package)en.nextElement();
            if (!this.pollableServiceInPackage(ipAddr, serviceName, pkg)) continue;
            lastPkg = pkg;
        }
        return lastPkg;
    }

    protected boolean pollableServiceInPackage(String ipAddr, String serviceName, Package pkg) {
        if (pkg.getRemote()) {
            this.log().debug("pollableServiceInPackage: this package: " + pkg.getName() + ", is a remote monitor package.");
            return false;
        }
        if (!this.m_pollerConfig.isServiceInPackageAndEnabled(serviceName, pkg)) {
            return false;
        }
        boolean inPkg = this.m_pollerConfig.isInterfaceInPackage(ipAddr, pkg);
        if (inPkg) {
            return true;
        }
        if (this.m_initialized) {
            this.m_pollerConfig.rebuildPackageIpListMap();
            return this.m_pollerConfig.isInterfaceInPackage(ipAddr, pkg);
        }
        return false;
    }

    public boolean packageIncludesIfAndSvc(Package pkg, String ipAddr, String svcName) {
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        if (!this.getPollerConfig().isServiceInPackageAndEnabled(svcName, pkg)) {
            if (log.isDebugEnabled()) {
                log.debug("packageIncludesIfAndSvc: address/service: " + ipAddr + "/" + svcName + " not scheduled, service is not enabled or does not exist in package: " + pkg.getName());
            }
            return false;
        }
        if (!this.getPollerConfig().isInterfaceInPackage(ipAddr, pkg)) {
            if (this.m_initialized) {
                this.getPollerConfig().rebuildPackageIpListMap();
                if (!this.getPollerConfig().isInterfaceInPackage(ipAddr, pkg)) {
                    if (log.isDebugEnabled()) {
                        log.debug("packageIncludesIfAndSvc: interface " + ipAddr + " gained service " + svcName + ", but the interface was not in package: " + pkg.getName());
                    }
                    return false;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("packageIncludesIfAndSvc: address/service: " + ipAddr + "/" + svcName + " not scheduled, interface does not belong to package: " + pkg.getName());
                }
                return false;
            }
        }
        return true;
    }

    public void refreshServicePackages() {
        PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

            @Override
            public void visitService(PollableService service) {
                service.refreshConfig();
            }
        };
        this.getNetwork().visit(visitor);
    }

    public void refreshServiceThresholds() {
        PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

            @Override
            public void visitService(PollableService service) {
                service.refreshThresholds();
            }
        };
        this.getNetwork().visit(visitor);
    }
}

