/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.springframework.jdbc.core.JdbcTemplate;

public class HttpNotificationStrategy
implements NotificationStrategy {
    private List<Argument> m_arguments;

    public int send(List<Argument> arguments) {
        this.m_arguments = arguments;
        String url = this.getUrl();
        if (url == null) {
            this.log().warn("send: url argument is null, HttpNotification requires a URL");
            return 1;
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet method = null;
        List<NameValuePair> posts = this.getPostArguments();
        if (posts == null) {
            method = new HttpGet(url);
            this.log().info("send: No \"post-\" arguments..., continuing with an HTTP GET using URL: " + url);
        } else {
            this.log().info("send: Found \"post-\" arguments..., continuing with an HTTP POST using URL: " + url);
            for (NameValuePair post : posts) {
                this.log().debug("send: post argument: " + post.getName() + " = " + post.getValue());
            }
            method = new HttpPost(url);
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(posts, "UTF-8");
                ((HttpPost)method).setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        String contents = null;
        int statusCode = -1;
        try {
            HttpResponse response = client.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            contents = EntityUtils.toString((HttpEntity)response.getEntity());
            this.log().info("send: Contents is: " + contents);
        }
        catch (IOException e) {
            this.log().error("send: IO problem with HTTP post/response: " + e);
            throw new RuntimeException("Problem with HTTP post: " + e.getMessage());
        }
        this.doSql(contents);
        return statusCode;
    }

    private void doSql(String contents) {
        if (this.getSql() == null) {
            this.log().info("send: optional sql argument is null.");
            return;
        }
        if (contents == null) {
            this.log().info("doSql: HTTP reply is null");
            return;
        }
        this.log().debug("send: compiling expression: " + this.getSwitchValue("result-match"));
        Pattern p = Pattern.compile(this.getSwitchValue("result-match"));
        Matcher m = p.matcher(contents);
        if (m.matches()) {
            this.log().debug("send: compiled expression ready to run sql: " + this.getSql());
            MatchTable matches = new MatchTable(m);
            String sqlString = PropertiesUtils.substitute((String)this.getSql(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{matches});
            this.log().debug("send: running sql: " + sqlString);
            JdbcTemplate template = new JdbcTemplate(DataSourceFactory.getInstance());
            template.execute(sqlString);
        } else {
            this.log().info("send: result didn't match, not running sql");
        }
    }

    private List<NameValuePair> getPostArguments() {
        List<Argument> args = this.getArgsByPrefix("post-");
        ArrayList<NameValuePair> retval = new ArrayList<NameValuePair>();
        for (Argument arg : args) {
            String argSwitch = arg.getSwitch().substring("post-".length());
            if (arg.getValue() == null) {
                arg.setValue("");
            }
            retval.add((NameValuePair)new BasicNameValuePair(argSwitch, this.getValue(arg.getValue())));
        }
        return retval;
    }

    private String getValue(String argValue) {
        if (argValue.equals("-d")) {
            return this.getNotificationValue("-d");
        }
        if (argValue.equals("-email")) {
            return this.getNotificationValue("-email");
        }
        if (argValue.equals("-hphone")) {
            return this.getNotificationValue("-hphone");
        }
        if (argValue.equals("-interface")) {
            return this.getNotificationValue("-interface");
        }
        if (argValue.equals("-ublog")) {
            return this.getNotificationValue("-ublog");
        }
        if (argValue.equals("-mphone")) {
            return this.getNotificationValue("-mphone");
        }
        if (argValue.equals("-nodeid")) {
            return this.getNotificationValue("-nodeid");
        }
        if (argValue.equals("-nm")) {
            return this.getNotificationValue("-nm");
        }
        if (argValue.equals("-np")) {
            return this.getNotificationValue("-np");
        }
        if (argValue.equals("-pemail")) {
            return this.getNotificationValue("-pemail");
        }
        if (argValue.equals("-r")) {
            return this.getNotificationValue("-r");
        }
        if (argValue.equals("-service")) {
            return this.getNotificationValue("-service");
        }
        if (argValue.equals("-subject")) {
            return this.getNotificationValue("-subject");
        }
        if (argValue.equals("-tm")) {
            return this.getNotificationValue("-tm");
        }
        if (argValue.equals("-tp")) {
            return this.getNotificationValue("-tp");
        }
        if (argValue.equals("-tuipin")) {
            return this.getNotificationValue("-tuipin");
        }
        if (argValue.equals("-t")) {
            return this.getNotificationValue("-t");
        }
        if (argValue.equals("-wphone")) {
            return this.getNotificationValue("-wphone");
        }
        if (argValue.equals("-xmpp")) {
            return this.getNotificationValue("-xmpp");
        }
        return argValue;
    }

    private String getNotificationValue(String notificationManagerParamString) {
        String message = "no notification text message defined for the \"" + notificationManagerParamString + "\" switch.";
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(notificationManagerParamString)) continue;
            message = arg.getValue();
        }
        this.log().debug("getNotificationValue: " + message);
        return message;
    }

    private List<Argument> getArgsByPrefix(String argPrefix) {
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().startsWith(argPrefix)) continue;
            args.add(arg);
        }
        return args;
    }

    private String getSql() {
        return this.getSwitchValue("sql");
    }

    private String getUrl() {
        String url = this.getSwitchValue("url");
        if (url == null) {
            url = this.getUrlAsPrefix();
        }
        return url;
    }

    private String getUrlAsPrefix() {
        String url = null;
        for (Argument arg : this.getArgsByPrefix("url")) {
            this.log().debug("Found url switch: " + arg.getSwitch() + " with value: " + arg.getValue());
            url = arg.getValue();
        }
        return url;
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

