/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.ExecutorStrategy;

public class ClassExecutor
implements ExecutorStrategy {
    @Override
    public int execute(String className, List<Argument> arguments) {
        NotificationStrategy ns;
        this.log().debug("Going for the class instance: " + className);
        try {
            ns = (NotificationStrategy)Class.forName(className).newInstance();
            this.log().debug(className + " class created: " + ns.getClass());
        }
        catch (Throwable e) {
            this.log().error("Execption creating notification strategy class: " + className, e);
            return 1;
        }
        try {
            return ns.send(arguments);
        }
        catch (Throwable t) {
            this.log().error("Throwable received while sending message: " + t, t);
            return 1;
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

