/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpStore;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpResult;

public final class LldpLocalGroup
extends AggregateTracker {
    public static final String LLDP_LOC_CHASSISID_SUBTYPE_ALIAS = "lldpLocChassisIdSubtype";
    public static final String LLDP_LOC_CHASSISID_SUBTYPE_OID = ".1.0.8802.1.1.2.1.3.1";
    public static final String LLDP_LOC_CHASSISID_ALIAS = "lldpLocChassisId";
    public static final String LLDP_LOC_CHASSISID_OID = ".1.0.8802.1.1.2.1.3.2";
    public static final String LLDP_LOC_SYSNAME_ALIAS = "lldpLocSysName";
    public static final String LLDP_LOC_SYSNAME_OID = ".1.0.8802.1.1.2.1.3.3";
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String LLDP_LOC_OID = ".1.0.8802.1.1.2.1.3";
    private SnmpStore m_store;
    private InetAddress m_address;

    public LldpLocalGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    public Integer getLldpLocChassisidSubType() {
        Integer type = this.m_store.getInt32(LLDP_LOC_CHASSISID_SUBTYPE_ALIAS);
        if (type == null) {
            return 7;
        }
        return type;
    }

    public String getLldpLocChassisid() {
        return this.m_store.getHexString(LLDP_LOC_CHASSISID_ALIAS);
    }

    public String getLldpLocSysname() {
        return this.m_store.getDisplayString(LLDP_LOC_SYSNAME_ALIAS);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        this.log().warn("Error retrieving lldpLocalGroup from " + this.m_address + ". " + msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info("Error retrieving lldpLocalGroup from " + this.m_address + ". " + msg);
    }

    private final ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    static {
        ms_elemList = new NamedSnmpVar[3];
        int ndx = 0;
        LldpLocalGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", LLDP_LOC_CHASSISID_SUBTYPE_ALIAS, LLDP_LOC_CHASSISID_SUBTYPE_OID);
        LldpLocalGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", LLDP_LOC_CHASSISID_ALIAS, LLDP_LOC_CHASSISID_OID);
        LldpLocalGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", LLDP_LOC_SYSNAME_ALIAS, LLDP_LOC_SYSNAME_OID);
    }
}

