/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.linkd.snmp.IpRouteCollectorEntry;

public final class InetCidrRouteTableEntry
extends IpRouteCollectorEntry {
    public static final String IP_ROUTE_PFX_LEN = "ipRoutePfxLen";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpIPAddress", "ipRouteDest", ".1.3.6.1.2.1.4.24.7.1.2", 1), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteIfIndex", ".1.3.6.1.2.1.4.24.7.1.7", 2), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteMetric1", ".1.3.6.1.2.1.4.24.7.1.12", 3), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteMetric2", ".1.3.6.1.2.1.4.24.7.1.13", 4), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteMetric3", ".1.3.6.1.2.1.4.24.7.1.14", 5), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteMetric4", ".1.3.6.1.2.1.4.24.7.1.15", 6), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpIPAddress", "ipRouteNextHop", ".1.3.6.1.2.1.4.24.7.1.6", 7), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteType", ".1.3.6.1.2.1.4.24.7.1.8", 8), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteProto", ".1.3.6.1.2.1.4.24.7.1.9", 9), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteAge", ".1.3.6.1.2.1.4.24.7.1.10", 10), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRoutePfxLen", ".1.3.6.1.2.1.4.24.7.1.3", 11), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipRouteMetric5", ".1.3.6.1.2.1.4.24.7.1.16", 12)};
    public static final String TABLE_OID = ".1.3.6.1.2.1.4.24.7.1";

    public InetCidrRouteTableEntry() {
        super(ms_elemList);
    }

    public InetAddress getInetCidrRouteDest() {
        return this.getIPAddress("ipRouteDest");
    }

    public int getInetCidrRouteIfIndex() {
        Integer val = this.getInt32("ipRouteIfIndex");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getInetCidrRouteMetric1() {
        Integer val = this.getInt32("ipRouteMetric1");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getInetCidrRouteMetric2() {
        Integer val = this.getInt32("ipRouteMetric2");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getInetCidrRouteMetric3() {
        Integer val = this.getInt32("ipRouteMetric3");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getInetCidrRouteMetric4() {
        Integer val = this.getInt32("ipRouteMetric4");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public InetAddress getInetCidrRouteNextHop() {
        return this.getIPAddress("ipRouteNextHop");
    }

    public int getInetCidrRouteType() {
        Integer val = this.getInt32("ipRouteType");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getInetCidrRouteProto() {
        Integer val = this.getInt32("ipRouteProto");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getInetCidrRouteAge() {
        Integer val = this.getInt32("ipRouteAge");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public InetAddress getInetCidrRouteMask() throws UnknownHostException {
        Integer mask;
        Integer prefix = this.getInt32(IP_ROUTE_PFX_LEN);
        Integer value = mask = Integer.valueOf(-1 << 32 - prefix);
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        InetAddress netAddr = InetAddressUtils.getInetAddress((byte[])bytes);
        return netAddr;
    }

    public int getInetCidrRouteMetric5() {
        Integer val = this.getInt32("ipRouteMetric5");
        if (val == null) {
            return -1;
        }
        return val;
    }

    public String getInetCidrRouteInfo() {
        return this.getObjectID("ipRouteInfo");
    }
}

