/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpStore;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpResult;

public final class Dot1dBaseGroup
extends AggregateTracker {
    public static final String BASE_BRIDGE_ADDRESS = "dot1dBaseBridgeAddress";
    public static final String BASE_NUM_PORTS = "dot1dBaseNumPorts";
    public static final String BASE_NUM_TYPE = "dot1dBaseType";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "dot1dBaseBridgeAddress", ".1.3.6.1.2.1.17.1.1"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dBaseNumPorts", ".1.3.6.1.2.1.17.1.2"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dBaseType", ".1.3.6.1.2.1.17.1.3")};
    public static final String SYSTEM_OID = ".1.3.6.1.2.1.17.1";
    private SnmpStore m_store;
    private InetAddress m_address;

    public Dot1dBaseGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LogUtils.warnf((Object)((Object)this), (String)"Error retrieving systemGroup from %s: %s", (Object[])new Object[]{this.m_address, msg});
    }

    protected void reportNoSuchNameErr(String msg) {
        LogUtils.infof((Object)((Object)this), (String)"Error retrieving systemGroup from %s: %s", (Object[])new Object[]{this.m_address, msg});
    }

    public String getBridgeAddress() {
        return this.m_store.getHexString(BASE_BRIDGE_ADDRESS);
    }

    public int getNumberOfPorts() {
        Integer nop = this.m_store.getInt32(BASE_NUM_PORTS);
        if (nop == null) {
            return -1;
        }
        return nop;
    }

    public int getBridgeType() {
        Integer type = this.m_store.getInt32(BASE_NUM_TYPE);
        if (type == null) {
            return 1;
        }
        return type;
    }
}

