/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.capsd.snmp.SnmpStore;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.CdpCacheTable;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTable;
import org.opennms.netmgt.linkd.snmp.IntelVlanTable;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTable;
import org.opennms.netmgt.linkd.snmp.LldpLocTable;
import org.opennms.netmgt.linkd.snmp.LldpLocalGroup;
import org.opennms.netmgt.linkd.snmp.LldpRemTable;
import org.opennms.netmgt.linkd.snmp.OspfGeneralGroup;
import org.opennms.netmgt.linkd.snmp.OspfNbrTable;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public final class SnmpCollection
implements ReadyRunnable {
    public static final String TRUNK_VLAN_NAME = "AllVlans";
    public static final int TRUNK_VLAN_INDEX = 0;
    public static final String DEFAULT_VLAN_NAME = "default";
    public static final int DEFAULT_VLAN_INDEX = 1;
    private final SnmpAgentConfig m_agentConfig;
    private final int m_nodeid;
    private final InetAddress m_address;
    private String m_vlanClass = null;
    private String m_ipRouteClass = null;
    private boolean m_collectVlan = false;
    private boolean m_collectIpRoute = false;
    private boolean m_collectStp = false;
    private boolean m_saveStpNodeTable = false;
    private boolean m_saveIpRouteTable = false;
    private boolean m_saveStpInterfaceTable = false;
    private boolean m_collectBridge = false;
    private boolean m_collectCdp = false;
    private boolean m_collectLldp = false;
    private boolean m_collectOspf = false;
    public LldpLocalGroup m_lldpLocalGroup;
    public LldpLocTable m_lldpLocTable;
    public LldpRemTable m_lldpRemTable;
    public OspfGeneralGroup m_ospfGeneralGroup;
    public OspfNbrTable m_osNbrTable;
    public IpNetToMediaTable m_ipNetToMedia;
    public SnmpTable<SnmpStore> m_ipRoute;
    public CdpCacheTable m_CdpCache;
    public SnmpTable<SnmpStore> m_vlanTable;
    public final Map<OnmsVlan, SnmpVlanCollection> m_snmpVlanCollection = new HashMap<OnmsVlan, SnmpVlanCollection>();
    private Scheduler m_scheduler;
    private long poll_interval = 1800000L;
    private long initial_sleep_time = 600000L;
    private boolean suspendCollection = false;
    private boolean runned = false;
    private String packageName;
    private final Linkd m_linkd;

    public SnmpCollection(Linkd linkd, int nodeid, SnmpAgentConfig config) {
        this.m_linkd = linkd;
        this.m_agentConfig = config;
        this.m_nodeid = nodeid;
        this.m_address = this.m_agentConfig.getEffectiveAddress();
    }

    boolean hasOspfGeneralGroup() {
        return this.m_ospfGeneralGroup != null && !this.m_ospfGeneralGroup.failed() && this.m_ospfGeneralGroup.getOspfRouterId() != null;
    }

    OspfGeneralGroup getOspfGeneralGroup() {
        return this.m_ospfGeneralGroup;
    }

    boolean hasOspfNbrTable() {
        return this.m_osNbrTable != null && !this.m_osNbrTable.failed() && !this.m_osNbrTable.isEmpty();
    }

    OspfNbrTable getOspfNbrTable() {
        return this.m_osNbrTable;
    }

    boolean hasLldpLocalGroup() {
        return this.m_lldpLocalGroup != null && !this.m_lldpLocalGroup.failed() && this.m_lldpLocalGroup.getLldpLocChassisid() != null;
    }

    LldpLocalGroup getLldpLocalGroup() {
        return this.m_lldpLocalGroup;
    }

    boolean hasLldpRemTable() {
        return this.m_lldpRemTable != null && !this.m_lldpRemTable.failed() && !this.m_lldpRemTable.isEmpty();
    }

    LldpRemTable getLldpRemTable() {
        return this.m_lldpRemTable;
    }

    boolean hasLldpLocTable() {
        return this.m_lldpLocTable != null && !this.m_lldpLocTable.failed() && !this.m_lldpLocTable.isEmpty();
    }

    LldpLocTable getLldpLocTable() {
        return this.m_lldpLocTable;
    }

    boolean hasIpNetToMediaTable() {
        return this.m_ipNetToMedia != null && !this.m_ipNetToMedia.failed() && !this.m_ipNetToMedia.isEmpty();
    }

    IpNetToMediaTable getIpNetToMediaTable() {
        return this.m_ipNetToMedia;
    }

    boolean hasRouteTable() {
        return this.m_ipRoute != null && !this.m_ipRoute.failed() && !this.m_ipRoute.isEmpty();
    }

    SnmpTable<SnmpStore> getIpRouteTable() {
        return this.m_ipRoute;
    }

    boolean hasCdpCacheTable() {
        return this.m_CdpCache != null && !this.m_CdpCache.failed() && !this.m_CdpCache.isEmpty();
    }

    CdpCacheTable getCdpCacheTable() {
        return this.m_CdpCache;
    }

    boolean hasVlanTable() {
        return this.m_vlanTable != null && !this.m_vlanTable.failed() && !this.m_vlanTable.isEmpty();
    }

    SnmpTable<SnmpStore> getVlanTable() {
        return this.m_vlanTable;
    }

    public String getVlanName(int m_vlan) {
        if (this.hasVlanTable()) {
            for (SnmpStore ent : this.getVlanTable()) {
                int vlanIndex = ent.getInt32("vtpVlanIndex");
                if (vlanIndex != m_vlan) continue;
                return ent.getDisplayString("vtpVlanName");
            }
        }
        return null;
    }

    public int getVlanIndex(String m_vlanname) {
        if (this.hasVlanTable()) {
            for (SnmpStore ent : this.getVlanTable()) {
                String vlanName = ent.getDisplayString("vtpVlanName");
                if (!vlanName.equals(m_vlanname)) continue;
                return ent.getInt32("vtpVlanIndex");
            }
        }
        return -1;
    }

    Map<OnmsVlan, SnmpVlanCollection> getSnmpVlanCollections() {
        return this.m_snmpVlanCollection;
    }

    @Override
    public void run() {
        if (this.suspendCollection) {
            LogUtils.debugf((Object)this, (String)"run: address: %s Suspended!", (Object[])new Object[]{InetAddressUtils.str((InetAddress)this.m_address)});
        } else {
            this.runCollection();
        }
    }

    private void runCollection() {
        boolean collectVlanTable;
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryStarted", "Linkd");
        builder.setNodeid((long)this.m_nodeid);
        builder.setInterface(this.m_address);
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
        String hostAddress = InetAddressUtils.str((InetAddress)this.m_address);
        this.m_ipNetToMedia = new IpNetToMediaTable(this.m_address);
        this.m_CdpCache = new CdpCacheTable(this.m_address);
        this.m_lldpLocalGroup = new LldpLocalGroup(this.m_address);
        this.m_lldpRemTable = new LldpRemTable(this.m_address);
        this.m_lldpLocTable = new LldpLocTable(this.m_address);
        this.m_ospfGeneralGroup = new OspfGeneralGroup(this.m_address);
        this.m_osNbrTable = new OspfNbrTable(this.m_address);
        LogUtils.debugf((Object)this, (String)"run: collecting : %s", (Object[])new Object[]{this.m_agentConfig});
        LogUtils.debugf((Object)this, (String)"run: collectVlan/collectIpRoute/collectStp/m_collectBridge/m_collectCdp/m_collectLldp/m_collectOspf: %b/%b/%b/%b/%b/%b/%b", (Object[])new Object[]{this.m_collectVlan, this.m_collectIpRoute, this.m_collectStp, this.m_collectBridge, this.m_collectCdp, this.m_collectLldp, this.m_collectOspf});
        LogUtils.debugf((Object)this, (String)"run: m_saveStpNodeTable/m_saveIpRouteTable/m_saveStpInterfaceTable: %b/%b/%b", (Object[])new Object[]{this.m_saveStpNodeTable, this.m_saveIpRouteTable, this.m_saveStpInterfaceTable});
        SnmpWalker walker = null;
        boolean collectIpRouteTable = this.m_collectIpRoute;
        if (collectIpRouteTable) {
            Class<?> ipRouteGetter = null;
            try {
                ipRouteGetter = Class.forName(this.m_ipRouteClass);
            }
            catch (ClassNotFoundException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)("run: " + this.m_ipRouteClass + " class not found "), (Object[])new Object[0]);
                collectIpRouteTable = false;
            }
            Class[] classes = new Class[]{InetAddress.class};
            Constructor<?> constr = null;
            try {
                constr = ipRouteGetter.getConstructor(classes);
            }
            catch (Throwable e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)("run: " + this.m_ipRouteClass + " unable to get constructor."), (Object[])new Object[0]);
                collectIpRouteTable = false;
            }
            Object[] argum = new Object[]{this.m_address};
            try {
                this.m_ipRoute = (SnmpTable)constr.newInstance(argum);
            }
            catch (Throwable e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)("run: " + this.m_ipRouteClass + " unable to invoke class."), (Object[])new Object[0]);
                collectIpRouteTable = false;
            }
        }
        if (collectVlanTable = this.m_collectVlan) {
            Class<?> vlanGetter = null;
            try {
                vlanGetter = Class.forName(this.m_vlanClass);
            }
            catch (ClassNotFoundException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"run: %s class not found", (Object[])new Object[]{this.m_vlanClass});
                collectVlanTable = false;
            }
            Class[] classes = new Class[]{InetAddress.class};
            Constructor<?> constr = null;
            try {
                constr = vlanGetter.getConstructor(classes);
            }
            catch (NoSuchMethodException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"run: %s class has no such method", (Object[])new Object[]{this.m_vlanClass});
                collectVlanTable = false;
            }
            catch (SecurityException s) {
                LogUtils.warnf((Object)this, (Throwable)s, (String)"run: %s class security violation", (Object[])new Object[]{this.m_vlanClass});
                collectVlanTable = false;
            }
            Object[] argum = new Object[]{this.m_address};
            try {
                this.m_vlanTable = (SnmpTable)constr.newInstance(argum);
            }
            catch (Throwable e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"run: unable to instantiate class %s", (Object[])new Object[]{this.m_vlanClass});
                collectVlanTable = false;
            }
        }
        int i = 0;
        if (this.m_collectBridge) {
            ++i;
        }
        if (this.m_collectOspf) {
            i += 2;
        }
        if (this.m_collectLldp) {
            i += 3;
        }
        if (collectIpRouteTable) {
            ++i;
        }
        if (this.m_collectCdp) {
            ++i;
        }
        if (collectVlanTable) {
            ++i;
        }
        CollectionTracker[] tracker = new CollectionTracker[i];
        i = 0;
        String name = "";
        if (this.m_collectBridge) {
            name = name + "ipNetToMediaTable";
            tracker[i++] = this.m_ipNetToMedia;
        }
        if (this.m_collectOspf) {
            if (i > 0) {
                name = name + "/";
            }
            name = name + "ospfGeneralGroup/OspfNbrTable";
            tracker[i++] = this.m_ospfGeneralGroup;
            tracker[i++] = this.m_osNbrTable;
        }
        if (this.m_collectLldp) {
            if (i > 0) {
                name = name + "/";
            }
            name = name + "lldpLocalGroup/lldpLocTable/lldpRemTable";
            tracker[i++] = this.m_lldpLocalGroup;
            tracker[i++] = this.m_lldpLocTable;
            tracker[i++] = this.m_lldpRemTable;
        }
        if (collectIpRouteTable) {
            if (i > 0) {
                name = name + "/";
            }
            name = name + "ipRouteTable";
            tracker[i++] = this.m_ipRoute;
        }
        if (this.m_collectCdp) {
            if (i > 0) {
                name = name + "/";
            }
            name = name + "cdpCacheTable";
            tracker[i++] = this.m_CdpCache;
        }
        if (collectVlanTable) {
            if (i > 0) {
                name = name + "/";
            }
            name = name + "vlanTable";
            tracker[i++] = this.m_vlanTable;
        }
        LogUtils.infof((Object)this, (String)"run: Collecting %s from %s", (Object[])new Object[]{name, InetAddressUtils.str((InetAddress)this.m_agentConfig.getEffectiveAddress())});
        if (i > 0) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)name, (CollectionTracker[])tracker);
            walker.start();
            try {
                walker.waitFor();
            }
            catch (InterruptedException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"run: collection interrupted, exiting", (Object[])new Object[0]);
                return;
            }
        }
        if (this.m_collectOspf && !this.hasOspfGeneralGroup()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect ospfGeneralGroup for %s", (Object[])new Object[]{hostAddress});
        }
        if (this.m_collectOspf && !this.hasOspfNbrTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect ospfNbrTable for %s", (Object[])new Object[]{hostAddress});
        }
        if (this.m_collectLldp && !this.hasLldpLocalGroup()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect lldpLocalGroup for %s", (Object[])new Object[]{hostAddress});
        }
        if (this.m_collectLldp && !this.hasLldpLocTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect lldpLocTable for %s", (Object[])new Object[]{hostAddress});
        }
        if (this.m_collectLldp && !this.hasLldpRemTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect lldpRemTable for %s", (Object[])new Object[]{hostAddress});
        }
        if (this.m_collectBridge && !this.hasIpNetToMediaTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect ipNetToMediaTable for %s", (Object[])new Object[]{hostAddress});
        }
        if (collectIpRouteTable && !this.hasRouteTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect ipRouteTable for %s", (Object[])new Object[]{hostAddress});
        }
        if (this.m_collectCdp && !this.hasCdpCacheTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect dpCacheTable for %s", (Object[])new Object[]{hostAddress});
        }
        if (collectVlanTable && !this.hasVlanTable()) {
            LogUtils.infof((Object)this, (String)"run: failed to collect VLAN for %s", (Object[])new Object[]{hostAddress});
        }
        if (this.hasVlanTable()) {
            if (!this.m_vlanClass.equals(CiscoVlanTable.class.getName()) && !this.m_vlanClass.equals(IntelVlanTable.class.getName())) {
                this.runAndSaveSnmpVlanCollection(new OnmsVlan(0, TRUNK_VLAN_NAME, 1));
            } else {
                LogUtils.debugf((Object)this, (String)"run: start collection for %d VLAN entries", (Object[])new Object[]{this.getVlanTable().size()});
                for (SnmpStore ent : this.m_vlanTable) {
                    Integer status;
                    int vlanindex = ent.getInt32("vtpVlanIndex");
                    if (vlanindex == -1) {
                        LogUtils.debugf((Object)this, (String)"run: found null value for VLAN.", (Object[])new Object[0]);
                        continue;
                    }
                    String vlanname = ent.getDisplayString("vtpVlanName");
                    if (vlanname == null) {
                        vlanname = DEFAULT_VLAN_NAME;
                    }
                    if ((status = ent.getInt32("vtpVlanStatus")) == null || status != 1) {
                        LogUtils.infof((Object)this, (String)"run: skipping VLAN %s: NOT ACTIVE or null", (Object[])new Object[]{vlanindex});
                        continue;
                    }
                    String community = this.m_agentConfig.getReadCommunity();
                    LogUtils.debugf((Object)this, (String)"run: peer community: %s with VLAN %s", (Object[])new Object[]{community, vlanindex});
                    Integer type = ent.getInt32("vtpVlanType");
                    if (type == null || type != 1) {
                        LogUtils.infof((Object)this, (String)"run: skipping VLAN %s NOT ETHERNET TYPE", (Object[])new Object[]{vlanindex});
                        continue;
                    }
                    if (vlanindex != 1) {
                        this.m_agentConfig.setReadCommunity(community + "@" + vlanindex);
                    }
                    this.runAndSaveSnmpVlanCollection(new OnmsVlan(vlanindex, vlanname, status.intValue()));
                    this.m_agentConfig.setReadCommunity(community);
                }
            }
        } else {
            this.runAndSaveSnmpVlanCollection(new OnmsVlan(1, DEFAULT_VLAN_NAME, 1));
        }
        LogUtils.debugf((Object)this, (String)"run: saving collection into database for %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)this.m_agentConfig.getEffectiveAddress())});
        this.m_linkd.updateNodeSnmpCollection(this);
        this.m_ipNetToMedia = null;
        this.m_ipRoute = null;
        this.m_CdpCache = null;
        this.m_vlanTable = null;
        this.m_lldpLocalGroup = null;
        this.m_lldpLocTable = null;
        this.m_lldpRemTable = null;
        this.m_ospfGeneralGroup = null;
        this.m_osNbrTable = null;
        this.m_snmpVlanCollection.clear();
        builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryCompleted", "Linkd");
        builder.setNodeid((long)this.m_nodeid);
        builder.setInterface(this.m_address);
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
        this.reschedule();
        this.runned = true;
    }

    private void runAndSaveSnmpVlanCollection(OnmsVlan vlan) {
        SnmpVlanCollection snmpvlancollection = new SnmpVlanCollection(this.m_agentConfig, this.m_collectStp, this.m_collectBridge);
        snmpvlancollection.run();
        if (snmpvlancollection.failed()) {
            LogUtils.debugf((Object)this, (String)"runAndSaveSnmpVlanCollection: no bridge info found for %s", (Object[])new Object[]{this.m_agentConfig});
        } else {
            LogUtils.debugf((Object)this, (String)"runAndSaveSnmpVlanCollection: adding bridge info to snmpcollection, VLAN = %s, SnmpVlanCollection = %s", (Object[])new Object[]{vlan, snmpvlancollection});
            this.m_snmpVlanCollection.put(vlan, snmpvlancollection);
        }
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    public long getPollInterval() {
        return this.poll_interval;
    }

    public void setPollInterval(long interval) {
        this.poll_interval = interval;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.poll_interval, this);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.unschedule(this, this.poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.poll_interval + this.initial_sleep_time);
        }
    }

    public String getIpRouteClass() {
        return this.m_ipRouteClass;
    }

    public void setIpRouteClass(String className) {
        if (className == null || className.equals("")) {
            return;
        }
        this.m_ipRouteClass = className;
        this.m_collectIpRoute = true;
    }

    public String getVlanClass() {
        return this.m_vlanClass;
    }

    public void setVlanClass(String className) {
        if (className == null || className.equals("")) {
            return;
        }
        this.m_vlanClass = className;
        this.m_collectVlan = true;
    }

    public InetAddress getTarget() {
        return this.m_address;
    }

    public boolean collectVlanTable() {
        return this.m_collectVlan;
    }

    public String getReadCommunity() {
        return this.m_agentConfig.getReadCommunity();
    }

    public SnmpAgentConfig getPeer() {
        return this.m_agentConfig;
    }

    public int getPort() {
        return this.m_agentConfig.getPort();
    }

    @Override
    public boolean equals(ReadyRunnable run) {
        SnmpCollection c;
        return run instanceof SnmpCollection && this.getPackageName().equals(run.getPackageName()) && (c = (SnmpCollection)run).getTarget().equals(this.m_address) && c.getPort() == this.getPort() && c.getReadCommunity().equals(this.getReadCommunity());
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable SnmpCollection ip=" + InetAddressUtils.str((InetAddress)this.getTarget()) + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName() + " collectBridge=" + this.getCollectBridge() + " collectStpNode=" + this.getCollectStp() + " collectCdp=" + this.getCollectCdp() + " collectIpRoute=" + this.getCollectIpRoute() + " saveIpRouteTable=" + this.getSaveIpRouteTable() + " saveStpInterfaceTable=" + this.getSaveStpInterfaceTable() + " saveStpNodeTable=" + this.getSaveStpNodeTable();
    }

    public boolean getCollectLldpTable() {
        return this.m_collectLldp;
    }

    public void collectLldp(boolean collectLldpTable) {
        this.m_collectLldp = collectLldpTable;
    }

    public boolean getCollectBridge() {
        return this.m_collectBridge;
    }

    public void collectBridge(boolean bridgeForwardingTable) {
        this.m_collectBridge = bridgeForwardingTable;
    }

    public boolean getCollectCdp() {
        return this.m_collectCdp;
    }

    public void collectCdp(boolean cdpTable) {
        this.m_collectCdp = cdpTable;
    }

    public boolean getCollectIpRoute() {
        return this.m_collectIpRoute;
    }

    public void collectIpRoute(boolean ipRouteTable) {
        this.m_collectIpRoute = ipRouteTable;
    }

    public boolean getCollectStp() {
        return this.m_collectStp;
    }

    public void collectStp(boolean stpNode) {
        this.m_collectStp = stpNode;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean getSaveStpNodeTable() {
        return this.m_saveStpNodeTable;
    }

    public void saveStpNodeTable(boolean stpNodeTable) {
        this.m_saveStpNodeTable = stpNodeTable;
    }

    public boolean getSaveIpRouteTable() {
        return this.m_saveIpRouteTable;
    }

    public void SaveIpRouteTable(boolean ipRouteTable) {
        this.m_saveIpRouteTable = ipRouteTable;
    }

    public boolean getSaveStpInterfaceTable() {
        return this.m_saveStpInterfaceTable;
    }

    public void saveStpInterfaceTable(boolean stpInterfaceTable) {
        this.m_saveStpInterfaceTable = stpInterfaceTable;
    }

    public void collectOspf(boolean collectOspfTable) {
        this.m_collectOspf = collectOspfTable;
    }

    public boolean getCollectOspfTable() {
        return this.m_collectOspf;
    }
}

