/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;

public class RouterInterface {
    private int m_ifIndex;
    private int m_metric;
    private InetAddress m_routeDest;
    private InetAddress m_routeMask;
    private InetAddress m_nextHop;
    private final int m_nextHopNodeId;
    private final int m_nextHopIfIndex;
    private final InetAddress m_nextHopNetmask;
    private int m_snmpIfType;

    RouterInterface(int nextHopNodeId, int nextHopIfIndex, InetAddress nextHopNetmask) {
        this.m_nextHopNodeId = nextHopNodeId;
        this.m_nextHopIfIndex = nextHopIfIndex;
        this.m_nextHopNetmask = nextHopNetmask;
    }

    RouterInterface(int nextHopNodeId, int nextHopIfIndex) {
        this.m_nextHopNodeId = nextHopNodeId;
        this.m_nextHopIfIndex = nextHopIfIndex;
        this.m_nextHopNetmask = InetAddressUtils.TWO_FIFTY_FIVES;
    }

    public int getIfindex() {
        return this.m_ifIndex;
    }

    public int getMetric() {
        return this.m_metric;
    }

    public void setMetric(int metric) {
        this.m_metric = metric;
    }

    public InetAddress getNextHop() {
        return this.m_nextHop;
    }

    public void setNextHop(InetAddress nextHop) {
        this.m_nextHop = nextHop;
    }

    public int getSnmpiftype() {
        return this.m_snmpIfType;
    }

    public void setSnmpiftype(int snmpiftype) {
        this.m_snmpIfType = snmpiftype;
    }

    public InetAddress getNetmask() {
        return this.m_nextHopNetmask;
    }

    public int getNextHopNodeid() {
        return this.m_nextHopNodeId;
    }

    public int getNextHopIfindex() {
        return this.m_nextHopIfIndex;
    }

    public void setIfindex(int ifindex) {
        this.m_ifIndex = ifindex;
    }

    public InetAddress getNextHopNet() {
        byte[] ipAddress = this.m_nextHop.getAddress();
        byte[] netMask = this.m_nextHopNetmask.getAddress();
        byte[] netWork = new byte[4];
        for (int i = 0; i < 4; ++i) {
            netWork[i] = Integer.valueOf(ipAddress[i] & netMask[i]).byteValue();
        }
        return InetAddressUtils.getInetAddress((byte[])netWork);
    }

    public InetAddress getRouteNet() {
        byte[] ipAddress = this.m_routeDest.getAddress();
        byte[] netMask = this.m_routeMask.getAddress();
        byte[] netWork = new byte[4];
        for (int i = 0; i < 4; ++i) {
            netWork[i] = Integer.valueOf(ipAddress[i] & netMask[i]).byteValue();
        }
        return InetAddressUtils.getInetAddress((byte[])netWork);
    }

    public InetAddress getRouteDest() {
        return this.m_routeDest;
    }

    public void setRouteDest(InetAddress routedest) {
        this.m_routeDest = routedest;
    }

    public InetAddress getRoutemask() {
        return this.m_routeMask;
    }

    public void setRoutemask(InetAddress routemask) {
        this.m_routeMask = routemask;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ifIndex", this.m_ifIndex).append("metric", this.m_metric).append("routeDest", (Object)this.m_routeDest).append("routeMask", (Object)this.m_routeMask).append("nextHop", (Object)this.m_nextHop).append("nextHopNodeId", this.m_nextHopNodeId).append("nextHopIfIndex", this.m_nextHopIfIndex).append("nextHopNetmask", (Object)this.m_nextHopNetmask).append("snmpIfType", this.m_snmpIfType).toString();
    }
}

