/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.LldpRemInterface;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.OspfNbrInterface;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTable;
import org.opennms.netmgt.linkd.snmp.FdbTableGet;
import org.opennms.netmgt.linkd.snmp.IntelVlanTable;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public final class DiscoveryLink
implements ReadyRunnable {
    private static final int SNMP_IF_TYPE_ETHERNET = 6;
    private static final int SNMP_IF_TYPE_PROP_VIRTUAL = 53;
    private static final int SNMP_IF_TYPE_L2_VLAN = 135;
    private static final int SNMP_IF_TYPE_L3_VLAN = 136;
    private String packageName;
    private List<NodeToNodeLink> m_links = new ArrayList<NodeToNodeLink>();
    private List<MacToNodeLink> m_maclinks = new ArrayList<MacToNodeLink>();
    private Map<Integer, LinkableNode> m_bridgeNodes = new HashMap<Integer, LinkableNode>();
    private List<LinkableNode> m_routerNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> m_lldpNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> m_ospfNodes = new ArrayList<LinkableNode>();
    private List<NodeToNodeLink> m_cdpLinks = new ArrayList<NodeToNodeLink>();
    private List<String> m_macsParsed = new ArrayList<String>();
    private List<String> macsExcluded = new ArrayList<String>();
    private boolean enableDownloadDiscovery = false;
    private boolean discoveryUsingRoutes = true;
    private boolean discoveryUsingCdp = true;
    private boolean discoveryUsingBridge = true;
    private boolean discoveryUsingLldp = false;
    private boolean discoveryUsingOspf = false;
    private boolean suspendCollection = false;
    private boolean isRunned = false;
    private boolean forceIpRouteDiscoveryOnEtherNet = false;
    private Scheduler m_scheduler;
    private long snmp_poll_interval = 1800000L;
    private long discovery_interval = 300000L;
    private long initial_sleep_time = 600000L;
    private Linkd m_linkd;

    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    public Linkd getLinkd() {
        return this.m_linkd;
    }

    @Override
    public void run() {
        if (this.suspendCollection) {
            LogUtils.warnf((Object)this, (String)"run: linkd collections are suspended!", (Object[])new Object[0]);
            return;
        }
        Collection<LinkableNode> linkableNodes = this.m_linkd.getLinkableNodesOnPackage(this.getPackageName());
        LogUtils.debugf((Object)this, (String)"run: LinkableNodes/package found: %d/%s", (Object[])new Object[]{linkableNodes.size(), this.getPackageName()});
        LogUtils.debugf((Object)this, (String)"run: discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes/discoveryUsingLldp/discoveryUsingOspf: %b/%b/%b/%b/%b", (Object[])new Object[]{this.discoveryUsingBridge, this.discoveryUsingCdp, this.discoveryUsingRoutes, this.discoveryUsingLldp, this.discoveryUsingOspf});
        LogUtils.debugf((Object)this, (String)"run: enableDownloadDiscovery: %b", (Object[])new Object[]{this.enableDownloadDiscovery});
        for (LinkableNode linkableNode : linkableNodes) {
            LogUtils.debugf((Object)this, (String)"run: Iterating on LinkableNode's found node with nodeid/sysoid/ipaddress %d/%s/%s", (Object[])new Object[]{linkableNode.getNodeId(), linkableNode.getSysoid(), InetAddressUtils.str((InetAddress)linkableNode.getSnmpPrimaryIpAddr())});
            if (this.discoveryUsingOspf && linkableNode.getOspfRouterId() != null && linkableNode.getOspfinterfaces() != null) {
                LogUtils.debugf((Object)this, (String)"run: adding to ospf node list: node with nodeid/ospfrouterid/#ospfinterface %d/%s/#%d", (Object[])new Object[]{linkableNode.getNodeId(), InetAddressUtils.str((InetAddress)linkableNode.getOspfRouterId()), linkableNode.getOspfinterfaces().size()});
                this.m_ospfNodes.add(linkableNode);
            }
            if (this.discoveryUsingLldp && linkableNode.getLldpChassisId() != null && linkableNode.getLldpChassisIdSubtype() != null) {
                LogUtils.debugf((Object)this, (String)"run: adding to lldp node list: node with nodeid/sysname/chassisid %d/%s/%s", (Object[])new Object[]{linkableNode.getNodeId(), linkableNode.getLldpSysname(), linkableNode.getLldpChassisId()});
                this.m_lldpNodes.add(linkableNode);
            }
            if (this.discoveryUsingBridge && linkableNode.isBridgeNode()) {
                LogUtils.debugf((Object)this, (String)"run: adding to bridge node list: node with nodeid/bridgeidentifier %d/%s", (Object[])new Object[]{linkableNode.getNodeId(), linkableNode.getBridgeIdentifiers().get(0)});
                this.m_bridgeNodes.put(linkableNode.getNodeId(), linkableNode);
            }
            if (this.discoveryUsingCdp && linkableNode.hasCdpInterfaces()) {
                LogUtils.debugf((Object)this, (String)"run: adding to CDP node list: node with nodeid/#cdpinterfaces %d/#%d", (Object[])new Object[]{linkableNode.getNodeId(), linkableNode.getCdpInterfaces().size()});
                this.addCdpLinks(linkableNode);
            }
            if (!this.discoveryUsingRoutes || !linkableNode.hasRouteInterfaces()) continue;
            LogUtils.debugf((Object)this, (String)"run: adding to router node list: node with nodeid/#iprouteinterface %d/#%d", (Object[])new Object[]{linkableNode.getNodeId(), linkableNode.getRouteInterfaces().size()});
            this.m_routerNodes.add(linkableNode);
        }
        if (this.discoveryUsingBridge) {
            this.populateMacToAtInterface();
        }
        if (this.enableDownloadDiscovery) {
            LogUtils.infof((Object)this, (String)"run: fetching further unknown MAC address SNMP bridge table info", (Object[])new Object[0]);
            this.parseBridgeNodes();
        }
        this.getLinksFromRouteTable();
        this.getLinksFromOspf();
        this.getLinkdFromLldp();
        this.getBackBoneLinksFromBridges();
        this.getLinksFromBridges();
        this.getLinksFromCdp();
        this.m_bridgeNodes.clear();
        this.m_routerNodes.clear();
        this.m_cdpLinks.clear();
        this.m_macsParsed.clear();
        this.macsExcluded.clear();
        this.m_lldpNodes.clear();
        this.m_ospfNodes.clear();
        if (this.getLinkd().getAtInterfaces(this.getPackageName()) != null) {
            this.getLinkd().getAtInterfaces(this.getPackageName()).clear();
        }
        this.m_linkd.updateDiscoveryLinkCollection(this);
        this.m_links.clear();
        this.m_maclinks.clear();
        this.isRunned = true;
        this.reschedule();
    }

    protected void populateMacToAtInterface() {
        LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: using atNodes to populate macToAtinterface", (Object[])new Object[0]);
        Map<String, List<AtInterface>> macs = this.getLinkd().getAtInterfaces(this.getPackageName());
        if (macs == null || macs.keySet() == null) {
            return;
        }
        for (String macAddress : macs.keySet()) {
            LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: MAC %s now has atinterface reference: %d", (Object[])new Object[]{macAddress, this.getLinkd().getAtInterfaces(this.getPackageName()).get(macAddress).size()});
            for (AtInterface at : this.getLinkd().getAtInterfaces(this.getPackageName()).get(macAddress)) {
                int nodeid = at.getNodeid();
                LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: Parsing AtInterface nodeid/ipaddr/macaddr: %d/%s/%s", (Object[])new Object[]{nodeid, at.getIpAddress(), macAddress});
                if (!this.m_linkd.isInterfaceInPackage(at.getIpAddress(), this.getPackageName())) {
                    LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: at interface: %s does not belong to package: %s! Not adding to discoverable atinterface.", (Object[])new Object[]{at.getIpAddress(), this.getPackageName()});
                    this.macsExcluded.add(macAddress);
                    continue;
                }
                if (this.isMacIdentifierOfBridgeNode(macAddress)) {
                    LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: AtInterface %s belongs to bridge node! Not adding to discoverable atinterface.", (Object[])new Object[]{macAddress});
                    this.macsExcluded.add(macAddress);
                    continue;
                }
                if (macAddress.indexOf("00000c07ac") != 0 && macAddress.indexOf("00000c9ff") != 0) continue;
                LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: AtInterface %s is Cisco HSRP address! Not adding to discoverable atinterface.", (Object[])new Object[]{macAddress});
                this.macsExcluded.add(macAddress);
            }
        }
        LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: end populateMacToAtinterface", (Object[])new Object[0]);
    }

    private void getLinksFromBridges() {
        if (this.m_bridgeNodes.size() > 0) {
            LogUtils.infof((Object)this, (String)"run: trying to find links using MAC Address Forwarding Table", (Object[])new Object[0]);
        }
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            int curNodeId = curNode.getNodeId();
            LogUtils.infof((Object)this, (String)"run: parsing bridge node with ID %d", (Object[])new Object[]{curNodeId});
            for (Integer curBridgePort : curNode.getPortMacs().keySet()) {
                LogUtils.debugf((Object)this, (String)"run: parsing bridge port %d with MAC address %s", (Object[])new Object[]{curBridgePort, curNode.getMacAddressesOnBridgePort(curBridgePort).toString()});
                if (curNode.isBackBoneBridgePort(curBridgePort)) {
                    LogUtils.debugf((Object)this, (String)"run: Port %d is a backbone bridge port. Skipping.", (Object[])new Object[]{curBridgePort});
                    continue;
                }
                int curIfIndex = curNode.getIfindex(curBridgePort);
                if (curIfIndex == -1) {
                    LogUtils.warnf((Object)this, (String)"run: got invalid ifIndex on bridge port %d", (Object[])new Object[]{curBridgePort});
                    continue;
                }
                Set<String> macs = curNode.getMacAddressesOnBridgePort(curBridgePort);
                List<LinkableNode> bridgesOnPort = this.getBridgesFromMacs(macs);
                if (bridgesOnPort.isEmpty()) {
                    LogUtils.debugf((Object)this, (String)"run: no bridge info found on port %d. Saving MACs.", (Object[])new Object[]{curBridgePort});
                    this.addLinks(macs, curNodeId, curIfIndex);
                    continue;
                }
                LogUtils.debugf((Object)this, (String)"run: bridge info found on port %d. Finding nearest.", (Object[])new Object[]{curBridgePort});
                for (LinkableNode endNode : bridgesOnPort) {
                    int endNodeid = endNode.getNodeId();
                    int endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                    if (endBridgePort == -1) {
                        LogUtils.warnf((Object)this, (String)"run: no valid port found on bridge nodeid %d for node bridge identifiers nodeid %d. Skipping.", (Object[])new Object[]{endNodeid, curNodeId});
                        continue;
                    }
                    boolean isTargetNode = this.isNearestBridgeLink(curNode, curBridgePort, endNode, endBridgePort);
                    if (!isTargetNode) continue;
                    int endIfindex = endNode.getIfindex(endBridgePort);
                    if (endIfindex == -1) {
                        LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on designated bridge port %d", (Object[])new Object[]{endBridgePort});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding backbone port %d to bridge", (Object[])new Object[]{curNodeId, curBridgePort});
                    curNode.addBackBoneBridgePorts(curBridgePort);
                    this.m_bridgeNodes.put(curNodeId, curNode);
                    LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding to helper class backbone port bridge port %d", (Object[])new Object[]{endNodeid, endBridgePort});
                    endNode.addBackBoneBridgePorts(endBridgePort);
                    this.m_bridgeNodes.put(endNodeid, endNode);
                    this.addLinks(this.getMacsOnBridgeLink(curNode, curBridgePort, endNode, endBridgePort), curNodeId, curIfIndex);
                    NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                    lk.setNodeparentid(endNodeid);
                    lk.setParentifindex(endIfindex);
                    LogUtils.infof((Object)this, (String)("run: saving bridge link: " + lk.toString()), (Object[])new Object[0]);
                    this.addNodetoNodeLink(lk);
                }
            }
            LogUtils.infof((Object)this, (String)"run: done parsing bridge node with ID %d", (Object[])new Object[]{curNodeId});
        }
        if (this.m_bridgeNodes.size() > 0) {
            LogUtils.infof((Object)this, (String)"run: done finding links using MAC Address Forwarding Table", (Object[])new Object[0]);
        }
    }

    private void getBackBoneLinksFromBridges() {
        if (this.m_bridgeNodes != null && this.m_bridgeNodes.size() > 0) {
            LogUtils.infof((Object)this, (String)"run: trying to find backbone ethernet links among bridge nodes using Spanning Tree Protocol", (Object[])new Object[0]);
        }
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            int curNodeId = curNode.getNodeId();
            InetAddress cupIpAddr = curNode.getSnmpPrimaryIpAddr();
            LogUtils.infof((Object)this, (String)"run: parsing bridge nodeid %d IP address %s with %d VLANs", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)cupIpAddr), curNode.getStpInterfaces().size()});
            for (Map.Entry<String, List<OnmsStpInterface>> me : curNode.getStpInterfaces().entrySet()) {
                String vlan = me.getKey();
                String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                LogUtils.debugf((Object)this, (String)"run: found bridge identifier %s", (Object[])new Object[]{curBaseBridgeAddress});
                String designatedRoot = null;
                if (!curNode.hasStpRoot(vlan)) {
                    LogUtils.debugf((Object)this, (String)"run: designated root bridge identifier not found. Skipping %s", (Object[])new Object[]{curBaseBridgeAddress});
                    continue;
                }
                designatedRoot = curNode.getStpRoot(vlan);
                if (designatedRoot == null || designatedRoot.equals("0000000000000000")) {
                    LogUtils.warnf((Object)this, (String)"run: designated root is invalid, skipping: %s", (Object[])new Object[]{designatedRoot});
                    continue;
                }
                if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                    LogUtils.debugf((Object)this, (String)"run: STP designated root is the bridge itself. Skipping.", (Object[])new Object[0]);
                    continue;
                }
                LogUtils.debugf((Object)this, (String)"run: STP designated root is another bridge. %s Parsing STP Interface", (Object[])new Object[]{designatedRoot});
                for (OnmsStpInterface stpIface : me.getValue()) {
                    int stpbridgeport = stpIface.getBridgePort();
                    if (curNode.isBackBoneBridgePort(stpbridgeport)) {
                        LogUtils.debugf((Object)this, (String)"run: bridge port %d already found. Skipping.", (Object[])new Object[]{stpbridgeport});
                        continue;
                    }
                    String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                    String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                    LogUtils.debugf((Object)this, (String)"run: parsing bridge port %d with STP designated bridge %s and STP designated port %s", (Object[])new Object[]{stpbridgeport, stpPortDesignatedBridge, stpPortDesignatedPort});
                    if (stpPortDesignatedBridge == null || stpPortDesignatedBridge.equals("0000000000000000") || stpPortDesignatedBridge.equals("")) {
                        LogUtils.warnf((Object)this, (String)"run: designated bridge is invalid, skipping: %s", (Object[])new Object[]{stpPortDesignatedBridge});
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                        LogUtils.debugf((Object)this, (String)"run: designated bridge for port %d is bridge itself", (Object[])new Object[]{stpbridgeport});
                        continue;
                    }
                    if (stpPortDesignatedPort == null || stpPortDesignatedPort.equals("0000")) {
                        LogUtils.warnf((Object)this, (String)"run: designated port is invalid: %s", (Object[])new Object[]{stpPortDesignatedPort});
                        continue;
                    }
                    int designatedbridgeport = Integer.parseInt(stpPortDesignatedPort.substring(1), 16);
                    LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(stpPortDesignatedBridge.substring(4));
                    if (designatedNode == null) {
                        LogUtils.debugf((Object)this, (String)"run: no nodeid found for STP bridge address %s. Nothing to save.", (Object[])new Object[]{stpPortDesignatedBridge});
                        continue;
                    }
                    int designatednodeid = designatedNode.getNodeId();
                    LogUtils.debugf((Object)this, (String)"run: found designated nodeid %d", (Object[])new Object[]{designatednodeid});
                    if (!this.isNearestBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport)) continue;
                    int curIfIndex = curNode.getIfindex(stpbridgeport);
                    if (curIfIndex == -1) {
                        LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on node: %s", (Object[])new Object[]{curNode.toString()});
                        continue;
                    }
                    int designatedifindex = designatedNode.getIfindex(designatedbridgeport);
                    if (designatedifindex == -1) {
                        LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on designated node: %s", (Object[])new Object[]{designatedNode.toString()});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding to bridge %d.", (Object[])new Object[]{curNodeId, stpbridgeport});
                    curNode.addBackBoneBridgePorts(stpbridgeport);
                    this.m_bridgeNodes.put(curNodeId, curNode);
                    LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding to helper class BB port bridge port %d.", (Object[])new Object[]{designatednodeid, designatedbridgeport});
                    designatedNode.addBackBoneBridgePorts(designatedbridgeport);
                    this.m_bridgeNodes.put(designatednodeid, designatedNode);
                    LogUtils.debugf((Object)this, (String)"run: adding links on BB bridge port %d", (Object[])new Object[]{designatedbridgeport});
                    this.addLinks(this.getMacsOnBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport), curNodeId, curIfIndex);
                    NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                    lk.setNodeparentid(designatednodeid);
                    lk.setParentifindex(designatedifindex);
                    LogUtils.infof((Object)this, (String)("run: saving STP bridge link: " + lk.toString()), (Object[])new Object[0]);
                    this.addNodetoNodeLink(lk);
                }
            }
            LogUtils.infof((Object)this, (String)"run: done parsing bridge nodeid %d IP address %s with %d VLANs", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)cupIpAddr), curNode.getStpInterfaces().size()});
        }
        if (this.m_bridgeNodes.size() > 0) {
            LogUtils.infof((Object)this, (String)"run: done finding backbone ethernet links among bridge nodes using Spanning Tree Protocol", (Object[])new Object[0]);
        }
    }

    private void getLinksFromRouteTable() {
        if (this.m_routerNodes.size() > 0) {
            LogUtils.infof((Object)this, (String)"run: finding non-ethernet links on Router nodes", (Object[])new Object[0]);
        }
        for (LinkableNode curNode : this.m_routerNodes) {
            int curNodeId = curNode.getNodeId();
            InetAddress curIpAddr = curNode.getSnmpPrimaryIpAddr();
            LogUtils.infof((Object)this, (String)"run: parsing router node with ID %d IP address %s and %d router interfaces", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), curNode.getRouteInterfaces().size()});
            for (RouterInterface routeIface : curNode.getRouteInterfaces()) {
                LogUtils.debugf((Object)this, (String)("run: parsing RouterInterface: " + routeIface.toString()), (Object[])new Object[0]);
                if (routeIface.getMetric() == -1) {
                    LogUtils.warnf((Object)this, (String)"run: Router interface has invalid metric %d. Skipping.", (Object[])new Object[]{routeIface.getMetric()});
                    continue;
                }
                if (this.forceIpRouteDiscoveryOnEtherNet) {
                    LogUtils.debugf((Object)this, (String)"run: forceIpRouteDiscoveryOnEtherNet is set, skipping validation of the SNMP interface type", (Object[])new Object[0]);
                } else {
                    int snmpiftype = routeIface.getSnmpiftype();
                    LogUtils.debugf((Object)this, (String)("run: force IP route discovery getting SnmpIfType: " + snmpiftype), (Object[])new Object[0]);
                    if (snmpiftype == 6) {
                        LogUtils.debugf((Object)this, (String)"run: Ethernet interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                        continue;
                    }
                    if (snmpiftype == 53) {
                        LogUtils.debugf((Object)this, (String)"run: PropVirtual interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                        continue;
                    }
                    if (snmpiftype == 135) {
                        LogUtils.debugf((Object)this, (String)"run: Layer2 VLAN interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                        continue;
                    }
                    if (snmpiftype == 136) {
                        LogUtils.debugf((Object)this, (String)"run: Layer3 VLAN interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                        continue;
                    }
                    if (snmpiftype == -1) {
                        LogUtils.debugf((Object)this, (String)"run: interface on node %d has unknown snmpiftype %d. Skipping.", (Object[])new Object[]{curNodeId, snmpiftype});
                        continue;
                    }
                }
                InetAddress nexthop = routeIface.getNextHop();
                String hostAddress = InetAddressUtils.str((InetAddress)nexthop);
                if (hostAddress.equals("0.0.0.0")) {
                    LogUtils.debugf((Object)this, (String)"run: nexthop address is broadcast address %s. Skipping.", (Object[])new Object[]{hostAddress});
                    continue;
                }
                if (nexthop.isLoopbackAddress()) {
                    LogUtils.debugf((Object)this, (String)"run: nexthop address is localhost address %s. Skipping.", (Object[])new Object[]{hostAddress});
                    continue;
                }
                if (!this.m_linkd.isInterfaceInPackage(nexthop, this.getPackageName())) {
                    LogUtils.debugf((Object)this, (String)"run: nexthop address is not in package %s/%s. Skipping.", (Object[])new Object[]{hostAddress, this.getPackageName()});
                    continue;
                }
                int nextHopNodeid = routeIface.getNextHopNodeid();
                if (nextHopNodeid == -1) {
                    LogUtils.debugf((Object)this, (String)"run: no node id found for IP next hop address %s. Skipping.", (Object[])new Object[]{hostAddress});
                    continue;
                }
                if (nextHopNodeid == curNodeId) {
                    LogUtils.debugf((Object)this, (String)"run: node id found for IP next hop address %s is itself. Skipping.", (Object[])new Object[]{hostAddress});
                    continue;
                }
                int ifindex = routeIface.getIfindex();
                if (ifindex == 0) {
                    LogUtils.debugf((Object)this, (String)"run: route interface has ifindex %d, trying to get ifIndex from nextHopNet: %s", (Object[])new Object[]{ifindex, routeIface.getNextHopNet()});
                    ifindex = this.getIfIndexFromRouter(curNode, routeIface.getNextHopNet());
                    if (ifindex == -1) {
                        LogUtils.debugf((Object)this, (String)"run: found not correct ifindex %d. Skipping.", (Object[])new Object[]{ifindex});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: found correct ifindex %d.", (Object[])new Object[]{ifindex});
                }
                NodeToNodeLink lk = new NodeToNodeLink(nextHopNodeid, routeIface.getNextHopIfindex());
                lk.setNodeparentid(curNodeId);
                lk.setParentifindex(ifindex);
                LogUtils.infof((Object)this, (String)("run: saving route link: " + lk.toString()), (Object[])new Object[0]);
                this.addNodetoNodeLink(lk);
            }
            LogUtils.infof((Object)this, (String)"run: done parsing router node with ID %d IP address %s and %d router interfaces", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), curNode.getRouteInterfaces().size()});
        }
        if (this.m_routerNodes.size() > 0) {
            LogUtils.infof((Object)this, (String)"run: done finding non-ethernet links on Router nodes", (Object[])new Object[0]);
        }
    }

    private boolean addCdpLink(NodeToNodeLink cdplink) {
        for (NodeToNodeLink currcdplink : this.m_cdpLinks) {
            if (!currcdplink.equals(cdplink)) continue;
            return false;
        }
        this.m_cdpLinks.add(cdplink);
        return true;
    }

    private void addCdpLinks(LinkableNode curNode) {
        int curCdpNodeId = curNode.getNodeId();
        InetAddress curCdpIpAddr = curNode.getSnmpPrimaryIpAddr();
        LogUtils.infof((Object)this, (String)"run: parsing nodeid %d IP address %s with %d CDP interfaces.", (Object[])new Object[]{curCdpNodeId, curCdpIpAddr, curNode.getCdpInterfaces().size()});
        for (CdpInterface cdpIface : curNode.getCdpInterfaces()) {
            InetAddress targetIpAddr = cdpIface.getCdpTargetIpAddr();
            String hostAddress = InetAddressUtils.str((InetAddress)targetIpAddr);
            if (!this.m_linkd.isInterfaceInPackage(targetIpAddr, this.getPackageName())) {
                LogUtils.debugf((Object)this, (String)"run: IP address %s Not in package: %s.  Skipping.", (Object[])new Object[]{hostAddress, this.getPackageName()});
                continue;
            }
            int targetCdpNodeId = cdpIface.getCdpTargetNodeId();
            if (targetCdpNodeId == curCdpNodeId) {
                LogUtils.debugf((Object)this, (String)"run: node id found for IP address %s is itself.  Skipping.", (Object[])new Object[]{hostAddress});
                continue;
            }
            NodeToNodeLink link = new NodeToNodeLink(cdpIface.getCdpTargetNodeId(), cdpIface.getCdpTargetIfIndex());
            link.setNodeparentid(curNode.getNodeId());
            link.setParentifindex(cdpIface.getCdpIfIndex());
            this.addCdpLink(link);
        }
    }

    private void getLinksFromCdp() {
        LogUtils.infof((Object)this, (String)"run: adding links using Cisco Discovery Protocol", (Object[])new Object[0]);
        LogUtils.infof((Object)this, (String)"run: found # %d links using Cisco Discovery Protocol", (Object[])new Object[]{this.m_cdpLinks.size()});
        for (NodeToNodeLink cdplink : this.m_cdpLinks) {
            LinkableNode node;
            int curCdpNodeId = cdplink.getNodeId();
            int cdpIfIndex = cdplink.getIfindex();
            int targetCdpNodeId = cdplink.getNodeparentid();
            int cdpDestIfindex = cdplink.getParentifindex();
            LogUtils.infof((Object)this, (String)"run: parsing CDP link: %s", (Object[])new Object[]{cdplink.toString()});
            if (this.isBridgeNode(curCdpNodeId) && (node = this.m_bridgeNodes.get(curCdpNodeId)).isBackBoneBridgePort(node.getBridgePort(cdpIfIndex))) {
                LogUtils.debugf((Object)this, (String)"run: source node is bridge node, and port is backbone port! Skipping.", (Object[])new Object[0]);
                return;
            }
            if (this.isBridgeNode(targetCdpNodeId) && (node = this.m_bridgeNodes.get(targetCdpNodeId)).isBackBoneBridgePort(node.getBridgePort(cdpDestIfindex))) {
                LogUtils.debugf((Object)this, (String)"run: target node is bridge node, and port is backbone port! Skipping.", (Object[])new Object[0]);
                return;
            }
            this.addNodetoNodeLink(cdplink);
            LogUtils.infof((Object)this, (String)"run: CDP link added", (Object[])new Object[0]);
        }
        LogUtils.infof((Object)this, (String)"run: done addind Cisco Discovery Protocol links.", (Object[])new Object[0]);
    }

    private void getLinksFromOspf() {
        LogUtils.infof((Object)this, (String)"run: adding links using Open Short Path First Protocol", (Object[])new Object[0]);
        int i = 0;
        for (LinkableNode linknode1 : this.m_ospfNodes) {
            for (LinkableNode linknode2 : this.m_ospfNodes) {
                if (linknode1.getNodeId() >= linknode2.getNodeId()) continue;
                for (NodeToNodeLink lldpLink : this.getOspfLink(linknode1, linknode2)) {
                    this.addNodetoNodeLink(lldpLink);
                    ++i;
                }
            }
        }
        LogUtils.infof((Object)this, (String)"run: done OSPF. Found links # %d.", (Object[])new Object[]{i});
    }

    private List<NodeToNodeLink> getOspfLink(LinkableNode linknode1, LinkableNode linknode2) {
        LogUtils.infof((Object)this, (String)"run: finding OSPF links between node with id %d and node with id %d.", (Object[])new Object[]{linknode1.getNodeId(), linknode2.getNodeId()});
        ArrayList<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
        for (OspfNbrInterface ospf : linknode1.getOspfinterfaces()) {
            for (OspfNbrInterface ospf2 : linknode2.getOspfinterfaces()) {
                if (!ospf.getOspfNbrRouterId().equals(linknode2.getOspfRouterId()) || ospf.getOspfNbrNodeId() != linknode2.getNodeId() || !ospf2.getOspfNbrRouterId().equals(linknode1.getOspfRouterId()) || ospf2.getOspfNbrNodeId() != linknode1.getNodeId() || !this.getSubnetAddress(ospf).equals(this.getSubnetAddress(ospf2))) continue;
                NodeToNodeLink link = new NodeToNodeLink(ospf.getOspfNbrNodeId(), ospf.getOspfNbrIfIndex());
                link.setNodeparentid(ospf2.getOspfNbrNodeId());
                link.setParentifindex(ospf2.getOspfNbrIfIndex());
                links.add(link);
            }
        }
        return links;
    }

    protected InetAddress getSubnetAddress(OspfNbrInterface ospfinterface) {
        byte[] ip = ospfinterface.getOspfNbrIpAddr().getAddress();
        byte[] nm = ospfinterface.getOspfNbrNetMask().getAddress();
        try {
            return InetAddress.getByAddress(new byte[]{(byte)(ip[0] & nm[0]), (byte)(ip[1] & nm[1]), (byte)(ip[2] & nm[2]), (byte)(ip[3] & nm[3])});
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void getLinkdFromLldp() {
        LogUtils.infof((Object)this, (String)"run: adding links using Layer Link Discovery Protocol", (Object[])new Object[0]);
        int i = 0;
        for (LinkableNode linknode1 : this.m_lldpNodes) {
            for (LinkableNode linknode2 : this.m_lldpNodes) {
                if (linknode1.getNodeId() == linknode2.getNodeId()) continue;
                for (NodeToNodeLink lldpLink : this.getLldpLink(linknode1, linknode2)) {
                    this.addNodetoNodeLink(lldpLink);
                    ++i;
                }
            }
        }
        LogUtils.infof((Object)this, (String)"run: done LLDP. Found links # %d.", (Object[])new Object[]{i});
    }

    private List<NodeToNodeLink> getLldpLink(LinkableNode linknode1, LinkableNode linknode2) {
        LogUtils.infof((Object)this, (String)"run: finding LLDP links between node parent with id %d and node with id %d.", (Object[])new Object[]{linknode1.getNodeId(), linknode2.getNodeId()});
        ArrayList<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
        for (LldpRemInterface lldpremiface : linknode1.getLldpRemInterfaces()) {
            if (lldpremiface.getLldpRemChassidSubtype() != linknode2.getLldpChassisIdSubtype() || !lldpremiface.getLldpRemChassisid().equals(linknode2.getLldpChassisId())) continue;
            LogUtils.debugf((Object)this, (String)"run: found LLDP interface %s", (Object[])new Object[]{lldpremiface.toString()});
            NodeToNodeLink link = new NodeToNodeLink(linknode2.getNodeId(), lldpremiface.getLldpRemIfIndex());
            link.setNodeparentid(linknode1.getNodeId());
            link.setParentifindex(lldpremiface.getLldpLocIfIndex());
            links.add(link);
        }
        return links;
    }

    private int getIfIndexFromRouter(LinkableNode parentnode, InetAddress nextHopNet) {
        if (!parentnode.hasRouteInterfaces()) {
            return -1;
        }
        for (RouterInterface curIface : parentnode.getRouteInterfaces()) {
            int ifindex;
            if (curIface.getMetric() == -1 || (ifindex = curIface.getIfindex()) == 0 || ifindex == -1 || !curIface.getRouteNet().equals(nextHopNet)) continue;
            return ifindex;
        }
        return -1;
    }

    boolean isBridgeNode(int nodeid) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isRouterNode(int nodeid) {
        for (LinkableNode curNode : this.m_routerNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        LogUtils.debugf((Object)this, (String)"isNearestBridgeLink: bridge1/port1 %d/%d bridge2/port2 %d/%d", (Object[])new Object[]{bridge1.getNodeId(), bp1, bridge2.getNodeId(), bp2});
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null || macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            LogUtils.debugf((Object)this, (String)"isNearestBridgeLink: no macs found on at least one bridge port, nearest bridges found. Return true.", (Object[])new Object[0]);
            return true;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            LogUtils.debugf((Object)this, (String)"isNearestBridgeLink: parsing mac address %s on bridge1", (Object[])new Object[]{curMacOnBridge1});
            if (bridge2.isBridgeIdentifier(curMacOnBridge1)) {
                LogUtils.debugf((Object)this, (String)"isNearestBridgeLink: mac address %s is bridge identifier on bridge2. Continue", (Object[])new Object[]{curMacOnBridge1});
                continue;
            }
            if (bridge1.isBridgeIdentifier(curMacOnBridge1)) {
                LogUtils.debugf((Object)this, (String)"isNearestBridgeLink: mac address %s is bridge identifier on bridge1. Continue", (Object[])new Object[]{curMacOnBridge1});
                continue;
            }
            if (!macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            LogUtils.debugf((Object)this, (String)"isNearestBridgeLink: mac address %s is bridge identifier. Other bridge found. Return false", (Object[])new Object[]{curMacOnBridge1});
            return false;
        }
        return true;
    }

    private Set<String> getMacsOnBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        HashSet<String> macsOnLink = new HashSet<String>();
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return null;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return null;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1)) continue;
            macsOnLink.add(curMacOnBridge1);
        }
        return macsOnLink;
    }

    private boolean isMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return true;
        }
        return false;
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    private List<LinkableNode> getBridgesFromMacs(Set<String> macs) {
        ArrayList<LinkableNode> bridges = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            for (String curBridgeIdentifier : curNode.getBridgeIdentifiers()) {
                if (!macs.contains(curBridgeIdentifier)) continue;
                bridges.add(curNode);
            }
        }
        return bridges;
    }

    private int getBridgePortOnEndBridge(LinkableNode startBridge, LinkableNode endBridge) {
        int port = -1;
        for (String curBridgeIdentifier : startBridge.getBridgeIdentifiers()) {
            LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: parsing bridge identifier " + curBridgeIdentifier), (Object[])new Object[0]);
            if (endBridge.hasMacAddress(curBridgeIdentifier)) {
                for (Integer p : endBridge.getBridgePortsFromMac(curBridgeIdentifier)) {
                    port = p;
                    if (endBridge.isBackBoneBridgePort(port)) {
                        LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: found backbone bridge port " + port + " .... Skipping."), (Object[])new Object[0]);
                        continue;
                    }
                    if (port == -1) {
                        LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: no port found on bridge nodeid " + endBridge.getNodeId() + " for node bridge identifiers nodeid " + startBridge.getNodeId() + " . .....Skipping."), (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: using MAC address table found bridge port " + port + " on node " + endBridge.getNodeId()), (Object[])new Object[0]);
                    return port;
                }
                continue;
            }
            LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: bridge identifier not found on node " + endBridge.getNodeId()), (Object[])new Object[0]);
        }
        return -1;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.discovery_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval, this);
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public long getDiscoveryInterval() {
        return this.discovery_interval;
    }

    public void setSnmpPollInterval(long interval) {
        this.snmp_poll_interval = interval;
    }

    public long getSnmpPollInterval() {
        return this.snmp_poll_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_interval = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.m_links.toArray(new NodeToNodeLink[0]);
    }

    public MacToNodeLink[] getMacLinks() {
        return this.m_maclinks.toArray(new MacToNodeLink[0]);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("unschedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.isRunned) {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval + this.initial_sleep_time + this.discovery_interval);
        }
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink) {
        if (nnlink == null) {
            LogUtils.warnf((Object)this, (String)"addNodetoNodeLink: node link is null.", (Object[])new Object[0]);
            return;
        }
        for (NodeToNodeLink curNnLink : this.m_links) {
            if (!curNnLink.equals(nnlink)) continue;
            LogUtils.infof((Object)this, (String)"addNodetoNodeLink: link %s exists, not adding", (Object[])new Object[]{nnlink.toString()});
            return;
        }
        if (nnlink.getNodeId() == nnlink.getNodeparentid()) {
            LogUtils.debugf((Object)this, (String)"addNodetoNodeLink: skipping self node link %s", (Object[])new Object[]{nnlink.toString()});
        } else {
            LogUtils.debugf((Object)this, (String)"addNodetoNodeLink: adding link %s", (Object[])new Object[]{nnlink.toString()});
            this.m_links.add(nnlink);
        }
    }

    private void addLinks(Set<String> macs, int nodeid, int ifindex) {
        if (macs == null || macs.isEmpty()) {
            LogUtils.debugf((Object)this, (String)"addLinks: MAC address list on link is empty.", (Object[])new Object[0]);
        } else {
            for (String curMacAddress : macs) {
                if (this.m_macsParsed.contains(curMacAddress)) {
                    LogUtils.warnf((Object)this, (String)("addLinks: MAC address " + curMacAddress + " just found on other bridge port! Skipping..."), (Object[])new Object[0]);
                    continue;
                }
                if (this.macsExcluded.contains(curMacAddress)) {
                    LogUtils.warnf((Object)this, (String)("addLinks: MAC address " + curMacAddress + " is excluded from discovery package! Skipping..."), (Object[])new Object[0]);
                    continue;
                }
                if (this.m_linkd.getAtInterfaces(this.getPackageName()) != null && this.m_linkd.getAtInterfaces(this.getPackageName()).containsKey(curMacAddress)) {
                    List<AtInterface> ats = this.m_linkd.getAtInterfaces(this.getPackageName()).get(curMacAddress);
                    for (AtInterface at : ats) {
                        NodeToNodeLink lNode = new NodeToNodeLink(at.getNodeid(), at.getIfIndex());
                        lNode.setNodeparentid(nodeid);
                        lNode.setParentifindex(ifindex);
                        this.addNodetoNodeLink(lNode);
                    }
                } else {
                    LogUtils.debugf((Object)this, (String)"addLinks: not find nodeid for ethernet MAC address %s found on node/ifindex %d/%d", (Object[])new Object[]{curMacAddress, nodeid, ifindex});
                    MacToNodeLink lMac = new MacToNodeLink(curMacAddress);
                    lMac.setNodeparentid(nodeid);
                    lMac.setParentifindex(ifindex);
                    this.m_maclinks.add(lMac);
                }
                this.m_macsParsed.add(curMacAddress);
            }
        }
    }

    @Override
    public boolean equals(ReadyRunnable r) {
        return r instanceof DiscoveryLink && this.getPackageName().equals(r.getPackageName());
    }

    @Override
    public String getInfo() {
        return " Ready Runnable Discovery Link discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes/package: " + this.discoveryUsingBridge() + "/" + this.discoveryUsingCdp() + "/" + this.discoveryUsingRoutes() + "/" + this.getPackageName();
    }

    public boolean discoveryUsingBridge() {
        return this.discoveryUsingBridge;
    }

    public void setDiscoveryUsingBridge(boolean discoveryUsingBridge) {
        this.discoveryUsingBridge = discoveryUsingBridge;
    }

    public boolean discoveryUsingOspf() {
        return this.discoveryUsingOspf;
    }

    public void setDiscoveryUsingOspf(boolean discoveryUsingOspf) {
        this.discoveryUsingOspf = discoveryUsingOspf;
    }

    public boolean discoveryUsingLldp() {
        return this.discoveryUsingLldp;
    }

    public void setDiscoveryUsingLldp(boolean discoveryUsingLldp) {
        this.discoveryUsingLldp = discoveryUsingLldp;
    }

    public boolean discoveryUsingCdp() {
        return this.discoveryUsingCdp;
    }

    public void setDiscoveryUsingCdp(boolean discoveryUsingCdp) {
        this.discoveryUsingCdp = discoveryUsingCdp;
    }

    public boolean discoveryUsingRoutes() {
        return this.discoveryUsingRoutes;
    }

    public void setDiscoveryUsingRoutes(boolean discoveryUsingRoutes) {
        this.discoveryUsingRoutes = discoveryUsingRoutes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBridgeNodes() {
        LogUtils.debugf((Object)this, (String)"parseBridgeNodes: searching bridge port for bridge identifier not yet already found. Iterating on bridge nodes.", (Object[])new Object[0]);
        ArrayList<LinkableNode> bridgenodeschanged = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            LogUtils.debugf((Object)this, (String)"parseBridgeNodes: parsing bridge: %d/%s", (Object[])new Object[]{curNode.getNodeId(), curNode.getSnmpPrimaryIpAddr()});
            List<String> macs = this.getNotAlreadyFoundMacsOnNode(curNode);
            if (macs.isEmpty()) continue;
            SnmpAgentConfig agentConfig = null;
            String className = null;
            LinkdConfig linkdConfig = this.m_linkd.getLinkdConfig();
            linkdConfig.getReadLock().lock();
            try {
                InetAddress addr;
                boolean useVlan = linkdConfig.isVlanDiscoveryEnabled();
                if (linkdConfig.getPackage(this.getPackageName()).hasEnableVlanDiscovery()) {
                    useVlan = linkdConfig.getPackage(this.getPackageName()).getEnableVlanDiscovery();
                }
                if (useVlan && linkdConfig.hasClassName(curNode.getSysoid())) {
                    className = linkdConfig.getVlanClassName(curNode.getSysoid());
                }
                if ((addr = curNode.getSnmpPrimaryIpAddr()) == null) {
                    LogUtils.errorf((Object)this, (String)"parseBridgeNodes: Failed to load SNMP parameter from SNMP configuration file.", (Object[])new Object[0]);
                    return;
                }
                agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(addr);
                String community = agentConfig.getReadCommunity();
                for (String mac : macs) {
                    LogUtils.debugf((Object)this, (String)"parseBridgeNodes: parsing MAC: %s", (Object[])new Object[]{mac});
                    if (className != null && (className.equals(CiscoVlanTable.class.getName()) || className.equals(IntelVlanTable.class.getName()))) {
                        for (OnmsVlan vlan : curNode.getVlans()) {
                            if (vlan.getVlanStatus() != 1 || vlan.getVlanType() != 1) {
                                LogUtils.debugf((Object)this, (String)"parseBridgeNodes: skipping VLAN: %s", (Object[])new Object[]{vlan.getVlanName()});
                                continue;
                            }
                            agentConfig.setReadCommunity(community + "@" + vlan.getVlanId());
                            curNode = DiscoveryLink.collectMacAddress(this, agentConfig, curNode, mac, vlan.getVlanId());
                            agentConfig.setReadCommunity(community);
                        }
                        continue;
                    }
                    int vlan = 1;
                    if (useVlan) {
                        vlan = 0;
                    }
                    curNode = DiscoveryLink.collectMacAddress(this, agentConfig, curNode, mac, vlan);
                }
                bridgenodeschanged.add(curNode);
            }
            finally {
                linkdConfig.getReadLock().unlock();
            }
        }
        for (LinkableNode node : bridgenodeschanged) {
            this.m_bridgeNodes.put(node.getNodeId(), node);
        }
    }

    private static LinkableNode collectMacAddress(DiscoveryLink discoveryLink, SnmpAgentConfig agentConfig, LinkableNode node, String mac, int vlan) {
        FdbTableGet coll = new FdbTableGet(agentConfig, mac);
        LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: finding entry in bridge forwarding table for MAC on node: %s/%d", (Object[])new Object[]{mac, node.getNodeId()});
        int bridgeport = coll.getBridgePort();
        if (bridgeport > 0 && coll.getBridgePortStatus() == 3) {
            node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
            LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: found MAC on bridge port: %d", (Object[])new Object[]{bridgeport});
        } else {
            bridgeport = coll.getQBridgePort();
            if (bridgeport > 0 && coll.getQBridgePortStatus() == 3) {
                node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
                LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: found MAC on bridge port: %d", (Object[])new Object[]{bridgeport});
            } else {
                LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: MAC not found: %d", (Object[])new Object[]{bridgeport});
            }
        }
        return node;
    }

    private List<String> getNotAlreadyFoundMacsOnNode(LinkableNode node) {
        LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Searching Not Yet Found Bridge Identifier Occurrence on Node: %d", (Object[])new Object[]{node.getNodeId()});
        ArrayList<String> macs = new ArrayList<String>();
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (node.getNodeId() == curNode.getNodeId()) continue;
            for (String curMac : curNode.getBridgeIdentifiers()) {
                if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
                LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Found a node/Bridge Identifier %d/%s that was not found in bridge forwarding table for bridge node: %d", (Object[])new Object[]{curNode.getNodeId(), curMac, node.getNodeId()});
                macs.add(curMac);
            }
        }
        LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Searching Not Yet Found MAC Address Occurrence on Node: %d", (Object[])new Object[]{node.getNodeId()});
        if (this.getLinkd().getAtInterfaces(this.getPackageName()) != null) {
            for (String curMac : this.getLinkd().getAtInterfaces(this.getPackageName()).keySet()) {
                if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
                LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Found a MAC Address %s that was not found in bridge forwarding table for bridge node: %d", (Object[])new Object[]{curMac, node.getNodeId()});
                macs.add(curMac);
            }
        }
        return macs;
    }

    public boolean isEnableDownloadDiscovery() {
        return this.enableDownloadDiscovery;
    }

    public void setEnableDownloadDiscovery(boolean enableDownloaddiscovery) {
        this.enableDownloadDiscovery = enableDownloaddiscovery;
    }

    public boolean isForceIpRouteDiscoveryOnEtherNet() {
        return this.forceIpRouteDiscoveryOnEtherNet;
    }

    public void setForceIpRouteDiscoveryOnEtherNet(boolean forceIpRouteDiscoveryOnEtherNet) {
        this.forceIpRouteDiscoveryOnEtherNet = forceIpRouteDiscoveryOnEtherNet;
    }
}

