/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.EventConstants;

public final class DbAtInterfaceEntry {
    public static final char STATUS_ACTIVE = 'A';
    public static final char STATUS_NOT_POLLED = 'N';
    public static final char STATUS_DELETED = 'D';
    public static final char STATUS_UNKNOWN = 'K';
    private final int m_nodeId;
    private final InetAddress m_ipaddr;
    String m_physaddr;
    int m_sourcenodeid;
    int m_ifindex;
    char m_status = (char)75;
    Timestamp m_lastPollTime;
    private static final String SQL_LOAD_ATINTERFACE = "SELECT atphysaddr,sourceNodeid,ifindex,status,lastpolltime FROM atinterface WHERE nodeid = ? AND ipaddr = ? ";
    private boolean m_fromDb;
    private int m_changed;
    private static final int CHANGED_PHYSADDR = 1;
    private static final int CHANGED_SOURCE = 2;
    private static final int CHANGED_IFINDEX = 4;
    private static final int CHANGED_STATUS = 8;
    private static final int CHANGED_POLLTIME = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The ARP interface record already exists in the database");
        }
        StringBuffer names = new StringBuffer("INSERT INTO AtInterface (nodeid,ipaddr");
        StringBuffer values = new StringBuffer("?,?");
        if ((this.m_changed & 1) == 1) {
            values.append(",?");
            names.append(",atphysaddr");
        }
        if ((this.m_changed & 2) == 2) {
            values.append(",?");
            names.append(",sourceNodeid");
        }
        if ((this.m_changed & 4) == 4) {
            values.append(",?");
            names.append(",ifindex");
        }
        if ((this.m_changed & 8) == 8) {
            values.append(",?");
            names.append(",status");
        }
        if ((this.m_changed & 0x10) == 16) {
            values.append(",?");
            names.append(",lastpolltime");
        }
        names.append(") VALUES (").append(values).append(')');
        LogUtils.debugf((Object)this, (String)("AtInterfaceEntry.insert: SQL insert statment = " + names.toString()), (Object[])new Object[0]);
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(names.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setString(ndx++, InetAddressUtils.str((InetAddress)this.m_ipaddr));
            if ((this.m_changed & 1) == 1) {
                stmt.setString(ndx++, this.m_physaddr);
            }
            if ((this.m_changed & 2) == 2) {
                stmt.setInt(ndx++, this.m_sourcenodeid);
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setInt(ndx++, this.m_ifindex);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setTimestamp(ndx++, this.m_lastPollTime);
            }
            int rc = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("AtInterfaceEntry.insert: row " + rc), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        StringBuffer sqlText = new StringBuffer("UPDATE AtInterface SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("atphysaddr = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("sourcenodeid = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("ifindex = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("lastpolltime = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeid = ? AND ipaddr = ? ");
        LogUtils.debugf((Object)this, (String)("AtInterfaceEntry.update: SQL insert statment = " + sqlText.toString()), (Object[])new Object[0]);
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(sqlText.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            if ((this.m_changed & 1) == 1) {
                stmt.setString(ndx++, this.m_physaddr);
            }
            if ((this.m_changed & 2) == 2) {
                stmt.setInt(ndx++, this.m_sourcenodeid);
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setInt(ndx++, this.m_ifindex);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setTimestamp(ndx++, this.m_lastPollTime);
            }
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setString(ndx++, InetAddressUtils.str((InetAddress)this.m_ipaddr));
            int rc = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("AtInterfaceEntry.update: row " + rc), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String str;
            stmt = c.prepareStatement(SQL_LOAD_ATINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            stmt.setString(2, InetAddressUtils.str((InetAddress)this.m_ipaddr));
            ResultSet rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                LogUtils.debugf((Object)this, (String)"AtInterfaceEntry.load: no result found", (Object[])new Object[0]);
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            this.m_physaddr = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_physaddr = null;
            }
            this.m_sourcenodeid = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_sourcenodeid = -1;
            }
            this.m_ifindex = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifindex = -1;
            }
            this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)75;
            this.m_lastPollTime = rset.getTimestamp(ndx++);
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
        LogUtils.debugf((Object)this, (String)"AtInterfaceEntry.load: result found", (Object[])new Object[0]);
        return true;
    }

    private DbAtInterfaceEntry(int nodeId, InetAddress ipaddr, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_fromDb = exists;
        this.m_sourcenodeid = -1;
        this.m_ifindex = -1;
        this.m_ipaddr = ipaddr;
        this.m_physaddr = null;
    }

    static DbAtInterfaceEntry create(int nodeid, InetAddress ipaddr) {
        return new DbAtInterfaceEntry(nodeid, ipaddr, false);
    }

    protected int get_nodeId() {
        return this.m_nodeId;
    }

    protected InetAddress get_ipaddr() {
        return this.m_ipaddr;
    }

    protected String get_physaddr() {
        return this.m_physaddr;
    }

    protected void set_physaddr(String macaddr) {
        this.m_physaddr = macaddr;
        this.m_changed |= 1;
    }

    protected boolean hasAtPhysAddrChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateAtPhysAddr(String macaddr) {
        if (this.m_physaddr == null || !this.m_physaddr.equals(macaddr)) {
            this.set_physaddr(macaddr);
            return true;
        }
        return false;
    }

    protected int get_sourcenodeid() {
        return this.m_sourcenodeid;
    }

    protected void set_sourcenodeid(int sourcenode) {
        this.m_sourcenodeid = sourcenode;
        this.m_changed |= 2;
    }

    protected boolean hasSourceNodeIdChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateSourceNodeId(int sourcenodeid) {
        if (sourcenodeid != this.m_sourcenodeid) {
            this.set_sourcenodeid(sourcenodeid);
            return true;
        }
        return false;
    }

    protected int get_ifindex() {
        return this.m_ifindex;
    }

    protected void set_ifindex(int ifindex) {
        this.m_ifindex = ifindex;
        this.m_changed |= 4;
    }

    protected boolean hasIfIndexChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateIfIndex(int ifindex) {
        if (ifindex != this.m_ifindex) {
            this.set_ifindex(ifindex);
            return true;
        }
        return false;
    }

    protected char get_status() {
        return this.m_status;
    }

    protected void set_status(char status) {
        if (status == 'A' || status == 'N' || status == 'D') {
            this.m_status = status;
        }
        this.m_changed |= 8;
    }

    protected boolean hasStatusChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateStatus(char status) {
        if (status != this.m_status) {
            this.set_status(status);
            return true;
        }
        return false;
    }

    protected Timestamp get_lastpolltime() {
        return this.m_lastPollTime;
    }

    String getLastPollTimeString() {
        String result = null;
        if (this.m_lastPollTime != null) {
            result = this.m_lastPollTime.toString();
        }
        return result;
    }

    protected void set_lastpolltime(String time) throws ParseException {
        if (time == null) {
            this.m_lastPollTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_lastPollTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x10;
    }

    protected void set_lastpolltime(Date time) {
        this.m_lastPollTime = new Timestamp(time.getTime());
        this.m_changed |= 0x10;
    }

    protected void set_lastpolltime(Timestamp time) {
        this.m_lastPollTime = time;
        this.m_changed |= 0x10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"Exception closing JDBC connection", (Object[])new Object[0]);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbAtInterfaceEntry get(int nid, InetAddress ipaddr) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbAtInterfaceEntry dbAtInterfaceEntry = DbAtInterfaceEntry.get(db, nid, ipaddr);
            return dbAtInterfaceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                LogUtils.warnf(DbAtInterfaceEntry.class, (Throwable)e, (String)"Exception closing JDBC connection", (Object[])new Object[0]);
            }
        }
    }

    static DbAtInterfaceEntry get(Connection db, int nid, InetAddress ipaddr) throws SQLException {
        DbAtInterfaceEntry entry = new DbAtInterfaceEntry(nid, ipaddr, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fromDB?", this.m_fromDb).append("nodeID", this.m_nodeId).append("ipAddress", (Object)this.m_ipaddr).append("physAddress", (Object)this.m_physaddr).append("sourceNodeID", this.m_sourcenodeid).append("ifIndex", this.m_ifindex).append("status", this.m_status).append("lastPollTime", (Object)this.m_lastPollTime).toString();
    }
}

